/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.uml.diagram.profile.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLDocumentProvider;
import org.eclipse.papyrus.uml.diagram.profile.preferences.DiagramPreferenceInitializer;
import org.eclipse.papyrus.uml.diagram.profile.providers.ElementInitializers;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.papyrus.uml.diagram.profile";
    private LogHelper myLogHelper;
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("org.eclipse.papyrus.uml.diagram.profile");
    private static UMLDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private UMLDocumentProvider documentProvider;
    private UMLBaseItemSemanticEditPolicy.LinkConstraints linkConstraints;
    private ElementInitializers initializers;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.myLogHelper = new LogHelper((Plugin)this);
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
        DiagramPreferenceInitializer diagramPreferenceInitializer = new DiagramPreferenceInitializer();
        diagramPreferenceInitializer.initializeDefaultPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        this.linkConstraints = null;
        this.initializers = null;
        instance = null;
        super.stop(context);
    }

    public static UMLDiagramEditorPlugin getInstance() {
        return instance;
    }

    public IPreferenceStore getPreferenceStore() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List<AdapterFactory> factories) {
        factories.add((AdapterFactory)new UMLItemProviderAdapterFactory());
        factories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return UMLDiagramEditorPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, UMLDiagramEditorPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)UMLDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + key));
    }

    public UMLDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new UMLDocumentProvider();
        }
        return this.documentProvider;
    }

    public UMLBaseItemSemanticEditPolicy.LinkConstraints getLinkConstraints() {
        return this.linkConstraints;
    }

    public void setLinkConstraints(UMLBaseItemSemanticEditPolicy.LinkConstraints lc) {
        this.linkConstraints = lc;
    }

    public ElementInitializers getElementInitializers() {
        return this.initializers;
    }

    public void setElementInitializers(ElementInitializers i) {
        this.initializers = i;
    }

    public void logError(String error) {
        this.getLogHelper().warn(error);
    }

    public void logError(String error, Throwable throwable) {
        this.getLogHelper().error(error, throwable);
    }

    public void logInfo(String message) {
        this.getLogHelper().info(message);
    }

    public void logInfo(String message, Throwable throwable) {
        this.getLogHelper().error(message, throwable);
    }

    public LogHelper getLogHelper() {
        return this.myLogHelper;
    }
}

