/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class ExecutionOccurrenceSpecificationMessageCreateCommand
extends EditElementCommand {
    private EObject source;
    private EObject target;

    public ExecutionOccurrenceSpecificationMessageCreateCommand(CreateRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = request.getSource();
        this.target = request.getTarget();
    }

    protected CreateRelationshipRequest getRequest() {
        return (CreateRelationshipRequest)super.getRequest();
    }

    public boolean canExecute() {
        if (this.source != null && this.target != null && this.source == this.target) {
            return false;
        }
        return super.canExecute();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = this.getRequest().getElementType();
        MessageSort messageSort = null;
        if (UMLElementTypes.Message_4003 == elementType) {
            messageSort = MessageSort.SYNCH_CALL_LITERAL;
        } else if (UMLElementTypes.Message_4004 == elementType) {
            messageSort = MessageSort.ASYNCH_CALL_LITERAL;
        } else if (UMLElementTypes.Message_4005 == elementType) {
            messageSort = MessageSort.REPLY_LITERAL;
        } else {
            return CommandResult.newCancelledCommandResult();
        }
        Lifeline sourceLifeline = this.deduceLifeline(this.source);
        Lifeline targetLifeline = this.deduceLifeline(this.target);
        InteractionFragment sourceContainer = (InteractionFragment)this.getRequest().getParameters().get("Source model container");
        InteractionFragment targetContainer = (InteractionFragment)this.getRequest().getParameters().get("Target model container");
        Message message = CommandHelper.doCreateMessage(this.deduceContainer(this.source, this.target), messageSort, (Element)sourceLifeline, (Element)targetLifeline, sourceContainer, targetContainer);
        if (message != null) {
            ExecutionSpecification execution;
            if (this.source instanceof ExecutionOccurrenceSpecification && ((ExecutionOccurrenceSpecification)this.source).getExecution() != null) {
                execution = ((ExecutionOccurrenceSpecification)this.source).getExecution();
                if (this.source == execution.getStart()) {
                    OccurrenceSpecificationHelper.resetExecutionStart(execution, (Element)message.getSendEvent());
                } else if (this.source == execution.getFinish()) {
                    OccurrenceSpecificationHelper.resetExecutionFinish(execution, (Element)message.getSendEvent());
                }
            }
            if (this.target instanceof ExecutionOccurrenceSpecification && ((ExecutionOccurrenceSpecification)this.target).getExecution() != null) {
                execution = ((ExecutionOccurrenceSpecification)this.target).getExecution();
                if (this.target == execution.getStart()) {
                    OccurrenceSpecificationHelper.resetExecutionStart(execution, (Element)message.getReceiveEvent());
                } else if (this.target == execution.getFinish()) {
                    OccurrenceSpecificationHelper.resetExecutionFinish(execution, (Element)message.getReceiveEvent());
                }
            }
            this.doConfigure(message, monitor, info);
            this.getRequest().setNewElement((EObject)message);
            return CommandResult.newOKCommandResult((Object)message);
        }
        return CommandResult.newErrorCommandResult((String)"There is now valid container for events");
    }

    protected void doConfigure(Message newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = this.getRequest().getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(this.getRequest().getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.deduceLifeline(this.source));
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.deduceLifeline(this.target));
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    private Lifeline deduceLifeline(EObject eObject) {
        EList covereds;
        if (eObject instanceof Lifeline) {
            return (Lifeline)eObject;
        }
        if (eObject instanceof ExecutionSpecification) {
            ExecutionSpecification execution = (ExecutionSpecification)eObject;
            if (execution.getStart() != null) {
                return this.deduceLifeline((EObject)execution.getStart());
            }
            if (execution.getFinish() != null) {
                return this.deduceLifeline((EObject)execution.getFinish());
            }
        } else if (eObject instanceof OccurrenceSpecification) {
            OccurrenceSpecification occ = (OccurrenceSpecification)eObject;
            return occ.getCovered();
        }
        if (eObject instanceof InteractionFragment && !(covereds = ((InteractionFragment)eObject).getCovereds()).isEmpty()) {
            return (Lifeline)covereds.get(0);
        }
        return null;
    }

    protected Interaction deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Interaction) {
                return (Interaction)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

