/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ContinuationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomContinuationItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.ContinuationLocator;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomContinuationEditPart
extends ContinuationEditPart
implements IPapyrusEditPart {
    public CustomContinuationEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomContinuationItemSemanticEditPolicy());
    }

    protected void handleNotificationEvent(Notification notification) {
        if (UMLPackage.eINSTANCE.getContinuation_Setting().equals(notification.getFeature())) {
            int newValue;
            IBorderItemLocator borderItemLocator = this.getBorderItemLocator();
            int n = newValue = (Boolean)notification.getNewValue() != false ? 4 : 1;
            if (borderItemLocator instanceof ContinuationLocator) {
                ((ContinuationLocator)borderItemLocator).setPreferredSideOfParent(newValue);
                borderItemLocator.relocate(this.getFigure());
            }
        }
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (this.getModel() != null && this.getModel() == notification.getNotifier() && NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineWidth();
        this.refreshTransparency();
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new CustomContinuationFigure();
        return this.primaryShape;
    }

    @Override
    public CustomContinuationFigure getPrimaryShape() {
        return (CustomContinuationFigure)this.primaryShape;
    }

    public class CustomContinuationFigure
    extends ContinuationEditPart.ContinuationFigure {
        private int transparency = 0;

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            this.applyTransparency(graphics);
            graphics.fillRoundRectangle(this.getBounds(), this.corner.width, this.corner.height);
            graphics.popState();
        }

        public int getTransparency() {
            return this.transparency;
        }

        public void setTransparency(int transparency) {
            if (transparency != this.transparency && transparency >= 0 && transparency <= 100) {
                this.transparency = transparency;
                this.repaint();
            }
        }

        protected void applyTransparency(Graphics g) {
            g.setAlpha(255 - this.transparency * 255 / 100);
        }
    }
}

