/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.tools.listeners.PapyrusStereotypeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractHeadImpactLayoutEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String HEAD_IMPACT_LAYOUT_POLICY = "HeadImpactLayoutEditPolicy";
    protected Element hostSemanticElement;
    protected int currentHeadHeight = -1;

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.getUMLElement();
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().addNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
        this.currentHeadHeight = this.getHeadHeight();
    }

    public void impactLayout() {
        int headHeight = this.getHeadHeight();
        if (this.currentHeadHeight > 0 && headHeight != this.currentHeadHeight) {
            this.doImpactLayout(headHeight - this.currentHeadHeight);
        }
        this.currentHeadHeight = headHeight;
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().removeNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        this.hostSemanticElement = null;
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected Element getUMLElement() {
        EObject element = this.getView().getElement();
        if (element instanceof Element) {
            return (Element)element;
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    public void notifyChanged(Notification notification) {
        Object feature = notification.getFeature();
        boolean headChanged = false;
        if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            headChanged = true;
        } else if (notification.getNotifier() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNotifier()).getSource()) {
            headChanged = true;
        } else if (notification.getNotifier() instanceof DynamicEObjectImpl && this.hostSemanticElement != null && this.hostSemanticElement.getStereotypeApplications().contains(notification.getNotifier())) {
            headChanged = true;
        } else if (22 == notification.getEventType()) {
            headChanged = true;
        } else if (notification instanceof PapyrusStereotypeListener.StereotypeCustomNotification) {
            headChanged = true;
        }
        if (headChanged) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractHeadImpactLayoutEditPolicy.this.impactLayout();
                }
            });
        }
    }

    protected Rectangle getBoundsRect() {
        LayoutConstraint layoutConstraint;
        Rectangle r = new Rectangle();
        View view = this.getView();
        if (view instanceof Node && (layoutConstraint = ((Node)view).getLayoutConstraint()) instanceof Bounds) {
            Bounds b = (Bounds)layoutConstraint;
            r.x = b.getX();
            r.y = b.getY();
            r.width = b.getWidth();
            r.height = b.getHeight();
        }
        Rectangle bounds = this.getHostFigure().getBounds();
        if (r.x == -1) {
            r.x = bounds.x;
        }
        if (r.y == -1) {
            r.y = bounds.y;
        }
        if (r.width == -1) {
            r.width = bounds.width;
        }
        if (r.height == -1) {
            r.height = bounds.height;
        }
        Dimension preferredSize = this.getHostFigure().getPreferredSize();
        if (r.width == 0) {
            r.width = preferredSize.width;
        }
        if (r.height == 0) {
            r.height = preferredSize.height;
        }
        return r;
    }

    protected IFigure getPrimaryShape() {
        if (this.getHost() instanceof IPapyrusEditPart) {
            return ((IPapyrusEditPart)this.getHost()).getPrimaryShape();
        }
        return this.getHostFigure();
    }

    protected TransactionalEditingDomain getEditingDomain() {
        EditPart host = this.getHost();
        if (host instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)host).getEditingDomain();
        }
        return null;
    }

    protected abstract int getHeadHeight();

    protected abstract void doImpactLayout(int var1);
}

