/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message6EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message7EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AbstractHeadImpactLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.StereotypeInteractionFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;

public class InteractionHeadImpactLayoutEditPolicy
extends AbstractHeadImpactLayoutEditPolicy {
    @Override
    protected int getHeadHeight() {
        IFigure primaryShape = this.getPrimaryShape();
        if (primaryShape instanceof StereotypeInteractionFigure) {
            IFigure headContainer = ((StereotypeInteractionFigure)primaryShape).getHeaderLabel().getParent();
            Rectangle boundsRect = this.getBoundsRect();
            return headContainer.getPreferredSize((int)boundsRect.width, (int)-1).height;
        }
        return 0;
    }

    @Override
    protected void doImpactLayout(int resizeDelta) {
        Point pt;
        CompoundCommand commands = new CompoundCommand();
        List children = this.getHost().getChildren();
        ArrayList<GateEditPart> gates = new ArrayList<GateEditPart>();
        for (Object object : children) {
            if (!(object instanceof GateEditPart)) continue;
            gates.add((GateEditPart)((Object)object));
        }
        if (!gates.isEmpty()) {
            Rectangle rect = this.getBoundsRect();
            for (GateEditPart gateEditPart : gates) {
                Node view = (Node)gateEditPart.getNotationView();
                Location location = (Location)view.getLayoutConstraint();
                pt = new Point(location.getX(), location.getY());
                if (pt.x != rect.x - GateEditPart.DEFAULT_SIZE.width / 2 && pt.x != rect.right() - GateEditPart.DEFAULT_SIZE.width / 2) continue;
                commands.appendIfCanExecute((Command)new GMFtoEMFCommandWrapper((ICommand)new SetBoundsCommand(this.getEditingDomain(), "Move gate", (IAdaptable)gateEditPart, pt.getTranslated(0, resizeDelta))));
            }
        }
        List sourceConnections = ((NodeEditPart)this.getHost()).getSourceConnections();
        for (Object object : sourceConnections) {
            String terminal;
            PrecisionPoint pt2;
            Edge edge;
            Anchor sourceAnchor;
            if (!(object instanceof Message7EditPart) || !((sourceAnchor = (edge = (Edge)((Message7EditPart)((Object)object)).getNotationView()).getSourceAnchor()) instanceof IdentityAnchor) || !((pt2 = SlidableAnchor.parseTerminalString((String)(terminal = ((IdentityAnchor)sourceAnchor).getId()))).preciseY() > 1.0)) continue;
            pt2.translate(0, resizeDelta);
            commands.appendIfCanExecute(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)sourceAnchor, (Object)NotationPackage.eINSTANCE.getIdentityAnchor_Id(), (Object)("(" + pt2.preciseX() + "," + pt2.preciseY() + ")")));
        }
        List targetConnections = ((NodeEditPart)this.getHost()).getTargetConnections();
        for (Object object : targetConnections) {
            String terminal;
            AbstractMessageEditPart message;
            Edge edge;
            Anchor targetAnchor;
            if (!(object instanceof Message6EditPart) || !((targetAnchor = (edge = (Edge)(message = (AbstractMessageEditPart)((Object)object)).getNotationView()).getTargetAnchor()) instanceof IdentityAnchor) || !((pt = SlidableAnchor.parseTerminalString((String)(terminal = ((IdentityAnchor)targetAnchor).getId()))).preciseY() > 1.0)) continue;
            pt.translate(0, resizeDelta);
            commands.appendIfCanExecute(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)targetAnchor, (Object)NotationPackage.eINSTANCE.getIdentityAnchor_Id(), (Object)("(" + pt.preciseX() + "," + pt.preciseY() + ")")));
        }
        if (commands.isEmpty() || !commands.canExecute()) {
            return;
        }
        CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), (Command)commands, true);
    }
}

