/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateGateViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Message;

public class FixGateViewOnOpening {
    public void fix(Diagram diagram) {
        TreeIterator contents = diagram.eAllContents();
        while (contents.hasNext()) {
            List<Gate> allGates;
            Shape shape;
            EObject element;
            EObject next = (EObject)contents.next();
            if (!(next instanceof Shape) || !this.isGateContainer(element = ViewUtil.resolveSemanticElement((View)(shape = (Shape)next))) || (allGates = this.getAllGates(element)).isEmpty()) continue;
            for (Gate gate : allGates) {
                this.doFix(diagram, shape, gate);
            }
        }
    }

    private void doFix(Diagram diagram, Shape parent, Gate gate) {
        int index;
        if (UMLVisualIDRegistry.getType(3018).equals(parent.getType())) {
            return;
        }
        View view = this.findPrimaryView(diagram, (EObject)gate);
        if (view != null) {
            return;
        }
        Message message = gate.getMessage();
        if (message == null) {
            return;
        }
        View messageView = this.findPrimaryView(diagram, (EObject)message);
        Edge edge = null;
        if (messageView instanceof Edge) {
            edge = (Edge)messageView;
        }
        Point location = null;
        Rectangle rect = this.getBounds(parent);
        if (message != null && edge != null) {
            if (gate == message.getReceiveEvent() && parent == edge.getTarget()) {
                location = this.getLocation(rect, edge.getTargetAnchor());
            } else if (gate == message.getSendEvent() && parent == edge.getSource()) {
                location = this.getLocation(rect, edge.getSourceAnchor());
            }
        }
        if (location == null && (index = this.indexOfGate(gate)) != -1) {
            if (gate == message.getReceiveEvent()) {
                location = new Point(rect.x, rect.y + GateEditPart.DEFAULT_SIZE.height * index + 2);
            } else if (gate == message.getSendEvent()) {
                location = new Point(rect.right(), rect.y + GateEditPart.DEFAULT_SIZE.height * index + 2);
            }
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        CompositeCommand fixCommands = new CompositeCommand("Fix Gate View");
        CreateGateViewCommand command = new CreateGateViewCommand(editingDomain, (IAdaptable)new EObjectAdapter((EObject)parent), location, (IAdaptable)new EObjectAdapter((EObject)gate));
        fixCommands.add((IUndoableOperation)command);
        if (message != null && edge != null) {
            SetConnectionEndsCommand redirectCommand = new SetConnectionEndsCommand(editingDomain, "Reset Message End");
            redirectCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)messageView));
            SetConnectionAnchorsCommand repairAnchorsCommand = new SetConnectionAnchorsCommand(editingDomain, "Repair Anchors on Gate");
            repairAnchorsCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)messageView));
            if (gate == message.getReceiveEvent() && parent == edge.getTarget()) {
                redirectCommand.setNewTargetAdaptor(command.getResult());
                repairAnchorsCommand.setNewTargetTerminal("(0,0.5)");
            } else if (gate == message.getSendEvent() && parent == edge.getSource()) {
                redirectCommand.setNewSourceAdaptor(command.getResult());
                repairAnchorsCommand.setNewSourceTerminal("(1,0.5)");
            }
            if (redirectCommand.canExecute()) {
                fixCommands.add((IUndoableOperation)redirectCommand);
            }
            if (repairAnchorsCommand.canExecute()) {
                fixCommands.add((IUndoableOperation)repairAnchorsCommand);
            }
        }
        editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)fixCommands));
    }

    private int indexOfGate(Gate gate) {
        if (gate == null || gate.eContainer() == null) {
            return -1;
        }
        EObject parent = gate.eContainer();
        if (parent instanceof CombinedFragment) {
            return ((CombinedFragment)parent).getCfragmentGates().indexOf((Object)gate);
        }
        if (parent instanceof InteractionUse) {
            return ((InteractionUse)parent).getActualGates().indexOf((Object)gate);
        }
        if (parent instanceof Interaction) {
            return ((Interaction)parent).getFormalGates().indexOf((Object)gate);
        }
        return -1;
    }

    private Rectangle getBounds(Shape parent) {
        int width = (Integer)this.getStructuralFeatureValue(parent, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue(parent, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        int x = (Integer)this.getStructuralFeatureValue(parent, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue(parent, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Dimension size = this.computePreferenceSize(parent);
        if (width <= 0) {
            width = size.width;
        }
        if (height <= 0) {
            height = size.height;
        }
        return new Rectangle(x, y, width, height);
    }

    private Dimension computePreferenceSize(Shape shape) {
        EObject element = ViewUtil.resolveSemanticElement((View)shape);
        String prefElementId = element.eClass().getName();
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)shape, (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)shape, (String)prefElementId, (int)16);
        return new Dimension(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
    }

    private Object getStructuralFeatureValue(Shape shape, EStructuralFeature feature) {
        return ViewUtil.getPropertyValue((View)shape, (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
    }

    private Point getLocation(Rectangle rect, Anchor sourceAnchor) {
        String terminal;
        PrecisionPoint precise;
        if (sourceAnchor instanceof IdentityAnchor && (precise = SlidableAnchor.parseTerminalString((String)(terminal = ((IdentityAnchor)sourceAnchor).getId()))) != null) {
            return new PrecisionPoint((double)rect.x + (double)rect.width * precise.preciseX(), (double)rect.y + (double)rect.height * precise.preciseY());
        }
        return null;
    }

    private View findPrimaryView(Diagram diagram, EObject target) {
        if (diagram == null || target == null) {
            return null;
        }
        TreeIterator contents = diagram.eAllContents();
        while (contents.hasNext()) {
            View view;
            EObject element;
            EObject next = (EObject)contents.next();
            if (!(next instanceof Shape) && !(next instanceof Edge) || target != (element = ViewUtil.resolveSemanticElement((View)(view = (View)next)))) continue;
            return this.findTopView(view, element);
        }
        return null;
    }

    private View findTopView(View view, EObject element) {
        View containerView;
        EObject containerSemantic;
        EObject eContainer = view.eContainer();
        if (eContainer instanceof View && element == (containerSemantic = ViewUtil.resolveSemanticElement((View)(containerView = (View)eContainer)))) {
            return this.findTopView(containerView, element);
        }
        return view;
    }

    private List<Gate> getAllGates(EObject parent) {
        if (parent instanceof CombinedFragment) {
            return ((CombinedFragment)parent).getCfragmentGates();
        }
        if (parent instanceof InteractionUse) {
            return ((InteractionUse)parent).getActualGates();
        }
        if (parent instanceof Interaction) {
            return ((Interaction)parent).getFormalGates();
        }
        return Collections.emptyList();
    }

    private boolean isGateContainer(EObject eObject) {
        return eObject instanceof Interaction || eObject instanceof CombinedFragment || eObject instanceof InteractionUse;
    }
}

