/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.adapters.ResourceSetRootsAdapter;
import org.eclipse.papyrus.infra.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.resource.UMLResource;

public class SemanticUMLContentProvider
extends SemanticEMFContentProvider {
    protected static URI[] excludedModels = new URI[]{URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), URI.createURI((String)"pathmap://UML_METAMODELS/Ecore.metamodel.uml")};
    private ResourceSet root;
    private Viewer viewer;
    private ResourceSetRootsAdapter resourceSetListener = new ResourceSetRootsAdapter(){
        private boolean needsRefresh = false;

        protected void doNotify(Notification msg) {
            if (SemanticUMLContentProvider.this.root == null || msg.isTouch()) {
                return;
            }
            switch (msg.getEventType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.triggerRefresh();
                }
            }
        }

        private synchronized void triggerRefresh() {
            SemanticUMLContentProvider.this.roots = SemanticUMLContentProvider.getRoots(SemanticUMLContentProvider.this.root);
            if (SemanticUMLContentProvider.this.viewer != null && SemanticUMLContentProvider.this.viewer.getControl() != null && !SemanticUMLContentProvider.this.viewer.getControl().isDisposed()) {
                this.needsRefresh = true;
                SemanticUMLContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!needsRefresh || SemanticUMLContentProvider.this.viewer == null || SemanticUMLContentProvider.this.viewer.getControl() == null || SemanticUMLContentProvider.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        needsRefresh = false;
                        SemanticUMLContentProvider.this.viewer.refresh();
                    }
                });
            }
        }
    };

    public SemanticUMLContentProvider() {
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature, EObject[] roots) {
        super(editedEObject, feature, roots);
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature) {
        this(editedEObject, feature, SemanticUMLContentProvider.findRoots(editedEObject));
    }

    public SemanticUMLContentProvider(EObject[] roots) {
        super(roots);
    }

    public SemanticUMLContentProvider(ResourceSet root) {
        this(null, null, root);
    }

    public SemanticUMLContentProvider(EObject editedEObject, EStructuralFeature feature, ResourceSet root) {
        this(editedEObject, feature, SemanticUMLContentProvider.getRoots(root));
        this.root = root;
    }

    protected static EObject[] findRoots(EObject source) {
        if (source.eResource() == null || source.eResource().getResourceSet() == null) {
            return SemanticEMFContentProvider.findRoots((EObject)source);
        }
        return SemanticUMLContentProvider.getRoots(source.eResource().getResourceSet());
    }

    protected static EObject[] getRoots(ResourceSet root) {
        ModelSet modelSet;
        UmlModel umlModel;
        EObject rootElement = null;
        if (root instanceof ModelSet && (umlModel = (UmlModel)(modelSet = (ModelSet)root).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")) != null) {
            try {
                rootElement = umlModel.lookupRoot();
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        LinkedList<EObject> rootElements = new LinkedList<EObject>();
        for (Resource resource : root.getResources()) {
            if (!SemanticUMLContentProvider.isUMLModel(resource, rootElement)) continue;
            for (EObject rootEObject : resource.getContents()) {
                if (!(rootEObject instanceof Element)) continue;
                rootElements.add(rootEObject);
            }
        }
        return rootElements.toArray(new EObject[0]);
    }

    protected static boolean isUMLModel(Resource resource, EObject rootElement) {
        if (!SemanticUMLContentProvider.isUMLResource(resource)) {
            return false;
        }
        URI[] uRIArray = excludedModels;
        int n = excludedModels.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (uri.equals(resource.getURI())) {
                return false;
            }
            ++n2;
        }
        for (EObject rootObject : resource.getContents()) {
            if (rootObject.eIsProxy()) continue;
            if (rootObject.eContainer() != null) {
                return false;
            }
            if (!(rootObject instanceof Profile) || rootElement instanceof Profile) continue;
            return false;
        }
        return true;
    }

    protected static boolean isUMLResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        if (resource instanceof UMLResource) {
            return true;
        }
        URI uri = resource.getURI();
        return uri != null && "uml".equals(uri.fileExtension());
    }

    protected boolean isCompatibleMetaclass(Object containerElement, Object metaclass) {
        Element semanticElement = UMLUtil.resolveUMLElement((Object)containerElement);
        if (semanticElement == null) {
            return false;
        }
        if (metaclass instanceof Stereotype) {
            boolean res;
            Stereotype stereotype = (Stereotype)metaclass;
            boolean bl = res = semanticElement.getAppliedStereotype(stereotype.getQualifiedName()) != null;
            if (!res) {
                EClass definition = stereotype.getDefinition();
                for (EObject e : semanticElement.getStereotypeApplications()) {
                    EClass c = e.eClass();
                    if (definition == null || !definition.isSuperTypeOf(c)) continue;
                    res = true;
                    break;
                }
            }
            return res;
        }
        if (metaclass instanceof EClassifier) {
            return ((EClassifier)metaclass).isInstance((Object)semanticElement);
        }
        return false;
    }

    public Object getAdaptedValue(Object containerElement) {
        Object semanticElement = super.getAdaptedValue(containerElement);
        if (semanticElement instanceof Element) {
            Element element = (Element)semanticElement;
            for (Object metaclassWanted : this.getWantedMetaclasses()) {
                if (!(metaclassWanted instanceof Stereotype)) continue;
                EObject stereotypeApplication = null;
                stereotypeApplication = element.getStereotypeApplication((Stereotype)metaclassWanted);
                if (stereotypeApplication == null) {
                    EList subStereotypes = element.getAppliedSubstereotypes((Stereotype)metaclassWanted);
                    for (Stereotype subSteretoype : subStereotypes) {
                        stereotypeApplication = element.getStereotypeApplication(subSteretoype);
                        if (stereotypeApplication != null) break;
                    }
                }
                if (stereotypeApplication == null) continue;
                return stereotypeApplication;
            }
        }
        return semanticElement;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ResourceSet resourceSet = this.root;
        if (newInput instanceof ResourceSet) {
            resourceSet = (ResourceSet)newInput;
        } else if (newInput instanceof ServicesRegistry) {
            try {
                resourceSet = ServiceUtils.getInstance().getModelSet((Object)((ServicesRegistry)newInput));
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (newInput == null) {
            this.resourceSetListener.unsetTarget((Notifier)this.root);
        } else {
            this.listenOnResourceSet(resourceSet);
        }
        this.viewer = viewer;
        super.inputChanged(viewer, oldInput, newInput);
    }

    protected void listenOnResourceSet(ResourceSet resourceSet) {
        if (this.root != null) {
            this.resourceSetListener.unsetTarget((Notifier)this.root);
            this.root = null;
            this.roots = null;
        }
        if (resourceSet != null) {
            this.resourceSetListener.setTarget((Notifier)resourceSet);
            this.root = resourceSet;
            this.roots = SemanticUMLContentProvider.getRoots(this.root);
        }
    }

    public void dispose() {
        if (this.root != null) {
            this.resourceSetListener.unsetTarget((Notifier)this.root);
        }
        this.root = null;
        this.roots = null;
        this.viewer = null;
        super.dispose();
    }
}

