/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IInheritedElementContentProvider;
import org.eclipse.papyrus.uml.tools.providers.IIgnoreStereotypeBasePropertyContentProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLStereotypePropertyContentProvider
implements IHierarchicContentProvider,
IInheritedElementContentProvider,
IIgnoreStereotypeBasePropertyContentProvider {
    protected List<Profile> profiles;
    private boolean ignoreBaseProperty;
    private boolean ignoreInheritedProperties;

    public UMLStereotypePropertyContentProvider(List<Profile> profiles) {
        this.profiles = profiles;
        this.ignoreBaseProperty = false;
        this.ignoreInheritedProperties = false;
    }

    public UMLStereotypePropertyContentProvider() {
        this(null);
    }

    public Object[] getElements() {
        return this.profiles.toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        if (this.hasChildren(parentElement)) {
            if (parentElement instanceof Package) {
                for (EObject current : ((Package)parentElement).getOwnedMembers()) {
                    if (!this.hasChildren(current)) continue;
                    children.add(current);
                }
            } else if (parentElement instanceof Stereotype) {
                if (this.ignoreInheritedProperties) {
                    if (this.ignoreBaseProperty) {
                        children.addAll(StereotypeUtil.getStereotypePropertiesWithoutBaseProperties((Stereotype)((Stereotype)parentElement)));
                    } else {
                        children.addAll((Collection<EObject>)((Stereotype)parentElement).getOwnedAttributes());
                    }
                } else if (this.ignoreBaseProperty) {
                    children.addAll(StereotypeUtil.getAllStereotypePropertiesWithoutBaseProperties((Stereotype)((Stereotype)parentElement)));
                } else {
                    children.addAll((Collection<EObject>)((Stereotype)parentElement).getAllAttributes());
                }
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Element) {
            TreeIterator iter = ((EObject)element).eAllContents();
            while (iter.hasNext()) {
                if (!this.isValidValue(iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public void dispose() {
        this.profiles.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isValidValue(Object element) {
        if (element instanceof Element) {
            boolean result;
            boolean bl = result = element instanceof Property && ((Element)element).eContainer() instanceof Stereotype;
            if (result) {
                return StereotypeUtil.isValidStereotypeProperty((Property)((Property)element));
            }
            return result;
        }
        return false;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    @Override
    public void setIgnoreBaseProperty(boolean ignoreBaseProperty) {
        this.ignoreBaseProperty = ignoreBaseProperty;
    }

    public void setIgnoreInheritedElements(boolean ignoreInheritedElements) {
        this.ignoreInheritedProperties = ignoreInheritedElements;
    }

    public boolean isIgnoringInheritedElements() {
        return this.ignoreInheritedProperties;
    }

    @Override
    public boolean isIgnoringBaseProperty() {
        return this.ignoreBaseProperty;
    }
}

