/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class EObjectInheritanceCopyCommand
extends CompositeCommand {
    private final EObject sourceEObject;
    private final EObject targetEObject;
    private final TransactionalEditingDomain editingDomain;
    private Collection<Object> alreadyManaged = new LinkedList<Object>();

    public EObjectInheritanceCopyCommand(EObject source, EClass target, TransactionalEditingDomain adapterFactoryEditingDomain) {
        super("Inheritance copy");
        this.sourceEObject = source;
        this.targetEObject = target.getEPackage().getEFactoryInstance().create(target);
        this.editingDomain = adapterFactoryEditingDomain;
        if (this.sourceEObject == null || this.targetEObject == null || this.editingDomain == null) {
            throw new IllegalArgumentException("Please provide non null arguments");
        }
        this.init();
        if (this.sourceEObject.eContainingFeature().isMany()) {
            this.replace(this.sourceEObject.eContainer(), this.sourceEObject, this.targetEObject, this.sourceEObject.eContainingFeature());
        } else {
            this.add((IUndoableOperation)new CustomSetCommand(this.editingDomain, this.sourceEObject.eContainer(), this.sourceEObject.eContainingFeature(), this.targetEObject, this.sourceEObject, this.sourceEObject.eContainingFeature()));
            this.add((IUndoableOperation)new DestroyElementPapyrusCommand(new DestroyElementRequest(this.editingDomain, this.sourceEObject, false)));
        }
    }

    private void init() {
        this.modelCopy(this.sourceEObject, this.targetEObject);
        this.crossReference(this.sourceEObject, this.targetEObject);
    }

    private void modelCopy(EObject source, EObject target) {
        EClass eclass = source.eClass();
        if (eclass != null) {
            EList eAllStructuralFeatures = eclass.getEAllStructuralFeatures();
            for (EStructuralFeature e : eAllStructuralFeatures) {
                if (!this.contains(target.eClass(), e) || !EObjectInheritanceCopyCommand.isCompatible(e.getEType(), target.eClass().getEStructuralFeature(e.getName()).getEType())) continue;
                this.manageFeature(source, target, e);
            }
        }
    }

    private boolean contains(EClass target, EStructuralFeature e) {
        EList features = target.getEAllStructuralFeatures();
        for (EStructuralFeature f : features) {
            if (!f.getName().equals(e.getName())) continue;
            return true;
        }
        return false;
    }

    private void manageFeatureForCross(EObject theObjectWithCross, EObject source, EObject target, EStructuralFeature structuralFeature) {
        boolean compatible = EObjectInheritanceCopyCommand.isCompatible(structuralFeature.getEType(), (EClassifier)target.eClass());
        if (compatible && structuralFeature.isChangeable() && !structuralFeature.isDerived()) {
            if (structuralFeature.isMany()) {
                this.replace(theObjectWithCross, source, target, structuralFeature);
            } else {
                this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, theObjectWithCross, structuralFeature, (Object)target)));
            }
        } else if (!compatible) {
            if (structuralFeature.isMany()) {
                this.remove(theObjectWithCross, source, structuralFeature);
            } else {
                this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, theObjectWithCross, structuralFeature, null)));
            }
        }
    }

    private void remove(EObject owner, Object source, EStructuralFeature structuralFeature) {
        if (!this.alreadyManaged.contains(source)) {
            if (owner == null && structuralFeature == null) {
                if (source instanceof EObject) {
                    this.add((IUndoableOperation)new DestroyElementPapyrusCommand(new DestroyElementRequest(this.editingDomain, (EObject)source, false)));
                }
            } else {
                Object value = owner.eGet(structuralFeature);
                if (value instanceof Collection) {
                    ArrayList newList = new ArrayList((Collection)value);
                    newList.remove(source);
                    this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, owner, structuralFeature, newList)));
                } else if (source.equals(value)) {
                    this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, owner, structuralFeature, null)));
                } else {
                    this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, owner, structuralFeature, null)));
                }
            }
            this.alreadyManaged.add(source);
        }
    }

    private void replace(EObject owner, Object source, Object target, EStructuralFeature structuralFeature) {
        if (!this.alreadyManaged.contains(source)) {
            if (owner == null && structuralFeature == null) {
                if (source instanceof EObject) {
                    this.add((IUndoableOperation)new DestroyElementPapyrusCommand(new DestroyElementRequest(this.editingDomain, (EObject)source, false)));
                }
            } else {
                Object value = owner.eGet(structuralFeature);
                if (value instanceof Collection) {
                    ArrayList<Object> newList = new ArrayList<Object>((Collection)value);
                    int index = newList.indexOf(source);
                    if (index >= 0) {
                        newList.remove(index);
                        newList.add(index, target);
                        this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, owner, structuralFeature, newList)));
                    }
                } else if (source.equals(value)) {
                    this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, owner, structuralFeature, target)));
                } else {
                    this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, owner, structuralFeature, target)));
                }
            }
            this.alreadyManaged.add(source);
        }
    }

    public IStatus undo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return super.undo(progressMonitor, info);
    }

    private void crossReference(EObject source, EObject target) {
        Collection collection = EMFHelper.getUsages((EObject)source);
        if (collection != null) {
            for (EStructuralFeature.Setting nonNavigableInverseReference : collection) {
                EStructuralFeature structuralFeature = nonNavigableInverseReference.getEStructuralFeature();
                if (!(nonNavigableInverseReference.getEObject() instanceof View)) {
                    this.manageFeatureForCross(nonNavigableInverseReference.getEObject(), source, target, structuralFeature);
                    continue;
                }
                if (!(nonNavigableInverseReference.getEObject() instanceof Diagram)) continue;
                Diagram di = (Diagram)nonNavigableInverseReference.getEObject();
                this.remove(null, di, null);
            }
        }
    }

    public static boolean isCompatible(EClassifier type, EClassifier target) {
        LinkedList<EClassifier> types = new LinkedList<EClassifier>();
        if (target instanceof EClass) {
            EClass eclass = (EClass)target;
            types.addAll((Collection<EClassifier>)eclass.getEAllSuperTypes());
        }
        if (!types.contains(target)) {
            types.add(target);
        }
        return types.contains(type);
    }

    private void manageFeature(EObject source, EObject target, EStructuralFeature feature) {
        EStructuralFeature targetFeature = this.getFeature(target, feature.getName());
        if (feature.getUpperBound() <= targetFeature.getUpperBound() && feature.getLowerBound() >= targetFeature.getLowerBound() && feature.isChangeable() && !feature.isDerived()) {
            Object value = source.eGet(feature);
            if (feature.isMany() && targetFeature.isMany()) {
                Collection list = (Collection)value;
                if (list != null && !list.isEmpty()) {
                    LinkedList<EObject> newList = new LinkedList<EObject>();
                    newList.addAll(list);
                    if (feature instanceof EReference && !((EReference)feature).isContainment()) {
                        this.add((IUndoableOperation)new SetValueCommand(new SetRequest(this.editingDomain, target, targetFeature, newList)));
                    } else if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                        LinkedList toTreat = new LinkedList();
                        for (Object e : newList) {
                            if (this.alreadyManaged.contains(e)) continue;
                            toTreat.add(e);
                            this.alreadyManaged.add(e);
                        }
                        this.add((IUndoableOperation)new CustomAddCommand(this.editingDomain, target, targetFeature, newList, source, feature));
                    }
                }
            } else if (!(feature.isMany() || targetFeature.isMany() || value == null || this.alreadyManaged.contains(value))) {
                this.alreadyManaged.add(value);
                this.add((IUndoableOperation)new CustomSetCommand(this.editingDomain, target, targetFeature, value, source, feature));
            }
        }
    }

    private EStructuralFeature getFeature(EObject eobject, String name) {
        return eobject.eClass().getEStructuralFeature(name);
    }

    public EObject getResultEobject() {
        return this.targetEObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomAddCommand
    extends SetValueCommand {
        private EObject oldObject;
        private EStructuralFeature oldFeature;
        private EStructuralFeature newFeature;

        public CustomAddCommand(TransactionalEditingDomain editingDomain, EObject target, EStructuralFeature targetFeature, Collection<EObject> newList, EObject source, EStructuralFeature e) {
            super(new SetRequest(editingDomain, target, targetFeature, newList));
            this.oldObject = null;
            this.oldObject = source;
            this.oldFeature = e;
            this.newFeature = targetFeature;
        }

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Object values = this.getElementToEdit().eGet(this.newFeature);
            IStatus result = super.doUndo(monitor, info);
            if (values instanceof Collection && !((Collection)values).isEmpty()) {
                Collection collection = (Collection)values;
                Collection collecOldObject = (Collection)this.oldObject.eGet(this.oldFeature);
                for (Object o : collection) {
                    if (collecOldObject.contains(o)) continue;
                    collecOldObject.add(o);
                }
            }
            return result;
        }
    }

    private class CustomSetCommand
    extends SetValueCommand {
        private EObject oldObject;
        private EStructuralFeature oldFeature;
        private Object oldValue;

        public CustomSetCommand(TransactionalEditingDomain domain, EObject owner, EStructuralFeature feature, Object value, EObject old, EStructuralFeature structuralFeature) {
            super(new SetRequest(domain, owner, feature, value));
            this.oldObject = null;
            this.oldFeature = null;
            this.oldValue = null;
            this.oldObject = old;
            this.oldFeature = structuralFeature;
            this.oldValue = value;
        }

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus result = super.doUndo(monitor, info);
            this.oldObject.eSet(this.oldFeature, this.oldValue);
            return result;
        }
    }
}

