/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.listener;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.Messages;

public class DoubleClickListener
implements IDoubleClickListener {
    private final ServicesRegistry servicesRegistry;

    public DoubleClickListener(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public void doubleClick(DoubleClickEvent event) {
        IPageManager pageManager;
        ISelection selection = event.getSelection();
        try {
            pageManager = ServiceUtils.getInstance().getIPageManager((Object)this.servicesRegistry);
        }
        catch (Exception e) {
            Activator.log.error(Messages.DoubleClickListener_Error_NoLoadManagerToOpen, (Throwable)e);
            return;
        }
        if (pageManager != null && selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            LinkedList<EObject> pagesToOpen = new LinkedList<EObject>();
            EObject pageToSelect = null;
            while (iter.hasNext()) {
                Object currentObject = iter.next();
                EObject diag = EMFHelper.getEObject(currentObject);
                if (!this.isPage(diag, pageManager) || !this.canOpenByPolicy(diag)) continue;
                if (pageManager.isOpen((Object)diag)) {
                    pageToSelect = diag;
                    continue;
                }
                pagesToOpen.add(diag);
            }
            if (!pagesToOpen.isEmpty()) {
                for (EObject page : pagesToOpen) {
                    pageManager.openPage((Object)page);
                }
            } else if (pageToSelect != null) {
                pageManager.selectPage(pageToSelect);
            }
        }
    }

    private boolean canOpenByPolicy(EObject selection) {
        if (selection instanceof Diagram) {
            Diagram diagram = (Diagram)selection;
            ViewPrototype proto = DiagramUtils.getPrototype((Diagram)diagram);
            return proto != ViewPrototype.UNAVAILABLE_VIEW && proto != ViewPrototype.UNAVAILABLE_DIAGRAM;
        }
        return true;
    }

    protected boolean isPage(EObject element, IPageManager pageManager) {
        if (pageManager.allPages().contains(element)) {
            return true;
        }
        Object openable = Platform.getAdapterManager().getAdapter((Object)element, IOpenable.class);
        return openable instanceof IOpenable;
    }
}

