/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.modelelement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.environment.ModelElementFactoryDescriptor;
import org.eclipse.papyrus.views.properties.modelelement.CompositeModelElement;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.modelelement.ModelElementFactory;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;

public class DataSourceFactory {
    public static DataSourceFactory instance = new DataSourceFactory();
    private Map<SelectionEntry, DataSource> sources = new HashMap<SelectionEntry, DataSource>();

    public DataSource createDataSourceFromSelection(IStructuredSelection selection, View view) {
        SelectionEntry selectionEntry = new SelectionEntry(selection, view);
        if (!this.sources.containsKey(selectionEntry)) {
            DataSource source = new DataSource(view, selection);
            this.sources.put(selectionEntry, source);
        }
        return this.sources.get(selectionEntry);
    }

    public void removeFromCache(IStructuredSelection selection, View view) {
        if (selection == null || view == null) {
            return;
        }
        SelectionEntry entry = new SelectionEntry(selection, view);
        this.sources.remove(entry);
    }

    public ModelElement getModelElementFromPropertyPath(DataSource source, String propertyPath) {
        String key = propertyPath.substring(0, propertyPath.lastIndexOf(":"));
        for (Context context : PropertiesUtil.getDependencies(source.getView().getContext())) {
            DataContextElement element = PropertiesUtil.getContextElementByQualifiedName(key, (Collection<? extends DataContextElement>)context.getDataContexts());
            if (element == null) continue;
            ModelElement modelElement = instance.createModelElement(element, source.getSelection());
            if (modelElement != null) {
                modelElement.setDataSource(source);
            }
            return modelElement;
        }
        return null;
    }

    private ModelElement createModelElement(DataContextElement contextElement, IStructuredSelection selection) {
        if (selection.size() == 1) {
            ModelElement modelElement = this.createFromSource(selection.getFirstElement(), contextElement);
            return modelElement;
        }
        CompositeModelElement composite = new CompositeModelElement();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            ModelElement element = this.createFromSource(it.next(), contextElement);
            if (element == null) continue;
            composite.addModelElement(element);
        }
        return composite;
    }

    private ModelElementFactory getFactory(DataContextElement context) {
        DataContextRoot rootPackage = this.getRootPackage(context);
        ModelElementFactoryDescriptor factoryDescriptor = rootPackage.getModelElementFactory();
        if (factoryDescriptor == null) {
            Activator.log.warn("No ModelElementFactory is attached to DataContextElement " + this.getQualifiedName(context));
            return null;
        }
        if (factoryDescriptor.eIsProxy()) {
            Activator.log.warn("Unresolved reference to the ModelElementFactory: " + EcoreUtil.getURI((EObject)factoryDescriptor));
            return null;
        }
        String factoryName = factoryDescriptor.getFactoryClass();
        ModelElementFactory factory = (ModelElementFactory)ClassLoaderHelper.newInstance((String)factoryName, ModelElementFactory.class);
        return factory;
    }

    private ModelElement createFromSource(Object source, DataContextElement context) {
        ModelElementFactory factory = this.getFactory(context);
        if (factory == null) {
            return null;
        }
        return factory.createFromSource(source, context);
    }

    private DataContextRoot getRootPackage(DataContextElement context) {
        if (context.getPackage() == null) {
            return (DataContextRoot)context;
        }
        return this.getRootPackage((DataContextElement)context.getPackage());
    }

    private String getQualifiedName(DataContextElement context) {
        if (context.getPackage() == null) {
            return context.getName();
        }
        return String.valueOf(this.getQualifiedName((DataContextElement)context.getPackage())) + ":" + context.getName();
    }

    private DataSourceFactory() {
    }

    private class SelectionEntry {
        private IStructuredSelection selection;
        private View view;

        public SelectionEntry(IStructuredSelection selection, View view) {
            if (selection == null) {
                throw new IllegalArgumentException("The selection must not be null");
            }
            if (view == null) {
                throw new IllegalArgumentException("The view must not be null");
            }
            this.selection = selection;
            this.view = view;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SelectionEntry)) {
                return false;
            }
            SelectionEntry other = (SelectionEntry)obj;
            return other.view.equals(this.view) && this.selection.equals(other.selection);
        }

        public int hashCode() {
            return this.selection.hashCode() + this.view.hashCode();
        }
    }
}

