/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.core.sessions.CoreProject;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.core.sessions.CoreSessionEventListener;
import org.eclipse.persistence.core.sessions.CoreSessionEventManager;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.databaseaccess.CorePlatform;
import org.eclipse.persistence.internal.core.descriptors.CoreInstantiationPolicy;
import org.eclipse.persistence.internal.core.descriptors.CoreObjectBuilder;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

public abstract class Context<ABSTRACT_SESSION extends CoreAbstractSession, DESCRIPTOR extends Descriptor<?, ?, ?, ?, ?, NAMESPACE_RESOLVER, ?, ?, ?, ?>, FIELD extends Field, NAMESPACE_RESOLVER extends NamespaceResolver, PROJECT extends CoreProject, SESSION extends CoreSession, SESSION_EVENT_LISTENER extends CoreSessionEventListener> {
    protected volatile ContextState<ABSTRACT_SESSION, DESCRIPTOR, PROJECT, SESSION, SESSION_EVENT_LISTENER> contextState;

    private <T> T createByXPath(Object object, CoreObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NAMESPACE_RESOLVER namespaceResolver, Class<T> returnType) {
        Descriptor refDescriptor;
        XPathQueryResult queryResult = this.getMappingForXPath(object, objectBuilder, stringTokenizer, namespaceResolver);
        if (queryResult.mapping != null && (refDescriptor = (Descriptor)queryResult.mapping.getReferenceDescriptor()) != null) {
            return (T)((CoreInstantiationPolicy)refDescriptor.getInstantiationPolicy()).buildNewInstance();
        }
        return null;
    }

    public <T> T createByXPath(Object parentObject, String xPath, NAMESPACE_RESOLVER namespaceResolver, Class<T> returnType) {
        ABSTRACT_SESSION session = this.getSession(parentObject);
        Descriptor descriptor = (Descriptor)session.getDescriptor(parentObject);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        return this.createByXPath(parentObject, (CoreObjectBuilder)descriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, returnType);
    }

    protected abstract FIELD createField(String var1);

    public abstract Marshaller createMarshaller();

    public abstract Unmarshaller createUnmarshaller();

    public DESCRIPTOR getDescriptor(QName qName) {
        XPathQName xpathQName = new XPathQName(qName, true);
        return (DESCRIPTOR)((ContextState)this.contextState).getDescriptor(xpathQName);
    }

    public DESCRIPTOR getDescriptor(XPathQName xpathQName) {
        return (DESCRIPTOR)((ContextState)this.contextState).getDescriptor(xpathQName);
    }

    public DESCRIPTOR getDescriptorByGlobalType(XPathFragment xPathFragment) {
        return (DESCRIPTOR)((ContextState)this.contextState).getDescriptorByGlobalType(xPathFragment);
    }

    private XPathQueryResult getMappingForXPath(Object object, CoreObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NAMESPACE_RESOLVER namespaceResolver) {
        XPathQueryResult queryResult = new XPathQueryResult();
        String xPath = "";
        FIELD field = this.createField(null);
        field.setNamespaceResolver(namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            field.setXPath(String.valueOf(xPath) + nextToken);
            field.initialize();
            Object mapping = objectBuilder.getMappingForField(field);
            if (mapping == null) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                int fieldIndex = field.getXPathFragment().getIndexValue();
                int fragmentIndex = xPathFragment.getIndexValue();
                if (fieldIndex > 0 || fragmentIndex > 0) {
                    int index = fieldIndex - 1;
                    if (index < 0) {
                        index = fragmentIndex - 1;
                    }
                    String xPathNoIndexes = this.removeIndexesFromXPath(field.getXPath());
                    field.setXPath(xPathNoIndexes);
                    field.initialize();
                    mapping = objectBuilder.getMappingForField(field);
                    if (mapping == null) {
                        field.setXPath(String.valueOf(xPathNoIndexes) + "/" + "text()");
                        field.initialize();
                        mapping = objectBuilder.getMappingForField(field);
                    }
                    if (mapping != null) {
                        Object collection;
                        if (field.getXPath().endsWith("text()") || !stringTokenizer.hasMoreElements()) {
                            queryResult.mapping = mapping;
                            queryResult.owner = object;
                            queryResult.index = index;
                            return queryResult;
                        }
                        Object childObject = ((CoreMapping)mapping).getAttributeValueFromObject(object);
                        if (((CoreMapping)mapping).isCollectionMapping() && (collection = ((CoreMapping)mapping).getAttributeValueFromObject(object)) != null && List.class.isAssignableFrom(collection.getClass())) {
                            List list = (List)collection;
                            if (index >= list.size()) {
                                return null;
                            }
                            childObject = list.get(index);
                        }
                        if (childObject == null) {
                            childObject = ((CoreObjectBuilder)((CoreDescriptor)((CoreMapping)mapping).getReferenceDescriptor()).getObjectBuilder()).buildNewInstance();
                        }
                        Object childObjectBuilder = ((CoreDescriptor)((CoreMapping)mapping).getReferenceDescriptor()).getObjectBuilder();
                        return this.getMappingForXPath(childObject, (CoreObjectBuilder)childObjectBuilder, stringTokenizer, namespaceResolver);
                    }
                }
            } else {
                Object collection;
                if (!stringTokenizer.hasMoreElements()) {
                    queryResult.mapping = mapping;
                    queryResult.owner = object;
                    return queryResult;
                }
                Object childObject = ((CoreMapping)mapping).getAttributeValueFromObject(object);
                if (((CoreMapping)mapping).isCollectionMapping() && (collection = ((CoreMapping)mapping).getAttributeValueFromObject(object)) != null && List.class.isAssignableFrom(collection.getClass())) {
                    List list = (List)collection;
                    if (list.size() <= 0) {
                        return null;
                    }
                    childObject = list.get(0);
                }
                if (childObject == null) {
                    childObject = ((CoreObjectBuilder)((CoreDescriptor)((CoreMapping)mapping).getReferenceDescriptor()).getObjectBuilder()).buildNewInstance();
                }
                Object childObjectBuilder = ((CoreDescriptor)((CoreMapping)mapping).getReferenceDescriptor()).getObjectBuilder();
                return this.getMappingForXPath(childObject, (CoreObjectBuilder)childObjectBuilder, stringTokenizer, namespaceResolver);
            }
            xPath = String.valueOf(xPath) + nextToken + "/";
        }
        return null;
    }

    public ABSTRACT_SESSION getSession(Class clazz) {
        return this.contextState.getSession(clazz);
    }

    public SESSION getSession() {
        return this.contextState.getSession();
    }

    public ABSTRACT_SESSION getSession(DESCRIPTOR descriptor) {
        return this.contextState.getSession(descriptor);
    }

    public ABSTRACT_SESSION getSession(Object object) {
        return this.contextState.getSession(object);
    }

    public <T> T getValueByXPath(Object object, String xPath, NAMESPACE_RESOLVER namespaceResolver, Class<T> returnType) {
        Object selfMapping;
        if (xPath == null || object == null) {
            return null;
        }
        if (".".equals(xPath)) {
            return (T)object;
        }
        ABSTRACT_SESSION session = this.getSession(object);
        Descriptor descriptor = (Descriptor)session.getDescriptor(object);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        T value = this.getValueByXPath(object, (CoreObjectBuilder)descriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, returnType);
        if (value == null && (selfMapping = ((CoreObjectBuilder)descriptor.getObjectBuilder()).getMappingForField(this.createField(String.valueOf('.')))) != null && ((CoreMapping)selfMapping).getReferenceDescriptor() != null) {
            return this.getValueByXPath(((CoreMapping)selfMapping).getAttributeValueFromObject(object), (CoreObjectBuilder)((CoreDescriptor)((CoreMapping)selfMapping).getReferenceDescriptor()).getObjectBuilder(), new StringTokenizer(xPath, "/"), ((Descriptor)((CoreMapping)selfMapping).getReferenceDescriptor()).getNamespaceResolver(), returnType);
        }
        return value;
    }

    private <T> T getValueByXPath(Object object, CoreObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NAMESPACE_RESOLVER namespaceResolver, Class<T> returnType) {
        XPathQueryResult queryResult = this.getMappingForXPath(object, objectBuilder, stringTokenizer, namespaceResolver);
        if (queryResult != null) {
            CoreMapping mapping = queryResult.mapping;
            Object owner = queryResult.owner;
            Integer index = queryResult.index;
            if (owner != null) {
                Object childObject = null;
                if (mapping.isCollectionMapping()) {
                    Object collection = mapping.getAttributeValueFromObject(owner);
                    if (List.class.isAssignableFrom(collection.getClass())) {
                        List list = (List)collection;
                        if (index == null) {
                            return (T)collection;
                        }
                        if (index >= list.size()) {
                            return null;
                        }
                        childObject = list.get(index);
                    }
                } else {
                    childObject = mapping.getAttributeValueFromObject(owner);
                }
                return (T)childObject;
            }
        }
        return null;
    }

    public abstract boolean hasDocumentPreservation();

    private String removeIndexesFromXPath(String xpathWithIndexes) {
        String newXPath = xpathWithIndexes;
        while (newXPath.contains("[")) {
            int open = newXPath.lastIndexOf("[");
            int closed = newXPath.lastIndexOf("]");
            newXPath = String.valueOf(newXPath.substring(0, open)) + newXPath.substring(closed + 1);
        }
        return newXPath;
    }

    private void setValueByXPath(Object object, CoreObjectBuilder objectBuilder, StringTokenizer stringTokenizer, NAMESPACE_RESOLVER namespaceResolver, Object value) {
        XPathQueryResult queryResult = this.getMappingForXPath(object, objectBuilder, stringTokenizer, namespaceResolver);
        if (queryResult != null) {
            CoreMapping mapping = queryResult.mapping;
            Object owner = queryResult.owner;
            Integer index = queryResult.index;
            if (owner != null) {
                if (mapping.isCollectionMapping()) {
                    Object collection = mapping.getAttributeValueFromObject(owner);
                    if (List.class.isAssignableFrom(collection.getClass())) {
                        List list = (List)collection;
                        if (index == null) {
                            if (value.getClass().isArray()) {
                                ArrayList<Object> newList = new ArrayList<Object>();
                                int length = Array.getLength(value);
                                int i = 0;
                                while (i < length) {
                                    newList.add(Array.get(value, i));
                                    ++i;
                                }
                                value = newList;
                            }
                            mapping.setAttributeValueInObject(owner, value);
                            return;
                        }
                        if (index >= list.size()) {
                            return;
                        }
                        list.set(index, value);
                        mapping.setAttributeValueInObject(owner, list);
                        return;
                    }
                } else {
                    mapping.setAttributeValueInObject(owner, value);
                }
            }
        }
    }

    public void setValueByXPath(Object object, String xPath, NAMESPACE_RESOLVER namespaceResolver, Object value) {
        ABSTRACT_SESSION session = this.getSession(object);
        Descriptor descriptor = (Descriptor)session.getDescriptor(object);
        StringTokenizer stringTokenizer = new StringTokenizer(xPath, "/");
        this.setValueByXPath(object, (CoreObjectBuilder)descriptor.getObjectBuilder(), stringTokenizer, namespaceResolver, value);
    }

    public static class ContextState<ABSTRACT_SESSION extends CoreAbstractSession, DESCRIPTOR extends Descriptor, PROJECT extends CoreProject, SESSION extends CoreSession, SESSION_EVENT_LISTENER extends CoreSessionEventListener> {
        protected Context context;
        protected Map<XPathQName, DESCRIPTOR> descriptorsByQName = new HashMap<XPathQName, DESCRIPTOR>();
        protected Map<XPathFragment, DESCRIPTOR> descriptorsByGlobalType = new HashMap<XPathFragment, DESCRIPTOR>();
        protected SESSION session;
        private Collection<SESSION_EVENT_LISTENER> sessionEventListeners;

        protected ContextState() {
        }

        protected ContextState(Context context, PROJECT project, ClassLoader classLoader, Collection<SESSION_EVENT_LISTENER> sessionEventListeners) {
            this();
            this.context = context;
            this.preLogin(project, classLoader);
            this.session = ((CoreProject)project).createDatabaseSession();
            if (sessionEventListeners != null) {
                for (CoreSessionEventListener sessionEventListener : sessionEventListeners) {
                    ((CoreSessionEventManager)this.session.getEventManager()).addListener((CoreSessionEventListener)sessionEventListener);
                }
            }
            this.setupSession(this.session);
            this.storeDescriptorsByQName((CoreSession)this.session);
        }

        public void addDescriptorByQName(QName qName, DESCRIPTOR descriptor) {
            XPathQName xpathQName = new XPathQName(qName, true);
            this.addDescriptorByQName(xpathQName, descriptor);
        }

        private void addDescriptorByQName(XPathQName qName, DESCRIPTOR descriptor) {
            this.descriptorsByQName.put(qName, descriptor);
        }

        protected void preLogin(PROJECT project, ClassLoader classLoader) {
        }

        private DESCRIPTOR getDescriptor(QName qName) {
            XPathQName xpathQName = new XPathQName(qName, true);
            return (DESCRIPTOR)((Descriptor)this.descriptorsByQName.get(xpathQName));
        }

        private DESCRIPTOR getDescriptor(XPathQName qName) {
            return (DESCRIPTOR)((Descriptor)this.descriptorsByQName.get(qName));
        }

        private DESCRIPTOR getDescriptorByGlobalType(XPathFragment xPathFragment) {
            return (DESCRIPTOR)((Descriptor)this.descriptorsByGlobalType.get(xPathFragment));
        }

        protected SESSION getSession() {
            return this.session;
        }

        protected ABSTRACT_SESSION getSession(Class clazz) {
            if (clazz == null) {
                return null;
            }
            if (this.session.getDescriptor(clazz) != null) {
                return (ABSTRACT_SESSION)((CoreAbstractSession)this.session);
            }
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }

        protected ABSTRACT_SESSION getSession(DESCRIPTOR descriptor) {
            if (descriptor == null) {
                return null;
            }
            if (((CoreProject)this.session.getProject()).getOrderedDescriptors().contains(descriptor)) {
                return (ABSTRACT_SESSION)((CoreAbstractSession)this.session);
            }
            throw XMLMarshalException.descriptorNotFoundInProject(descriptor.getJavaClass().getName());
        }

        protected ABSTRACT_SESSION getSession(Object object) {
            if (object == null) {
                return null;
            }
            if (this.session.getDescriptor(object) != null) {
                return (ABSTRACT_SESSION)((CoreAbstractSession)this.session);
            }
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }

        protected void setupSession(SESSION session) {
        }

        public void storeDescriptorByQName(DESCRIPTOR descriptor, CorePlatform platform) {
            Vector tableNames = descriptor.getTableNames();
            int i = 0;
            while (i < tableNames.size()) {
                int index;
                String defaultRootLocalName;
                String defaultRootName = (String)tableNames.get(i);
                if (defaultRootName != null && (defaultRootLocalName = defaultRootName.substring((index = defaultRootName.indexOf(58)) + 1)) != null && !defaultRootLocalName.equals("")) {
                    XPathQName descriptorQName;
                    if (index > -1) {
                        String defaultRootPrefix = defaultRootName.substring(0, index);
                        String defaultRootNamespaceURI = ((NamespaceResolver)descriptor.getNamespaceResolver()).resolveNamespacePrefix(defaultRootPrefix);
                        descriptorQName = new XPathQName(defaultRootNamespaceURI, defaultRootLocalName, true);
                    } else {
                        descriptorQName = descriptor.getNamespaceResolver() != null ? new XPathQName(((NamespaceResolver)descriptor.getNamespaceResolver()).getDefaultNamespaceURI(), defaultRootLocalName, true) : new XPathQName(defaultRootLocalName, true);
                    }
                    if (!descriptor.hasInheritance() || ((CoreInheritancePolicy)descriptor.getInheritancePolicy()).isRootParentDescriptor()) {
                        this.addDescriptorByQName(descriptorQName, descriptor);
                    } else {
                        this.storeDescriptorByQName((Descriptor)((CoreInheritancePolicy)descriptor.getInheritancePolicy()).getParentDescriptor(), platform);
                        DESCRIPTOR existingDescriptor = this.getDescriptor(descriptorQName);
                        if (existingDescriptor == null) {
                            this.addDescriptorByQName(descriptorQName, descriptor);
                        }
                    }
                }
                ++i;
            }
            XMLSchemaReference xmlSchemaReference = descriptor.getSchemaReference();
            if (xmlSchemaReference != null) {
                String schemaContext = xmlSchemaReference.getSchemaContext();
                if (xmlSchemaReference.getType() == 1 || xmlSchemaReference.getType() == 2) {
                    if (schemaContext != null && schemaContext.lastIndexOf(47) == 0) {
                        schemaContext = schemaContext.substring(1, schemaContext.length());
                        XPathFragment typeFragment = new XPathFragment(schemaContext);
                        if (descriptor.getNamespaceResolver() != null) {
                            String uri = ((NamespaceResolver)descriptor.getNamespaceResolver()).resolveNamespacePrefix(typeFragment.getPrefix());
                            if (uri == null && xmlSchemaReference.getSchemaContextAsQName() != null) {
                                uri = xmlSchemaReference.getSchemaContextAsQName().getNamespaceURI();
                            }
                            typeFragment.setNamespaceURI(uri);
                        }
                        this.descriptorsByGlobalType.put(typeFragment, descriptor);
                    } else {
                        QName qname = xmlSchemaReference.getSchemaContextAsQName();
                        if (qname != null) {
                            if (descriptor.isWrapper() && descriptor.getJavaClassName().contains("ObjectWrapper")) {
                                return;
                            }
                            XPathFragment typeFragment = new XPathFragment();
                            typeFragment.setLocalName(qname.getLocalPart());
                            typeFragment.setNamespaceURI(qname.getNamespaceURI());
                            this.descriptorsByGlobalType.put(typeFragment, descriptor);
                        }
                    }
                }
            }
        }

        public void storeDescriptorsByQName(CoreSession session) {
            for (Descriptor descriptor : ((CoreProject)session.getProject()).getOrderedDescriptors()) {
                this.storeDescriptorByQName((DESCRIPTOR)descriptor, (CorePlatform)session.getDatasourcePlatform());
            }
        }
    }

    private class XPathQueryResult {
        private CoreMapping mapping;
        private Object owner;
        private Integer index;

        private XPathQueryResult() {
        }
    }
}

