/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGProblemView;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class TableSorter
extends ViewerSorter {
    private int columnIndex = 0;
    private boolean ascending = true;

    public void setColumn(int column) {
        if (column == this.columnIndex) {
            this.toggleSortOrder();
        } else {
            this.changeSortColumnTo(column);
        }
    }

    private void toggleSortOrder() {
        this.ascending = !this.ascending;
    }

    private void changeSortColumnTo(int column) {
        this.columnIndex = column;
        this.ascending = true;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IMarker m1 = (IMarker)e1;
        IMarker m2 = (IMarker)e2;
        return this.compare(m1, m2);
    }

    private int compare(IMarker m1, IMarker m2) {
        if (this.ascending) {
            return this.compareAscending(m1, m2);
        }
        return this.compareDescending(m1, m2);
    }

    private int compareAscending(IMarker m1, IMarker m2) {
        switch (VPGProblemView.VPGViewColumn.values()[this.columnIndex]) {
            case DESCRIPTION: {
                String msg1 = MarkerUtilities.getMessage((IMarker)m1);
                String msg2 = MarkerUtilities.getMessage((IMarker)m2);
                return msg1.compareTo(msg2);
            }
            case RESOURCE: {
                String resource1 = m1.getResource().getName().toString();
                String resource2 = m2.getResource().getName().toString();
                return resource1.compareTo(resource2);
            }
            case PATH: {
                String path1 = m1.getResource().getProjectRelativePath().toString();
                String path2 = m2.getResource().getProjectRelativePath().toString();
                return path1.compareTo(path2);
            }
        }
        throw new IllegalStateException();
    }

    private int compareDescending(IMarker m1, IMarker m2) {
        return -this.compareAscending(m1, m2);
    }
}

