/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;

public abstract class AbstractDebuggerConfiguration
implements IDebuggerConfiguration {
    protected Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
    private HashMap<String, String> attributes = new HashMap();
    private ICommunicationDaemon communicationDaemon;
    private static final String EMPTY_STRING = "";

    public void setAttribute(String id, String value) {
        if (EMPTY_STRING.equals(this.preferences.getDefaultString(id))) {
            this.attributes.put(id, value);
        } else {
            this.preferences.setValue(id, value);
        }
    }

    @Override
    public String getAttribute(String id) {
        String attribute = this.attributes.get(id);
        if (attribute == null) {
            attribute = this.preferences.getString(id);
        }
        return attribute;
    }

    public void setDebuggerId(String id) {
        this.attributes.put("id", id);
    }

    @Override
    public String getDebuggerId() {
        return this.getAttribute("id");
    }

    public void setName(String name) {
        this.attributes.put("name", name);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    public abstract void setPort(int var1);

    @Override
    public abstract int getPort();

    public ICommunicationDaemon getCommunicationDaemon() {
        return this.communicationDaemon;
    }

    public void setCommunicationDaemon(ICommunicationDaemon communicationDaemon) {
        this.communicationDaemon = communicationDaemon;
    }

    @Override
    public void save() {
        PHPDebugPlugin.getDefault().savePluginPreferences();
    }

    public abstract void applyDefaults();

    public abstract IStatus validate(PHPexeItem var1);

    protected boolean isInstalled(PHPexeItem exeItem, String extensionId) {
        try {
            String output = null;
            File iniFile = exeItem.getINILocation();
            output = iniFile != null ? PHPexeItem.exec(exeItem.getExecutable().getAbsolutePath(), exeItem.isLoadDefaultINI() ? EMPTY_STRING : "-n", "-c", iniFile.getAbsolutePath(), "--re", extensionId) : PHPexeItem.exec(exeItem.getExecutable().getAbsolutePath(), "--re", extensionId);
            return output != null && !output.trim().startsWith("Exception");
        }
        catch (IOException e) {
            PHPDebugPlugin.log(e);
            return false;
        }
    }
}

