/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.ui.Logger;

public abstract class ModelUtils {
    public static IField getField(FieldAccess fieldAccess) {
        ITypeBinding type = fieldAccess.getDispatcher().resolveTypeBinding();
        String fieldName = ModelUtils.getFieldName(fieldAccess.getMember());
        if (type != null && fieldName != null) {
            IVariableBinding[] fields;
            IVariableBinding[] iVariableBindingArray = fields = type.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding field = iVariableBindingArray[n2];
                if (field.getName().substring(1).toLowerCase().equals(fieldName.toLowerCase())) {
                    return (IField)field.getPHPElement();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IMethod getMethod(MethodInvocation methodInvocation) {
        ITypeBinding type = methodInvocation.getDispatcher().resolveTypeBinding();
        String methodName = ModelUtils.getFunctionName(methodInvocation.getMethod().getFunctionName());
        if (type != null && methodName != null) {
            IMethodBinding[] methods;
            IMethodBinding[] iMethodBindingArray = methods = type.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (method.getName().toLowerCase().equals(methodName.toLowerCase())) {
                    return (IMethod)method.getPHPElement();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IMethod getMethod(StaticMethodInvocation methodInvocation) {
        ITypeBinding type = methodInvocation.getClassName().resolveTypeBinding();
        String methodName = ModelUtils.getFunctionName(methodInvocation.getMethod().getFunctionName());
        if (type != null && methodName != null) {
            IMethodBinding[] methods;
            IMethodBinding[] iMethodBindingArray = methods = type.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (method.getName().toLowerCase().equals(methodName.toLowerCase())) {
                    return (IMethod)method.getPHPElement();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IMethod getMethod(MethodDeclaration methodDeclaration) {
        IMethodBinding methodBinding = methodDeclaration.resolveMethodBinding();
        if (methodBinding == null) {
            return null;
        }
        ITypeBinding type = methodBinding.getDeclaringClass();
        String methodName = methodDeclaration.getFunction().getFunctionName().getName();
        if (type != null && methodName != null) {
            IMethodBinding[] methods;
            IMethodBinding[] iMethodBindingArray = methods = type.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (method.getName().toLowerCase().equals(methodName.toLowerCase())) {
                    return (IMethod)method.getPHPElement();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IMethod getMethod(FunctionDeclaration functionDeclaration) {
        IFunctionBinding function = functionDeclaration.resolveFunctionBinding();
        if (function == null) {
            return null;
        }
        IMethod method = (IMethod)function.getPHPElement();
        return method;
    }

    public static IMethod getFunctionMethod(FunctionDeclaration functionDeclaration) {
        ASTNode parent = functionDeclaration.getParent();
        IMethod method = null;
        method = parent instanceof MethodDeclaration ? ModelUtils.getMethod((MethodDeclaration)parent) : ModelUtils.getMethod(functionDeclaration);
        return method;
    }

    public static Collection<ISourceRange> getDeprecatedElements(IModelElement element) {
        LinkedList<ISourceRange> elements = new LinkedList<ISourceRange>();
        try {
            IModelElement[] children;
            if (ModelUtils.isDeprecated(element)) {
                elements.add(((IMember)element).getNameRange());
            }
            IModelElement[] iModelElementArray = children = ((IParent)element).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                if (ModelUtils.isDeprecated(child)) {
                    elements.add(((IMember)child).getNameRange());
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return elements;
    }

    public static boolean isDeprecated(IModelElement element) {
        if (element instanceof IPHPDocAwareElement) {
            return ((IPHPDocAwareElement)element).isDeprecated();
        }
        if (element instanceof IMember) {
            try {
                return PHPFlags.isDeprecated((int)((IMember)element).getFlags());
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        return false;
    }

    public static PHPDocBlock getPHPDoc(IModelElement element) {
        PHPDocBlock doc = null;
        if (element instanceof IField) {
            doc = PHPModelUtils.getDocBlock((IField)((IField)element));
        } else if (element instanceof IMethod) {
            doc = PHPModelUtils.getDocBlock((IMethod)((IMethod)element));
        } else if (element instanceof IType) {
            doc = PHPModelUtils.getDocBlock((IType)((IType)element));
        }
        return doc;
    }

    public static IType[] getTypes(String typeName, ISourceModule sm, int offset, IType currentNamespace) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sm, null);
        IContext context = ASTUtils.findContext((ISourceModule)sm, (ModuleDeclaration)moduleDeclaration, (int)offset);
        if (currentNamespace != null) {
            String prefix;
            Map result;
            if (typeName.indexOf(92) > 0) {
                String prefix2 = typeName.substring(0, typeName.indexOf(92));
                Map result2 = PHPModelUtils.getAliasToNSMap((String)prefix2, (ModuleDeclaration)moduleDeclaration, (int)offset, (IType)currentNamespace, (boolean)true);
                if (result2.containsKey(prefix2)) {
                    String fullName = ((UsePart)result2.get(prefix2)).getNamespace().getFullyQualifiedName();
                    typeName = typeName.replace(prefix2, fullName);
                }
            } else if (typeName.indexOf(92) < 0 && (result = PHPModelUtils.getAliasToNSMap((String)(prefix = typeName), (ModuleDeclaration)moduleDeclaration, (int)offset, (IType)currentNamespace, (boolean)true)).containsKey(prefix)) {
                String fullName;
                typeName = fullName = ((UsePart)result.get(prefix)).getNamespace().getFullyQualifiedName();
            }
        }
        return PHPTypeInferenceUtils.getModelElements((IEvaluatedType)new PHPClassType(typeName), (ISourceModuleContext)((ISourceModuleContext)context), (int)offset);
    }

    private static String getFieldName(VariableBase variable) {
        if (variable instanceof Variable) {
            return ModelUtils.getName((Variable)variable);
        }
        return null;
    }

    public static String getFunctionName(FunctionName func) {
        Expression name = func.getName();
        if (name instanceof Variable) {
            return ModelUtils.getName((Variable)name);
        }
        if (name instanceof Identifier) {
            return ((Identifier)name).getName();
        }
        return null;
    }

    private static String getName(Variable variable) {
        Expression varName = variable.getName();
        if (varName instanceof Identifier) {
            return ((Identifier)varName).getName();
        }
        if (variable.getName() instanceof Variable) {
            return ModelUtils.getName((Variable)varName);
        }
        return null;
    }

    public static boolean isExternalElement(IModelElement element) {
        ExternalProjectFragment fragment;
        return (element = element.getAncestor(3)) instanceof ExternalProjectFragment && (fragment = (ExternalProjectFragment)element).isExternal();
    }
}

