/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.folding.IStructuredTextFoldingProvider;
import org.eclipse.php.internal.ui.folding.html.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.php.internal.ui.folding.html.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderPHP
implements IProjectionListener,
IStructuredTextFoldingProvider {
    private PHPStructuredEditor fEditor;
    private ProjectionListener fProjectionListener;
    private IModelElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fCollapsePhpdoc = true;
    private boolean fCollapseImportContainer = true;
    private boolean fCollapseTypes = true;
    private boolean fCollapseMembers = false;
    private boolean fCollapseHeaderComments = true;
    private final Filter fMemberFilter = new MemberFilter();
    private final Filter fCommentFilter = new CommentFilter();
    private volatile int fUpdatingCount = 0;
    private PHPStructuredTextViewer viewer;
    private IDocument fDocument;
    private static final int MAX_CHILDREN = 10;
    private static final int MAX_SIBLINGS = 1000;

    @Override
    public void install(ProjectionViewer viewer) {
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        this.internalUninstall();
        PHPStructuredTextViewer viewer1 = (PHPStructuredTextViewer)viewer;
        ITextEditor editor = viewer1.getTextEditor();
        this.viewer = viewer1;
        Assert.isLegal((editor != null ? 1 : 0) != 0);
        if (editor instanceof PHPStructuredEditor) {
            this.fProjectionListener = new ProjectionListener(viewer);
            this.fEditor = (PHPStructuredEditor)editor;
        }
    }

    @Override
    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.isInstalled()) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        ProjectionModelNodeAdapterFactoryHTML factory2;
        if (this.fElementListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
        if ((factory2 = this.getAdapterFactoryHTML(false)) != null) {
            factory2.removeProjectionViewer((ProjectionViewer)this.viewer);
        }
        if (this.viewer.getProjectionAnnotationModel() != null) {
            this.viewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.removeAllAdapters();
        this.fDocument = null;
    }

    private void removeAllAdapters() {
        if (this.fDocument != null) {
            IStructuredModel sModel = null;
            try {
                IndexedRegion startNode;
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null && (startNode = sModel.getIndexedRegion(0)) instanceof Node) {
                    Node nextSibling = (Node)startNode;
                    while (nextSibling != null) {
                        Node currentNode = nextSibling;
                        nextSibling = currentNode.getNextSibling();
                        this.removeAdapterFromNodeAndChildren(currentNode, 0);
                    }
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
    }

    private void removeAdapterFromNodeAndChildren(Node node, int level) {
        if (node instanceof INodeNotifier) {
            INodeNotifier notifier = (INodeNotifier)node;
            INodeAdapter adapter2 = notifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class);
            if (adapter2 != null) {
                notifier.removeAdapter(adapter2);
            }
            Node nextChild = node.getFirstChild();
            while (nextChild != null) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.removeAdapterFromNodeAndChildren(childNode, level + 1);
            }
        }
    }

    @Override
    public final void initialize() {
        if (this.viewer != null) {
            this.fDocument = this.viewer.getDocument();
            if (this.viewer.getProjectionAnnotationModel() != null) {
                ProjectionModelNodeAdapterFactoryHTML factory2 = this.getAdapterFactoryHTML(true);
                if (factory2 != null) {
                    factory2.addProjectionViewer((ProjectionViewer)this.viewer);
                }
                this.addAllAdapters();
            }
        }
        ++this.fUpdatingCount;
        try {
            this.update(this.createInitialContext());
        }
        finally {
            --this.fUpdatingCount;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllAdapters() {
        System.currentTimeMillis();
        if (this.fDocument == null) return;
        IStructuredModel sModel = null;
        try {
            block9: {
                Node nextSibling;
                int siblingLevel;
                block8: {
                    sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                    if (sModel == null) return;
                    IndexedRegion startNode = sModel.getIndexedRegion(0);
                    if (startNode == null) {
                        assert (sModel instanceof IDOMModel);
                        startNode = ((IDOMModel)sModel).getDocument();
                    }
                    if (!(startNode instanceof Node)) return;
                    siblingLevel = 0;
                    nextSibling = (Node)startNode;
                    if (!true) break block8;
                    if (nextSibling == null) return;
                    if (siblingLevel >= 1000) break block9;
                }
                do {
                    Node currentNode = nextSibling;
                    nextSibling = currentNode.getNextSibling();
                    this.addAdapterToNodeAndChildrenHTML(currentNode, 0);
                    ++siblingLevel;
                    if (nextSibling == null) return;
                } while (siblingLevel < 1000);
            }
            return;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    private void addAdapterToNodeAndChildrenHTML(Node node, int childLevel) {
        if (node instanceof INodeNotifier && childLevel < 10) {
            INodeNotifier notifier = (INodeNotifier)node;
            ProjectionModelNodeAdapterHTML adapter2 = (ProjectionModelNodeAdapterHTML)notifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class);
            if (adapter2 != null) {
                adapter2.updateAdapter(node);
            } else {
                notifier.getAdapterFor(ProjectionModelNodeAdapterHTML.class);
            }
            int siblingLevel = 0;
            Node nextChild = node.getFirstChild();
            while (nextChild != null && siblingLevel < 1000) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.addAdapterToNodeAndChildrenHTML(childNode, childLevel + 1);
                ++siblingLevel;
            }
        }
    }

    private ProjectionModelNodeAdapterFactoryHTML getAdapterFactoryHTML(boolean createIfNeeded) {
        System.currentTimeMillis();
        ProjectionModelNodeAdapterFactoryHTML factory = null;
        if (this.fDocument != null) {
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null && sModel instanceof IDOMModel) {
                    FactoryRegistry factoryRegistry = sModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterHTML.class) && createIfNeeded) {
                        ProjectionModelNodeAdapterFactoryHTML newFactory = new ProjectionModelNodeAdapterFactoryHTML();
                        factoryRegistry.addFactory((INodeAdapterFactory)newFactory);
                        IDOMModel domModel = (IDOMModel)sModel;
                        IDOMDocument document = domModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)document.getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)newFactory);
                        }
                    }
                    factory = (ProjectionModelNodeAdapterFactoryHTML)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterHTML.class);
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        return factory;
    }

    private FoldingStructureComputationContext createInitialContext() {
        this.initializePreferences();
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(true);
    }

    private FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse);
    }

    private IModelElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false);
    }

    private void initializePreferences() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        this.fCollapseTypes = store.getBoolean("foldClasses");
        this.fCollapsePhpdoc = store.getBoolean("foldPHPDoc");
        this.fCollapseMembers = store.getBoolean("foldFunctions");
        this.fCollapseHeaderComments = store.getBoolean("foldHeaderComment");
    }

    private void update(FoldingStructureComputationContext ctx) {
        if (ctx == null) {
            return;
        }
        HashMap<PhpProjectionAnnotation, Position> additions = new HashMap<PhpProjectionAnnotation, Position>();
        ArrayList<PhpProjectionAnnotation> deletions = new ArrayList<PhpProjectionAnnotation>();
        ArrayList<PhpProjectionAnnotation> updates = new ArrayList<PhpProjectionAnnotation>();
        this.computeFoldingStructure(ctx);
        LinkedHashMap newStructure = ctx.fMap;
        Map<IModelElement, Object> oldStructure = this.computeCurrentStructure(ctx);
        for (Map.Entry entry : newStructure.entrySet()) {
            PhpProjectionAnnotation newAnnotation = (PhpProjectionAnnotation)((Object)entry.getKey());
            Position newPosition = (Position)entry.getValue();
            IModelElement element = newAnnotation.getElement();
            boolean isMalformedAnonymousType = newPosition.getOffset() == 0 && element.getElementType() == 7;
            List annotations = (List)oldStructure.get(element);
            if (annotations == null) {
                if (isMalformedAnonymousType) continue;
                additions.put(newAnnotation, newPosition);
                continue;
            }
            Iterator x = annotations.iterator();
            boolean matched = false;
            while (x.hasNext()) {
                boolean updateCollapsedState;
                Tuple tuple = (Tuple)x.next();
                PhpProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (newAnnotation.isComment() != existingAnnotation.isComment()) continue;
                boolean bl = updateCollapsedState = ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed();
                if (!(isMalformedAnonymousType || existingPosition == null || newPosition.equals((Object)existingPosition) && !updateCollapsedState)) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (updateCollapsedState) {
                        if (newAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
                break;
            }
            if (!matched) {
                additions.put(newAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            oldStructure.remove(element);
        }
        for (Object v : oldStructure.values()) {
            List list = (List)v;
            int size = list.size();
            int i = 0;
            while (i < size) {
                deletions.add(((Tuple)list.get((int)i)).annotation);
                ++i;
            }
        }
        this.match(deletions, additions, updates, ctx);
        Annotation[] deletedArray = deletions.toArray(new Annotation[deletions.size()]);
        Annotation[] changedArray = updates.toArray(new Annotation[updates.size()]);
        ctx.getModel().modifyAnnotations(deletedArray, additions, changedArray);
    }

    private void computeFoldingStructure(FoldingStructureComputationContext ctx) {
        IParent parent = (IParent)this.fInput;
        try {
            if (!(this.fInput instanceof ISourceReference)) {
                return;
            }
            this.computeFoldingStructure(parent.getChildren(), ctx);
        }
        catch (ModelException modelException) {}
    }

    private void computeFoldingStructure(IModelElement[] elements, FoldingStructureComputationContext ctx) throws ModelException {
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            this.computeFoldingStructure(element, ctx);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeFoldingStructure(parent.getChildren(), ctx);
            }
            ++i;
        }
    }

    protected void computeFoldingStructure(IModelElement element, FoldingStructureComputationContext ctx) {
        boolean collapse = false;
        boolean collapseCode = true;
        switch (element.getElementType()) {
            case 11: {
                collapse = ctx.collapseImportContainer();
                break;
            }
            case 7: {
                collapse = ctx.collapseTypes();
                break;
            }
            case 9: {
                collapse = ctx.collapseMembers();
                break;
            }
            case 8: {
                IModelElement parent = element.getParent();
                if (parent != null && parent.getElementType() != 7) {
                    return;
                }
                collapse = ctx.collapseMembers();
                break;
            }
            default: {
                return;
            }
        }
        IRegion[] regions = this.computeProjectionRanges((ISourceReference)element, ctx);
        if (regions.length > 0) {
            IRegion normalized;
            HashSet<IRegion> regionSet = new HashSet<IRegion>();
            int i = 0;
            while (i < regions.length - 1) {
                Position position;
                IRegion normalized2 = this.alignRegion(regions[i], ctx);
                if (normalized2 != null && regionSet.add(normalized2) && (position = this.createCommentPosition(normalized2)) != null) {
                    boolean commentCollapse = i == 0 && (regions.length > 2 || ctx.hasHeaderComment()) && element == ctx.getFirstElement() ? ctx.collapseHeaderComments() : ctx.collapseJavadoc();
                    ctx.addProjectionRange(new PhpProjectionAnnotation(commentCollapse, element, true), position);
                }
                ++i;
            }
            if (collapseCode && (normalized = this.alignRegion(regions[regions.length - 1], ctx)) != null) {
                Position position;
                Position position2 = position = element instanceof IMember ? this.createMemberPosition(normalized, (IMember)element) : this.createCommentPosition(normalized);
                if (position != null) {
                    ctx.addProjectionRange(new PhpProjectionAnnotation(collapse, element, false), position);
                }
            }
        }
    }

    protected final IRegion[] computeProjectionRanges(ISourceReference reference, FoldingStructureComputationContext ctx) {
        try {
            ISourceRange range = reference.getSourceRange();
            if (!SourceRange.isAvailable((ISourceRange)range)) {
                return new IRegion[0];
            }
            ArrayList<Object> regions = new ArrayList<Object>();
            if (!ctx.isHeaderChecked() && reference instanceof IModelElement) {
                ctx.setFirstElement((IModelElement)reference);
                ctx.setHeaderChecked();
                IRegion headerComment = this.computeHeaderComment(ctx);
                if (headerComment != null) {
                    regions.add(headerComment);
                    ctx.setHasHeaderComment();
                }
            }
            int shift = range.getOffset();
            ICommentScanner scanner = ctx.getScanner();
            scanner.resetTo(shift);
            int start = shift;
            start = scanner.computePreviousComment();
            if (start != shift) {
                start = scanner.getCurrentCommentStartPosition();
                int end = scanner.getCurrentCommentEndPosition();
                regions.add(new Region(start, end - start));
            }
            regions.add(new Region(shift, range.getLength()));
            IRegion[] result = new IRegion[regions.size()];
            regions.toArray(result);
            return result;
        }
        catch (ModelException modelException) {
            return new IRegion[0];
        }
    }

    private IRegion computeHeaderComment(FoldingStructureComputationContext ctx) throws ModelException {
        ITextRegion phpToken;
        IPhpScriptRegion textRegion;
        IStructuredDocumentRegion sdRegion;
        block9: {
            if (!(ctx.getDocument() instanceof IStructuredDocument)) {
                return null;
            }
            IStructuredDocument document = (IStructuredDocument)ctx.getDocument();
            sdRegion = document.getFirstStructuredDocumentRegion();
            int i = 0;
            while (sdRegion != null && sdRegion.getType() != "PHP_CONTENT" && i++ < 40) {
                sdRegion = sdRegion.getNext();
            }
            if (sdRegion == null || sdRegion.getType() != "PHP_CONTENT" || sdRegion.getRegions().size() < 2) {
                return null;
            }
            textRegion = (IPhpScriptRegion)sdRegion.getRegions().get(1);
            phpToken = textRegion.getPhpToken(0);
            i = 0;
            while (phpToken != null && phpToken.getType() != "PHPDOC_COMMENT_START" && i++ < 3) {
                phpToken = textRegion.getPhpToken(phpToken.getEnd() + 1);
            }
            if (phpToken != null && phpToken.getType() == "PHPDOC_COMMENT_START") break block9;
            return null;
        }
        try {
            int start = phpToken.getStart();
            Object lastToken = null;
            while (lastToken != phpToken && phpToken != null && phpToken.getType() != "PHPDOC_COMMENT_END") {
                phpToken = textRegion.getPhpToken(phpToken.getEnd() + 1);
            }
            if (phpToken != null && phpToken.getType() == "PHPDOC_COMMENT_END") {
                int end = phpToken.getEnd();
                return new Region(sdRegion.getStartOffset() + textRegion.getStart() + start, end - start);
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected final Position createCommentPosition(IRegion aligned) {
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final Position createMemberPosition(IRegion aligned, IMember member) {
        return new PhpElementPosition(aligned.getOffset(), aligned.getLength(), member);
    }

    protected final IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(Math.min(region.getOffset() + region.getLength() - 1, document.getLength()));
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }

    private ProjectionAnnotationModel getModel() {
        return this.viewer.getProjectionAnnotationModel();
    }

    private IDocument getDocument() {
        PHPStructuredEditor editor = this.fEditor;
        if (editor == null) {
            return null;
        }
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        return provider.getDocument((Object)editor.getEditorInput());
    }

    private void match(List<PhpProjectionAnnotation> deletions, Map<PhpProjectionAnnotation, Position> additions, List<PhpProjectionAnnotation> changes, FoldingStructureComputationContext ctx) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<PhpProjectionAnnotation> newDeletions = new ArrayList<PhpProjectionAnnotation>();
        ArrayList<PhpProjectionAnnotation> newChanges = new ArrayList<PhpProjectionAnnotation>();
        Iterator<PhpProjectionAnnotation> deletionIterator = deletions.iterator();
        while (deletionIterator.hasNext()) {
            PhpProjectionAnnotation deleted = deletionIterator.next();
            Position deletedPosition = ctx.getModel().getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Tuple deletedTuple = new Tuple(deleted, deletedPosition);
            Tuple match = this.findMatch(deletedTuple, changes, null, ctx);
            boolean addToDeletions = true;
            if (match == null) {
                match = this.findMatch(deletedTuple, additions.keySet(), additions, ctx);
                addToDeletions = false;
            }
            if (match == null) continue;
            IModelElement element = match.annotation.getElement();
            deleted.setElement(element);
            deletedPosition.setLength(match.position.getLength());
            if (deletedPosition instanceof PhpElementPosition && element instanceof IMember) {
                PhpElementPosition jep = (PhpElementPosition)deletedPosition;
                jep.setMember((IMember)element);
            }
            deletionIterator.remove();
            newChanges.add(deleted);
            if (!addToDeletions) continue;
            newDeletions.add(match.annotation);
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Tuple findMatch(Tuple tuple, Collection<PhpProjectionAnnotation> annotations, Map<PhpProjectionAnnotation, Position> positionMap, FoldingStructureComputationContext ctx) {
        Iterator<PhpProjectionAnnotation> it = annotations.iterator();
        while (it.hasNext()) {
            Position position;
            PhpProjectionAnnotation annotation = it.next();
            if (tuple.annotation.isComment() != annotation.isComment()) continue;
            Position position2 = position = positionMap == null ? ctx.getModel().getPosition((Annotation)annotation) : positionMap.get((Object)annotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            it.remove();
            return new Tuple(annotation, position);
        }
        return null;
    }

    private Map<IModelElement, Object> computeCurrentStructure(FoldingStructureComputationContext ctx) {
        HashMap<IModelElement, Object> map = new HashMap<IModelElement, Object>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof PhpProjectionAnnotation)) continue;
            PhpProjectionAnnotation java = (PhpProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)java);
            Assert.isNotNull((Object)position);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(java.getElement());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(java.getElement(), list);
            }
            list.add(new Tuple(java, position));
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tuple)o1).position.getOffset() - ((Tuple)o2).position.getOffset();
            }
        };
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    public final void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    public final void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    public final void collapseElements(IModelElement[] elements) {
        HashSet<IModelElement> set = new HashSet<IModelElement>(Arrays.asList(elements));
        this.modifyFiltered(new PhpElementSetFilter(set, false), false);
    }

    public final void expandElements(IModelElement[] elements) {
        HashSet<IModelElement> set = new HashSet<IModelElement>(Arrays.asList(elements));
        this.modifyFiltered(new PhpElementSetFilter(set, true), true);
    }

    private void modifyFiltered(Filter filter, boolean expand) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        ArrayList<PhpProjectionAnnotation> modified = new ArrayList<PhpProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            PhpProjectionAnnotation java;
            Object annotation = iter.next();
            if (!(annotation instanceof PhpProjectionAnnotation) || expand != (java = (PhpProjectionAnnotation)((Object)annotation)).isCollapsed() || !filter.match(java)) continue;
            if (expand) {
                java.markExpanded();
            } else {
                java.markCollapsed();
            }
            modified.add(java);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    public void projectionDisabled() {
        this.handleProjectionDisabled();
    }

    public void projectionEnabled() {
        this.handleProjectionEnabled();
    }

    private static final class CommentFilter
    implements Filter {
        private CommentFilter() {
        }

        @Override
        public boolean match(PhpProjectionAnnotation annotation) {
            return annotation.isComment() && !annotation.isMarkedDeleted();
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            Assert.isTrue((firstLine <= captionLine ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
            Assert.isTrue((captionLine <= lastLine ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    public class CommentScanner
    implements ICommentScanner {
        private final IDocument document;
        private int startElement;
        private int start;
        private int end;

        public CommentScanner(IDocument document) {
            if (document == null) {
                throw new IllegalArgumentException();
            }
            this.document = document;
        }

        @Override
        public void resetTo(int start) {
            this.startElement = start;
        }

        @Override
        public int getCurrentCommentStartPosition() {
            return this.start;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int computePreviousComment() {
            this.start = this.startElement - 1;
            try {
                while (true) {
                    if (this.start <= 0 || !Character.isWhitespace(this.document.getChar(this.start))) {
                        if (this.start <= 0 || this.document.getChar(this.start--) == '/') break;
                        return this.startElement;
                    }
                    --this.start;
                }
                int end = this.start;
                if (this.start > 0 && this.document.getChar(this.start--) != '*') {
                    return this.startElement;
                }
                while (true) {
                    if (this.start <= 0 || this.document.getChar(this.start) == '*' && this.document.getChar(this.start - 1) == '/') {
                        if (this.start != 0) break;
                        return this.startElement;
                    }
                    --this.start;
                }
                this.end = end;
                return this.start;
            }
            catch (BadLocationException badLocationException) {
                return this.startElement;
            }
        }

        @Override
        public int getCurrentCommentEndPosition() {
            return this.end;
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IModelElementDelta delta = this.findElement(StructuredTextFoldingProviderPHP.this.fInput, e.getDelta());
            if (delta != null && (delta.getFlags() & 9) != 0) {
                if (this.shouldIgnoreDelta(e.getDelta().getElement(), delta)) {
                    return;
                }
                StructuredTextFoldingProviderPHP structuredTextFoldingProviderPHP = StructuredTextFoldingProviderPHP.this;
                structuredTextFoldingProviderPHP.fUpdatingCount = structuredTextFoldingProviderPHP.fUpdatingCount + 1;
                try {
                    StructuredTextFoldingProviderPHP.this.update(StructuredTextFoldingProviderPHP.this.createContext(false));
                }
                finally {
                    StructuredTextFoldingProviderPHP structuredTextFoldingProviderPHP2 = StructuredTextFoldingProviderPHP.this;
                    structuredTextFoldingProviderPHP2.fUpdatingCount = structuredTextFoldingProviderPHP2.fUpdatingCount - 1;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean shouldIgnoreDelta(IModelElement ast, IModelElementDelta delta) {
            if (ast == null) {
                return false;
            }
            if (!(ast.getResource() instanceof IFile)) {
                return false;
            }
            IFile resource = (IFile)ast.getResource();
            IDocument document = StructuredTextFoldingProviderPHP.this.getDocument();
            if (document == null) {
                return false;
            }
            PHPStructuredEditor editor = StructuredTextFoldingProviderPHP.this.fEditor;
            if (editor == null) return false;
            if (editor.getCachedSelectedRange() == null) {
                return false;
            }
            int caretLine = 0;
            try {
                caretLine = document.getLineOfOffset(editor.getCachedSelectedRange().x) + 1;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            if (caretLine <= 0) return false;
            try {
                IMarker[] problems = resource.findMarkers("org.eclipse.dltk.core.problem", false, 2);
                int i = 0;
                while (true) {
                    if (i >= problems.length) {
                        return false;
                    }
                    IMarker marker = problems[i];
                    boolean isInCaret = this.isCaretLine(caretLine, "lineNumber", marker);
                    boolean isSyntaxError = this.isCaretLine(2, "severity", marker);
                    if (isSyntaxError && isInCaret) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        private final boolean isCaretLine(int expected, String attribute, IMarker marker) throws CoreException {
            Object res = marker.getAttribute(attribute);
            return res != null && res instanceof Integer && (Integer)res == expected;
        }

        private IModelElementDelta findElement(IModelElement target, IModelElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (element.getElementType() > 6) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(PhpProjectionAnnotation var1);
    }

    protected final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        private IModelElement fFirstElement;
        private boolean fHasHeaderComment;
        private LinkedHashMap<Object, Position> fMap = new LinkedHashMap();
        private ICommentScanner fScanner;
        private boolean headerChecked = false;

        private FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            Assert.isNotNull((Object)document);
            Assert.isNotNull((Object)model);
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
        }

        private void setFirstElement(IModelElement element) {
            if (this.hasFirstElement()) {
                throw new IllegalStateException();
            }
            this.fFirstElement = element;
        }

        boolean hasFirstElement() {
            return this.fFirstElement != null;
        }

        private IModelElement getFirstElement() {
            return this.fFirstElement;
        }

        private boolean hasHeaderComment() {
            return this.fHasHeaderComment;
        }

        private void setHasHeaderComment() {
            this.fHasHeaderComment = true;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        private IDocument getDocument() {
            return this.fDocument;
        }

        private ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        private ICommentScanner getScanner() {
            if (this.fScanner == null) {
                this.fScanner = new CommentScanner(this.fDocument);
            }
            return this.fScanner;
        }

        public void addProjectionRange(PhpProjectionAnnotation annotation, Position position) {
            this.fMap.put((Object)annotation, position);
        }

        public boolean collapseHeaderComments() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderPHP.this.fCollapseHeaderComments;
        }

        public boolean collapseImportContainer() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderPHP.this.fCollapseImportContainer;
        }

        public boolean collapseTypes() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderPHP.this.fCollapseTypes;
        }

        public boolean collapseJavadoc() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderPHP.this.fCollapsePhpdoc;
        }

        public boolean collapseMembers() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderPHP.this.fCollapseMembers;
        }

        public boolean isHeaderChecked() {
            return this.headerChecked;
        }

        public void setHeaderChecked() {
            this.headerChecked = true;
        }
    }

    private static interface ICommentScanner {
        public void resetTo(int var1);

        public int computePreviousComment();

        public int getCurrentCommentStartPosition();

        public int getCurrentCommentEndPosition();
    }

    private static final class MemberFilter
    implements Filter {
        private MemberFilter() {
        }

        @Override
        public boolean match(PhpProjectionAnnotation annotation) {
            IModelElement element;
            return !annotation.isComment() && !annotation.isMarkedDeleted() && (element = annotation.getElement()) instanceof IMember && (element.getElementType() != 7 || ((IMember)element).getDeclaringType() != null);
        }
    }

    private static final class PhpElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public PhpElementPosition(int offset, int length, IMember member) {
            super(offset, length);
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public void setMember(IMember member) {
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (ModelException modelException) {}
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (ModelException modelException) {}
            return nameStart - this.offset;
        }
    }

    private static final class PhpElementSetFilter
    implements Filter {
        private final Set<IModelElement> fSet;
        private final boolean fMatchCollapsed;

        private PhpElementSetFilter(Set<IModelElement> set, boolean matchCollapsed) {
            this.fSet = set;
            this.fMatchCollapsed = matchCollapsed;
        }

        @Override
        public boolean match(PhpProjectionAnnotation annotation) {
            IModelElement element;
            boolean stateMatch;
            boolean bl = stateMatch = this.fMatchCollapsed == annotation.isCollapsed();
            return stateMatch && !annotation.isComment() && !annotation.isMarkedDeleted() && this.fSet.contains(element = annotation.getElement());
        }
    }

    protected static final class PhpProjectionAnnotation
    extends ProjectionAnnotation {
        private IModelElement fJavaElement;
        private boolean fIsComment;

        public PhpProjectionAnnotation(boolean isCollapsed, IModelElement element, boolean isComment) {
            super(isCollapsed);
            this.fJavaElement = element;
            this.fIsComment = isComment;
        }

        IModelElement getElement() {
            return this.fJavaElement;
        }

        void setElement(IModelElement element) {
            this.fJavaElement = element;
        }

        boolean isComment() {
            return this.fIsComment;
        }

        void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public String toString() {
            return "PhpProjectionAnnotation:\n\telement: \t" + this.fJavaElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment() + "\n";
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            StructuredTextFoldingProviderPHP.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            StructuredTextFoldingProviderPHP.this.handleProjectionDisabled();
        }
    }

    private static final class Tuple {
        PhpProjectionAnnotation annotation;
        Position position;

        Tuple(PhpProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }
}

