/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.evaluator;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluator;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMModelManager;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.qvtd.debug.evaluator.IQVTiVMEvaluationEnvironment;
import org.eclipse.qvtd.debug.evaluator.QVTiVMEnvironment;
import org.eclipse.qvtd.debug.evaluator.QVTiVMEnvironmentFactory;
import org.eclipse.qvtd.debug.evaluator.QVTiVMModelManager;
import org.eclipse.qvtd.debug.evaluator.QVTiVMRootEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.xtext.qvtimperative.utilities.QVTiXtextEvaluator;

public class QVTiVMEvaluator
implements IVMEvaluator {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final Transformation transformation;
    @NonNull
    protected final QVTiVMEnvironmentFactory envFactory;
    @NonNull
    protected final QVTiVMEnvironment env;
    @NonNull
    protected final QVTiVMModelManager modelManager;
    private boolean suspendOnStartup = false;

    private QVTiVMEvaluator(@NonNull QVTiVMEnvironmentFactory envFactory, @NonNull Transformation transformation) {
        this.envFactory = envFactory;
        this.metaModelManager = envFactory.getMetaModelManager();
        this.transformation = transformation;
        this.env = envFactory.createEnvironment();
        QVTiTransformationAnalysis transformationAnalysis = envFactory.createTransformationAnalysis();
        transformationAnalysis.analyzeTransformation(transformation);
        this.modelManager = envFactory.createModelManager(transformationAnalysis);
    }

    public QVTiVMEvaluator(@NonNull QVTiVMEnvironmentFactory envFactory, @NonNull URI transformationURI) throws IOException {
        this(envFactory, QVTiXtextEvaluator.loadTransformation((MetaModelManager)envFactory.getMetaModelManager(), (URI)transformationURI, (boolean)envFactory.keepDebug()));
    }

    public void createModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        TypedModel typedModel = (TypedModel)DomainUtil.getNamedElement((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.metaModelManager.getExternalResourceSet().createResource(modelURI, contentType);
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void dispose() {
        this.modelManager.dispose();
    }

    public Boolean execute() {
        Transformation transformation = this.getTransformation();
        IQVTiVMEvaluationEnvironment evalEnv = this.envFactory.createEvaluationEnvironment(this.modelManager, transformation);
        QVTiVMRootEvaluationVisitor visitor = this.envFactory.createEvaluationVisitor(this.env, evalEnv);
        visitor.start(this.suspendOnStartup);
        return (Boolean)transformation.accept((Visitor)visitor);
    }

    @NonNull
    public Transformation getDebuggable() {
        return this.getTransformation();
    }

    @NonNull
    public final QVTiVMEnvironment getEnvironment() {
        return this.env;
    }

    @NonNull
    public final QVTiVMEnvironmentFactory getEnvironmentFactory() {
        return this.envFactory;
    }

    @NonNull
    public final MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @NonNull
    public final IVMModelManager getModelManager() {
        return this.modelManager;
    }

    @NonNull
    public Transformation getTransformation() {
        return this.transformation;
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        Resource resource;
        TypedModel typedModel = (TypedModel)DomainUtil.getNamedElement((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        if (contentType == null) {
            resource = this.metaModelManager.getExternalResourceSet().getResource(modelURI, true);
        } else {
            resource = this.metaModelManager.getExternalResourceSet().createResource(modelURI, contentType);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void saveModels() {
    }

    public void setSuspendOnStartUp(boolean suspendOnStartup) {
        this.suspendOnStartup = suspendOnStartup;
    }
}

