/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Multiset;
import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.internal.apidocs.rcp.Messages;
import org.eclipse.recommenders.internal.apidocs.rcp.SourceCodeArea;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.utils.Bags;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class ApidocsViewUtils {
    public static final Font CODEFONT = JFaceResources.getTextFont();
    public static final Font BOLDFONT = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    public static final Map<Integer, Color> COLORCACHE = new HashMap<Integer, Color>();

    private ApidocsViewUtils() {
    }

    public static void disposeChildren(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    public static void setInfoBackgroundColor(Control c) {
        Display display = c.getDisplay();
        Color color = display.getSystemColor(29);
        c.setBackground(color);
    }

    public static void setInfoForegroundColor(Control c) {
        Display display = c.getDisplay();
        Color color = display.getSystemColor(28);
        c.setForeground(color);
    }

    public static Composite createGridComposite(Composite parent, int columns, int hSpacing, int vSpacing, int hMargin, int vMargin) {
        Composite composite = new Composite(parent, 0);
        ApidocsViewUtils.setInfoBackgroundColor((Control)composite);
        GridLayout layout = GridLayoutFactory.swtDefaults().numColumns(columns).margins(hMargin, vMargin).spacing(hSpacing, vSpacing).create();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    static void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
    }

    public static Table renderMethodDirectivesBlock(Composite parent, Multiset<IMethodName> methods, int total, EventBus bus, JavaElementResolver resolver, String middlePhrase) {
        Table table = new Table(parent, 32768);
        table.setBackground(ApidocsViewUtils.createColor(29));
        table.setForeground(ApidocsViewUtils.createColor(28));
        table.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).create());
        TableColumn column1 = new TableColumn(table, 0);
        TableColumn column2 = new TableColumn(table, 0);
        TableColumn column3 = new TableColumn(table, 0);
        TableColumn column4 = new TableColumn(table, 0);
        for (Multiset.Entry method : Bags.orderedByCount(methods)) {
            int frequency = method.getCount();
            double percentage = (double)frequency / (double)total;
            if (percentage < 0.05) continue;
            String phraseText = ApidocsViewUtils.percentageToRecommendationPhrase((int)Math.round(100.0 * percentage));
            String stats = MessageFormat.format(Messages.TABLE_CELL_SUFFIX_FREQUENCIES, percentage, frequency);
            Link bar = ApidocsViewUtils.createMethodLink((Composite)table, (IMethodName)method.getElement(), resolver, bus);
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{phraseText, middlePhrase, bar.getText(), stats});
            ApidocsViewUtils.bold(item, 0);
            TableEditor editor = new TableEditor(table);
            editor.grabVertical = true;
            editor.grabHorizontal = true;
            editor.setEditor((Control)bar, item, 2);
        }
        column1.pack();
        column2.pack();
        column3.pack();
        column4.pack();
        return table;
    }

    public static Link createMethodLink(Composite parent, final IMethod method, final EventBus workspaceBus) {
        String text = "<a>" + JavaElementLabels.getElementLabel((IJavaElement)method, (long)33L) + "</a>";
        String tooltip = JavaElementLabels.getElementLabel((IJavaElement)method, (long)JavaElementLabels.DEFAULT_QUALIFIED);
        Link link = new Link(parent, 0);
        link.setText(text);
        link.setBackground(ApidocsViewUtils.createColor(29));
        link.setToolTipText(tooltip);
        link.setFont(JFaceResources.getDialogFont());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaElementSelectionEvent event = new JavaElementSelectionEvent((IJavaElement)method, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
                workspaceBus.post((Object)event);
            }
        });
        return link;
    }

    public static Link createMethodLink(Composite parent, final IMethodName method, final JavaElementResolver resolver, final EventBus workspaceBus) {
        String text = "<a>" + Names.vm2srcSimpleMethod((IMethodName)method) + "</a>";
        String tooltip = Names.vm2srcQualifiedMethod((IMethodName)method);
        final Link link = new Link(parent, 0);
        link.setText(text);
        link.setBackground(ApidocsViewUtils.createColor(29));
        link.setFont(JFaceResources.getDialogFont());
        link.setToolTipText(tooltip);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional opt = resolver.toJdtMethod(method);
                if (opt.isPresent()) {
                    JavaElementSelectionEvent event = new JavaElementSelectionEvent((IJavaElement)opt.get(), JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
                    workspaceBus.post((Object)event);
                } else {
                    link.setEnabled(false);
                }
            }
        });
        return link;
    }

    public static Label createLabel(Composite parent, String text, boolean wrap) {
        return ApidocsViewUtils.createLabel(parent, text, false, false, 28, wrap);
    }

    public static Label createLabel(Composite parent, String text, boolean bold, boolean code, int color, boolean wrap) {
        Label label = new Label(parent, 64);
        label.setText(text);
        ApidocsViewUtils.setInfoBackgroundColor((Control)label);
        if (code) {
            label.setFont(CODEFONT);
        } else if (bold) {
            label.setFont(BOLDFONT);
        }
        label.setForeground(ApidocsViewUtils.createColor(color));
        if (wrap) {
            label.setLayoutData((Object)new GridData(4, 128, true, false));
        }
        return label;
    }

    public static CLabel createCLabel(Composite parent, String text, boolean bold, Image image) {
        CLabel label = new CLabel(parent, 0);
        ApidocsViewUtils.setInfoBackgroundColor((Control)label);
        label.setText(text);
        if (bold) {
            label.setFont(BOLDFONT);
        }
        label.setImage(image);
        return label;
    }

    public static Text createText(Composite parent, String text, int width) {
        Text textComponent = new Text(parent, 2052);
        textComponent.setText(text);
        GridData gridData = new GridData(4, 128, false, false);
        gridData.widthHint = width;
        textComponent.setLayoutData((Object)gridData);
        return textComponent;
    }

    public static Text createTextArea(Composite parent, String text, int height, int width) {
        Text textComponent = new Text(parent, 2626);
        textComponent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(width, height).create());
        textComponent.setText(text);
        return textComponent;
    }

    public static StyledText createStyledText(Composite parent, String text, int color, boolean grabExcessHorizontalSpace) {
        StyledText styledText = new StyledText(parent, 64);
        styledText.setEnabled(false);
        styledText.setDoubleClickEnabled(false);
        styledText.setLayoutData((Object)new GridData(4, 0x1000000, grabExcessHorizontalSpace, false));
        styledText.setEditable(false);
        styledText.setText(text);
        styledText.setForeground(ApidocsViewUtils.createColor(color));
        return styledText;
    }

    public static void createStyleRange(StyledText styledText, int start, int length, int fontStyle, boolean makeBlue, boolean makeCodeFont) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        styleRange.fontStyle = fontStyle;
        if (makeBlue) {
            styleRange.foreground = ApidocsViewUtils.createColor(9);
        }
        if (makeCodeFont) {
            styleRange.font = CODEFONT;
        }
        styledText.setStyleRange(styleRange);
    }

    public static StyleRange createStyleRange(int start, int length, int fontStyle, boolean makeBlue, boolean makeCodeFont) {
        StyleRange range = new StyleRange();
        range.start = start;
        range.length = length;
        range.fontStyle = fontStyle;
        if (makeBlue) {
            range.foreground = ApidocsViewUtils.createColor(9);
        }
        if (makeCodeFont) {
            range.font = CODEFONT;
        }
        return range;
    }

    public static Font bold(Font src, Display d) {
        FontData[] fD = src.getFontData();
        fD[0].setStyle(1);
        return new Font((Device)d, fD[0]);
    }

    public static void bold(TableItem item, int index) {
        item.setFont(index, ApidocsViewUtils.bold(item.getFont(), item.getDisplay()));
    }

    public static void bold(Control item) {
        item.setFont(ApidocsViewUtils.bold(item.getFont(), item.getDisplay()));
    }

    public static CLabel createLink(Composite parent, String text, String tooltip, Image image, boolean blueColor, MouseListener listener) {
        final CLabel link = new CLabel(parent, 0);
        link.setText(text);
        if (tooltip != null) {
            link.setToolTipText(tooltip);
        }
        if (blueColor) {
            link.setForeground(ApidocsViewUtils.createColor(9));
        }
        link.setImage(image);
        link.addMouseListener(listener);
        link.setCursor(new Cursor((Device)parent.getDisplay(), 21));
        if (blueColor) {
            link.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent event) {
                    link.setForeground(ApidocsViewUtils.createColor(9));
                }

                public void mouseEnter(MouseEvent event) {
                    link.setForeground(ApidocsViewUtils.createColor(10));
                }
            });
        }
        return link;
    }

    public static String percentageToRecommendationPhrase(int percentage) {
        if (percentage >= 95) {
            return Messages.TABLE_CELL_FREQUENCY_ALWAYS;
        }
        if (percentage >= 65) {
            return Messages.TABLE_CELL_FREQUENCY_USUALLY;
        }
        if (percentage >= 25) {
            return Messages.TABLE_CELL_FREQUENCY_SOMETIMES;
        }
        if (percentage >= 10) {
            return Messages.TABLE_CELL_FREQUENCY_OCCASIONALLY;
        }
        return Messages.TABLE_CELL_FREQUENCY_RARELY;
    }

    public static SourceCodeArea createSourceCodeArea(Composite parent, String snippet) {
        SourceCodeArea area = new SourceCodeArea(parent);
        area.setCode(snippet);
        return area;
    }

    public static Button createButton(Composite parent, String text, SelectionListener selectionListener) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener(selectionListener);
        return button;
    }

    public static Color createColor(int swtColor) {
        Integer color = swtColor;
        if (!COLORCACHE.containsKey(color)) {
            COLORCACHE.put(color, Display.getCurrent().getSystemColor(swtColor));
        }
        return COLORCACHE.get(color);
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        Composite container = new Composite(parent, 0);
        ApidocsViewUtils.setInfoBackgroundColor((Control)container);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 0).spacing(0, 0).numColumns(numColumns).create());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        return container;
    }
}

