/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Multiset;
import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.recommenders.apidocs.ClassSelfCallsModelProvider;
import org.eclipse.recommenders.apidocs.ClassSelfcallDirectives;
import org.eclipse.recommenders.apidocs.MethodSelfCallsDirectivesModelProvider;
import org.eclipse.recommenders.apidocs.MethodSelfcallDirectives;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.recommenders.internal.apidocs.rcp.Messages;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueMethodName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Bags;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class SelfCallsProvider
extends ApidocProvider {
    private final JavaElementResolver resolver;
    private final IProjectCoordinateProvider pcProvider;
    private final EventBus workspaceBus;
    private final ClassSelfCallsModelProvider cStore;
    private final MethodSelfCallsDirectivesModelProvider mStore;

    @Inject
    public SelfCallsProvider(JavaElementResolver resolver, IProjectCoordinateProvider pcProvider, EventBus workspaceBus, IModelRepository modelRepo, IModelIndex modelIndex) {
        this.resolver = resolver;
        this.pcProvider = pcProvider;
        this.workspaceBus = workspaceBus;
        this.mStore = new MethodSelfCallsDirectivesModelProvider(modelRepo, modelIndex);
        this.cStore = new ClassSelfCallsModelProvider(modelRepo, modelIndex);
    }

    @JavaSelectionSubscriber
    public void onTypeRootSelection(ITypeRoot root, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        IType type = root.findPrimaryType();
        if (type != null) {
            this.onTypeSelection(type, event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onTypeSelection(IType type, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        UniqueTypeName name = (UniqueTypeName)this.pcProvider.toUniqueName(type).orNull();
        Optional model = this.cStore.acquireModel((IUniqueName)name);
        if (model.isPresent()) {
            this.runSyncInUiThread(new TypeSelfcallDirectivesRenderer(type, (ClassSelfcallDirectives)model.get(), parent));
        }
    }

    @JavaSelectionSubscriber
    public void onMethodSelection(IMethod method, JavaElementSelectionEvent event, Composite parent) {
        IMethod current = method;
        while (current != null) {
            UniqueMethodName name = (UniqueMethodName)this.pcProvider.toUniqueName(current).orNull();
            Optional selfcalls = this.mStore.acquireModel((IUniqueName)name);
            if (selfcalls.isPresent()) {
                this.runSyncInUiThread(new MethodSelfcallDirectivesRenderer(method, (MethodSelfcallDirectives)selfcalls.get(), parent));
            }
            current = (IMethod)JdtUtils.findOverriddenMethod((IMethod)current).orNull();
        }
    }

    private class MethodSelfcallDirectivesRenderer
    implements Runnable {
        private final IMethod method;
        private final MethodSelfcallDirectives directive;
        private final Composite parent;
        private Composite container;

        public MethodSelfcallDirectivesRenderer(IMethod method, MethodSelfcallDirectives selfcalls, Composite parent) {
            this.method = method;
            this.directive = selfcalls;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            this.addDirectives();
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ApidocsViewUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
        }

        private void addHeader() {
            String message = MessageFormat.format(Messages.PROVIDER_INTRO_IMPLEMENTOR_SELFCALL_STATISTIC, this.directive.getNumberOfDefinitions(), this.method.getElementName());
            ApidocsViewUtils.createLabel(this.container, message, true);
        }

        private void addDirectives() {
            int numberOfSubclasses = this.directive.getNumberOfDefinitions();
            Multiset b = Bags.newHashMultiset((Map)this.directive.getCalls());
            ApidocsViewUtils.renderMethodDirectivesBlock(this.container, (Multiset<IMethodName>)b, numberOfSubclasses, SelfCallsProvider.this.workspaceBus, SelfCallsProvider.this.resolver, Messages.TABLE_CELL_RELATION_CALL);
        }
    }

    private class TypeSelfcallDirectivesRenderer
    implements Runnable {
        private final IType type;
        private final ClassSelfcallDirectives directive;
        private final Composite parent;
        private Composite container;

        public TypeSelfcallDirectivesRenderer(IType type, ClassSelfcallDirectives selfcalls, Composite parent) {
            this.type = type;
            this.directive = selfcalls;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            this.addDirectives();
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ApidocsViewUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
        }

        private void addHeader() {
            String message = MessageFormat.format(Messages.PROVIDER_INTRO_SUBCLASS_SELFCALL_STATISTICS, this.directive.getNumberOfSubclasses(), this.type.getElementName());
            ApidocsViewUtils.createLabel(this.container, message, true);
        }

        private void addDirectives() {
            int numberOfSubclasses = this.directive.getNumberOfSubclasses();
            Multiset b = Bags.newHashMultiset((Map)this.directive.getCalls());
            ApidocsViewUtils.renderMethodDirectivesBlock(this.container, (Multiset<IMethodName>)b, numberOfSubclasses, SelfCallsProvider.this.workspaceBus, SelfCallsProvider.this.resolver, Messages.TABLE_CELL_RELATION_CALL);
        }
    }
}

