/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CompletionRcpPreferences
extends AbstractPreferenceInitializer {
    private static final char DISABLED_FLAG = '!';
    private static final char SEPARATOR = ';';
    @Inject
    @Preference(value="sessionprocessors")
    private String enabledSessionProcessorString;
    private final Set<SessionProcessorDescriptor> availableProcessors;

    public CompletionRcpPreferences() {
        this(CompletionRcpPreferences.readExtensionPoint());
    }

    @VisibleForTesting
    public CompletionRcpPreferences(Set<SessionProcessorDescriptor> availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    private static Set<SessionProcessorDescriptor> readExtensionPoint() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.recommenders.completion.rcp.sessionprocessors");
        HashSet descriptors = Sets.newHashSet();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            SessionProcessorDescriptor descriptor = new SessionProcessorDescriptor(element);
            descriptors.add(descriptor);
            ++n2;
        }
        return descriptors;
    }

    public void initializeDefaultPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.completion.rcp");
        store.setDefault("sessionprocessors", CompletionRcpPreferences.toString(Maps.asMap(this.availableProcessors, (Function)new Function<SessionProcessorDescriptor, Boolean>(){

            public Boolean apply(SessionProcessorDescriptor descriptor) {
                return descriptor.isEnabledByDefault();
            }
        })));
    }

    public Set<SessionProcessorDescriptor> getAvailableSessionProcessors() {
        return this.availableProcessors;
    }

    public Set<SessionProcessorDescriptor> getEnabledSessionProcessors() {
        return Maps.filterValues(CompletionRcpPreferences.fromString(this.availableProcessors, this.enabledSessionProcessorString), (Predicate)new Predicate<Boolean>(){

            public boolean apply(Boolean input) {
                return input;
            }
        }).keySet();
    }

    public SessionProcessorDescriptor getSessionProcessorDescriptor(String id) {
        return CompletionRcpPreferences.find(this.availableProcessors, id);
    }

    public void setSessionProcessorEnabled(Collection<SessionProcessorDescriptor> enabledDescriptors, Collection<SessionProcessorDescriptor> disabledDescriptors) {
        Map<SessionProcessorDescriptor, Boolean> result = CompletionRcpPreferences.fromString(this.availableProcessors, this.enabledSessionProcessorString);
        for (SessionProcessorDescriptor enabledDescriptor : enabledDescriptors) {
            result.put(enabledDescriptor, true);
        }
        for (SessionProcessorDescriptor disabledDescriptor : disabledDescriptors) {
            result.put(disabledDescriptor, false);
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.completion.rcp");
        store.setValue("sessionprocessors", CompletionRcpPreferences.toString(result));
    }

    public boolean isEnabled(SessionProcessorDescriptor processor) {
        Map<SessionProcessorDescriptor, Boolean> map = CompletionRcpPreferences.fromString(this.availableProcessors, this.enabledSessionProcessorString);
        return map.containsKey(processor) ? map.get(processor) : false;
    }

    private static String toString(Map<SessionProcessorDescriptor, Boolean> descriptors) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<SessionProcessorDescriptor, Boolean>> it = descriptors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SessionProcessorDescriptor, Boolean> entry = it.next();
            SessionProcessorDescriptor descriptor = entry.getKey();
            Boolean enabled = entry.getValue();
            if (!enabled.booleanValue()) {
                sb.append('!');
            }
            sb.append(descriptor.getId());
            if (!it.hasNext()) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    private static Map<SessionProcessorDescriptor, Boolean> fromString(Iterable<SessionProcessorDescriptor> descriptors, String string) {
        HashMap result = Maps.newHashMap();
        String[] stringArray = StringUtils.split((String)string, (char)';');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean enabled;
            String id = stringArray[n2];
            if (id.charAt(0) == '!') {
                enabled = false;
                id = id.substring(1);
            } else {
                enabled = true;
            }
            SessionProcessorDescriptor found = CompletionRcpPreferences.find(descriptors, id);
            if (found != null) {
                result.put(found, enabled);
            }
            ++n2;
        }
        return result;
    }

    private static SessionProcessorDescriptor find(Iterable<SessionProcessorDescriptor> descriptors, String id) {
        for (SessionProcessorDescriptor descriptor : descriptors) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    @VisibleForTesting
    public void setEnabledSessionProcessorString(String enabledSessionProcessorString) {
        this.enabledSessionProcessorString = enabledSessionProcessorString;
    }
}

