/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Versions;
import org.eclipse.recommenders.utils.Zips;

public class MavenPomPropertiesAdvisor
extends AbstractProjectCoordinateAdvisor {
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String VERSION = "version";
    private static final String POM_PROPERTIES_FILE_REGEX = "META-INF/maven/.*/.*/pom.properties";
    private final Zips.IFileToJarFileConverter jarFileConverter;

    public MavenPomPropertiesAdvisor() {
        this.jarFileConverter = new Zips.DefaultJarFileConverter();
    }

    @VisibleForTesting
    MavenPomPropertiesAdvisor(Zips.IFileToJarFileConverter fileToJarFileConverter) {
        this.jarFileConverter = fileToJarFileConverter;
    }

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        JarFile jarFile = (JarFile)this.readJarFileIn(dependencyInfo.getFile()).orNull();
        if (jarFile == null) {
            return Optional.absent();
        }
        try {
            Optional<ProjectCoordinate> optional = this.extractProjectCoordinateOfJarFile(jarFile);
            return optional;
        }
        catch (IOException iOException) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            Zips.closeQuietly((ZipFile)jarFile);
        }
    }

    private Optional<ProjectCoordinate> extractProjectCoordinateOfJarFile(JarFile jarFile) throws IOException {
        Optional candidate = Optional.absent();
        Iterator<JarEntry> entries = this.pomPropertiesIterator(jarFile);
        while (entries.hasNext()) {
            JarEntry entry = entries.next();
            InputStream pomProperties = jarFile.getInputStream(entry);
            Optional<ProjectCoordinate> projectCoordinate = this.parseProjectCoordinate(pomProperties, entry.getName());
            IOUtils.closeQuietly((Closeable)pomProperties);
            if (projectCoordinate.isPresent() && candidate.isPresent()) {
                return Optional.absent();
            }
            candidate = candidate.or(projectCoordinate);
        }
        return candidate;
    }

    private Optional<ProjectCoordinate> parseProjectCoordinate(InputStream inputStream, String propertiesFileName) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            String groupID = this.parseGroupID(properties);
            String artifactID = this.parseArtifactID(properties);
            String version = this.parseVersion(properties);
            if (!groupID.equals(MavenPomPropertiesAdvisor.extractGroupID(propertiesFileName))) {
                return Optional.absent();
            }
            if (!artifactID.equals(MavenPomPropertiesAdvisor.extractArtifactID(propertiesFileName))) {
                return Optional.absent();
            }
            return Coordinates.tryNewProjectCoordinate(groupID, artifactID, Versions.canonicalizeVersion((String)version));
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
    }

    private Iterator<JarEntry> pomPropertiesIterator(JarFile jarFile) {
        return Iterators.filter((Iterator)Iterators.forEnumeration(jarFile.entries()), (Predicate)new Predicate<JarEntry>(){

            public boolean apply(JarEntry entry) {
                return entry.getName().matches(MavenPomPropertiesAdvisor.POM_PROPERTIES_FILE_REGEX);
            }
        });
    }

    private Optional<JarFile> readJarFileIn(File file) {
        return this.jarFileConverter.createJarFile(file);
    }

    private String parseAttribute(Properties properties, String attributeName) {
        String value = properties.getProperty(attributeName);
        return value;
    }

    private String parseGroupID(Properties properties) {
        return this.parseAttribute(properties, GROUP_ID);
    }

    private String parseArtifactID(Properties properties) {
        return this.parseAttribute(properties, ARTIFACT_ID);
    }

    private String parseVersion(Properties properties) {
        return this.parseAttribute(properties, VERSION);
    }

    @Override
    public boolean isApplicable(DependencyType dependencyType) {
        return dependencyType == DependencyType.JAR;
    }

    public static String extractGroupID(String fileName) {
        return MavenPomPropertiesAdvisor.extract(fileName, 3);
    }

    public static String extractArtifactID(String fileName) {
        return MavenPomPropertiesAdvisor.extract(fileName, 2);
    }

    public static String extract(String fileName, int index) {
        String[] split = fileName.split("/");
        if (split.length >= 4) {
            return split[split.length - index];
        }
        return "";
    }
}

