/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.editors;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.UUID;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.value.SelfValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetEditor;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetEditorInput;
import org.eclipse.recommenders.rcp.utils.ObjectToBooleanConverter;
import org.eclipse.recommenders.rcp.utils.Selections;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SnippetMetadataPage
extends FormPage {
    private ISnippet snippet;
    private Text txtName;
    private Text txtDescription;
    private Text txtUuid;
    private ListViewer listViewerExtraSearchTerms;
    private ListViewer listViewerTags;
    private Composite btnContainerExtraSearchTerms;
    private Composite btnContainerTags;
    private Button btnAddExtraSearchTerm;
    private Button btnAddTag;
    private Button btnRemoveExtraSearchTerm;
    private Button btnRemoveTag;
    private IObservableList ppExtraSearchTerms;
    private IObservableList ppTags;
    private DataBindingContext ctx;
    private final Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();

    public SnippetMetadataPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(Messages.EDITOR_LABEL_TITLE_METADATA);
        Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(3, false));
        Label lblName = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_NAME, 0);
        lblName.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        int horizontalIndent = this.decorationImage.getBounds().width + 2;
        this.txtName = managedForm.getToolkit().createText(managedForm.getForm().getBody(), null, 0);
        this.txtName.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).indent(horizontalIndent, 0).create());
        final ControlDecoration decor = new ControlDecoration((Control)this.txtName, 16384);
        decor.setDescriptionText(Messages.ERROR_SNIPPET_NAME_CAN_NOT_BE_EMPTY);
        decor.setImage(this.decorationImage);
        decor.setMarginWidth(1);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (Strings.isNullOrEmpty((String)SnippetMetadataPage.this.txtName.getText())) {
                    decor.show();
                } else {
                    decor.hide();
                }
            }
        });
        Label lblDescription = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_DESCRIPTION, 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtDescription = managedForm.getToolkit().createText(managedForm.getForm().getBody(), null, 0);
        this.txtDescription.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).indent(horizontalIndent, 0).create());
        Label lblExtraSearchTerms = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPETS_EXTRA_SEARCH_TERMS, 0);
        lblExtraSearchTerms.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.listViewerExtraSearchTerms = new ListViewer(managedForm.getForm().getBody(), 2560);
        List lstExtraSearchTerm = this.listViewerExtraSearchTerms.getList();
        lstExtraSearchTerm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(horizontalIndent, 0).create());
        this.btnContainerExtraSearchTerms = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
        this.btnContainerExtraSearchTerms.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        managedForm.getToolkit().paintBordersFor(this.btnContainerExtraSearchTerms);
        this.btnContainerExtraSearchTerms.setLayout((Layout)new GridLayout(1, false));
        this.btnAddExtraSearchTerm = managedForm.getToolkit().createButton(this.btnContainerExtraSearchTerms, Messages.EDITOR_BUTTON_ADD_EXTRASEARCH_TERM, 0);
        this.btnAddExtraSearchTerm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnippetMetadataPage.this.createExtraSearchTermInputDialog(SnippetMetadataPage.this.btnContainerExtraSearchTerms.getShell()).open();
            }
        });
        this.btnAddExtraSearchTerm.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemoveExtraSearchTerm = managedForm.getToolkit().createButton(this.btnContainerExtraSearchTerms, Messages.EDITOR_BUTTON_REMOVE_EXTRA_SEARCH_TERM, 0);
        this.btnRemoveExtraSearchTerm.setEnabled(false);
        this.btnRemoveExtraSearchTerm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerExtraSearchTerms);
                if (o.isPresent()) {
                    SnippetMetadataPage.this.ppExtraSearchTerms.remove(o.get());
                }
            }
        });
        this.btnRemoveExtraSearchTerm.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblTag = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPETS_TAG, 0);
        lblTag.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.listViewerTags = new ListViewer(managedForm.getForm().getBody(), 2560);
        List lstTags = this.listViewerTags.getList();
        lstTags.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(horizontalIndent, 0).create());
        this.btnContainerTags = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
        this.btnContainerTags.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        managedForm.getToolkit().paintBordersFor(this.btnContainerExtraSearchTerms);
        this.btnContainerTags.setLayout((Layout)new GridLayout(1, false));
        this.btnAddTag = managedForm.getToolkit().createButton(this.btnContainerTags, Messages.EDITOR_BUTTON_ADD_TAGS, 0);
        this.btnAddTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnippetMetadataPage.this.createTagInputDialog(SnippetMetadataPage.this.btnContainerTags.getShell()).open();
            }
        });
        this.btnAddTag.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemoveTag = managedForm.getToolkit().createButton(this.btnContainerTags, Messages.EDITOR_BUTTON_REMOVE_TAGS, 0);
        this.btnRemoveTag.setEnabled(false);
        this.btnRemoveTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerTags);
                if (o.isPresent()) {
                    SnippetMetadataPage.this.ppTags.remove(o.get());
                }
            }
        });
        this.btnRemoveTag.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblUuid = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.EDITOR_LABEL_SNIPPET_UUID, 0);
        lblUuid.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.txtUuid = managedForm.getToolkit().createText(managedForm.getForm().getBody(), null, 8);
        this.txtUuid.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(horizontalIndent, 0).create());
        this.initDataBindings();
    }

    private InputDialog createExtraSearchTermInputDialog(Shell shell) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (Strings.isNullOrEmpty((String)newText)) {
                    return "";
                }
                if (SnippetMetadataPage.this.snippet.getExtraSearchTerms().contains(newText)) {
                    return Messages.DIALOG_VALIDATOR_EXTRA_SEARCH_TERM_ALREADY_ADDED;
                }
                return null;
            }
        };
        return new InputDialog(shell, Messages.DIALOG_TITLE_ENTER_NEW_EXTRA_SEARCH_TERM, Messages.DIALOG_MESSAGE_ENTER_NEW_EXTRA_SEARCH_TERM, "", validator){

            protected void okPressed() {
                SnippetMetadataPage.this.ppExtraSearchTerms.add((Object)this.getValue());
                super.okPressed();
            }
        };
    }

    private InputDialog createTagInputDialog(Shell shell) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (Strings.isNullOrEmpty((String)newText)) {
                    return "";
                }
                if (SnippetMetadataPage.this.snippet.getTags().contains(newText)) {
                    return Messages.DIALOG_VALIDATOR_TAG_ALREADY_ADDED;
                }
                return null;
            }
        };
        return new InputDialog(shell, Messages.DIALOG_TITLE_ENTER_NEW_TAG, Messages.DIALOG_MESSAGE_ENTER_NEW_TAG, "", validator){

            protected void okPressed() {
                SnippetMetadataPage.this.ppTags.add((Object)this.getValue());
                super.okPressed();
            }
        };
    }

    protected void initDataBindings() {
        this.ctx = new DataBindingContext();
        ISWTObservableValue wpTxtNameText = WidgetProperties.text((int)24).observe((Widget)this.txtName);
        IObservableValue ppName = PojoProperties.value(Snippet.class, (String)"name", String.class).observe((Object)this.snippet);
        this.ctx.bindValue((IObservableValue)wpTxtNameText, ppName, null, null);
        wpTxtNameText.addChangeListener((IChangeListener)new ChangeListener());
        ISWTObservableValue wpTxtDescriptionText = WidgetProperties.text((int)24).observe((Widget)this.txtDescription);
        IObservableValue ppDescription = PojoProperties.value(Snippet.class, (String)"description", String.class).observe((Object)this.snippet);
        this.ctx.bindValue((IObservableValue)wpTxtDescriptionText, ppDescription, null, null);
        wpTxtDescriptionText.addChangeListener((IChangeListener)new ChangeListener());
        this.ppExtraSearchTerms = PojoProperties.list(Snippet.class, (String)"extraSearchTerms", String.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerExtraSearchTerms, (IObservableList)this.ppExtraSearchTerms, (IValueProperty)new SelfValueProperty(String.class));
        this.ppExtraSearchTerms.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                SnippetMetadataPage.this.setDirty();
            }
        });
        this.ppTags = PojoProperties.list(Snippet.class, (String)"tags", String.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerTags, (IObservableList)this.ppTags, (IValueProperty)new SelfValueProperty(String.class));
        this.ppTags.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                SnippetMetadataPage.this.setDirty();
            }
        });
        ISWTObservableValue wpUuidText = WidgetProperties.text((int)24).observe((Widget)this.txtUuid);
        IObservableValue ppUuid = PojoProperties.value(Snippet.class, (String)"uuid", UUID.class).observe((Object)this.snippet);
        this.ctx.bindValue((IObservableValue)wpUuidText, ppUuid, null, null);
        IViewerObservableValue vpExtraSearchTermsSelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerExtraSearchTerms);
        ISWTObservableValue wpBtnRemoveExtraSearchTermEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveExtraSearchTerm);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new ObjectToBooleanConverter());
        this.ctx.bindValue((IObservableValue)vpExtraSearchTermsSelection, (IObservableValue)wpBtnRemoveExtraSearchTermEnable, strategy, null);
        IViewerObservableValue vpTagSelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerTags);
        ISWTObservableValue wpBtnRemoveTagsEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveTag);
        this.ctx.bindValue((IObservableValue)vpTagSelection, (IObservableValue)wpBtnRemoveTagsEnable, strategy, null);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        super.init(site, input);
    }

    public void update() {
        this.ctx.dispose();
        this.initDataBindings();
    }

    public void dispose() {
        super.dispose();
        if (this.ctx != null) {
            this.ctx.dispose();
        }
    }

    private void setDirty() {
        ((SnippetEditor)this.getEditor()).setDirty(true);
    }

    private final class ChangeListener
    implements IChangeListener {
        private ChangeListener() {
        }

        public void handleChange(ChangeEvent event) {
            SnippetMetadataPage.this.setDirty();
        }
    }
}

