/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.annotationprocessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.annotationprocessor.AnnotatedOverriddenMethodsGuard;
import org.eclipse.riena.core.annotationprocessor.AnnotationProcessorFailure;
import org.eclipse.riena.core.annotationprocessor.DisposerList;
import org.eclipse.riena.core.annotationprocessor.IAnnotatedMethodHandler;
import org.eclipse.riena.core.annotationprocessor.IDisposer;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.WeakRef;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.annotationprocessor.IAnnotatedMethodHandlerExtension;

public final class AnnotationProcessor {
    private IAnnotatedMethodHandlerExtension[] extensions;
    private Map<Class<? extends Annotation>, IAnnotatedMethodHandler> handlerMap;
    private final Map<Object, ?> alreadyProcessed = new WeakHashMap();
    private static final IDisposer EMPTY_DISPOSER = new IDisposer(){

        @Override
        public void dispose() {
        }
    };
    private static final SingletonProvider<AnnotationProcessor> AP = new SingletonProvider<AnnotationProcessor>(AnnotationProcessor.class);
    private static final Logger LOGGER = Log4r.getLogger(AnnotationProcessor.class);

    public static AnnotationProcessor getInstance() {
        return AP.getInstance();
    }

    private AnnotationProcessor() {
    }

    @InjectExtension
    public synchronized void update(IAnnotatedMethodHandlerExtension[] extensions) {
        this.extensions = extensions;
        this.handlerMap = null;
    }

    public IDisposer processMethods(Object object) {
        return this.processMethods(object, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDisposer processMethods(Object object, Map<?, ?> optionalArgs) {
        Map<Object, ?> map = this.alreadyProcessed;
        synchronized (map) {
            if (this.alreadyProcessed.containsKey(object)) {
                return EMPTY_DISPOSER;
            }
            this.alreadyProcessed.put(object, null);
        }
        DisposerList disposers = new DisposerList();
        this.processMethods(object, object.getClass(), optionalArgs, new AnnotatedOverriddenMethodsGuard(), disposers);
        this.prepareDispose(object, disposers);
        return disposers;
    }

    private void processMethods(Object object, Class<?> objectClass, Map<?, ?> optionalArgs, AnnotatedOverriddenMethodsGuard guard, DisposerList disposers) {
        if (objectClass == Object.class) {
            return;
        }
        this.processMethods(object, objectClass.getSuperclass(), optionalArgs, guard, disposers);
        Method[] methodArray = objectClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotationArray = method.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                this.handle(annotation, object, method, optionalArgs, guard, disposers);
                ++n4;
            }
            ++n2;
        }
    }

    public void handle(Annotation annotation, Object object, Method method, Map<?, ?> optionalArgs, AnnotatedOverriddenMethodsGuard guard, DisposerList disposers) {
        IAnnotatedMethodHandler handler = this.getHandler(annotation.annotationType());
        if (handler != null && guard.add(annotation, method)) {
            handler.handleAnnotation(annotation, object, method, optionalArgs, guard, disposers);
        }
    }

    private synchronized IAnnotatedMethodHandler getHandler(Class<? extends Annotation> annotationType) {
        if (this.handlerMap == null) {
            this.handlerMap = new HashMap<Class<? extends Annotation>, IAnnotatedMethodHandler>();
            IAnnotatedMethodHandlerExtension[] iAnnotatedMethodHandlerExtensionArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotatedMethodHandlerExtension extension = iAnnotatedMethodHandlerExtensionArray[n2];
                IAnnotatedMethodHandler next = extension.createHandler();
                IAnnotatedMethodHandler previous = this.handlerMap.put(extension.getAnnotation(), next);
                if (previous != null) {
                    throw new AnnotationProcessorFailure("There are at least two handlers (" + previous.getClass() + ", " + next.getClass() + ") for the same annotation " + extension.getAnnotation().getName());
                }
                ++n2;
            }
        }
        return this.handlerMap.get(annotationType);
    }

    private void prepareDispose(Object object, final DisposerList disposers) {
        if (object == null || disposers == null || disposers.isEmpty()) {
            return;
        }
        new WeakRef<Object>(object, new Runnable(){

            @Override
            public void run() {
                try {
                    disposers.dispose();
                }
                catch (Throwable t) {
                    LOGGER.log(1, "Exception occured while executing a disposer.", t);
                }
            }
        });
    }
}

