/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ObjectCounter<T>
implements Iterable<T> {
    private final Map<T, Integer> objects = new HashMap<T, Integer>();

    public synchronized int incrementAndGetCount(T object) {
        Integer count = this.objects.get(object);
        count = count == null ? 1 : count + 1;
        this.objects.put(object, count);
        return count;
    }

    public synchronized int decrementAndGetCount(T object) {
        Integer count = this.objects.get(object);
        if (count == null) {
            return 0;
        }
        if (count == 1) {
            this.objects.remove(object);
            return 0;
        }
        count = count - 1;
        this.objects.put(object, count);
        return count;
    }

    public synchronized int getCount(T object) {
        Integer count = this.objects.get(object);
        return count == null ? 0 : count;
    }

    @Override
    public Iterator<T> iterator() {
        return this.objects.keySet().iterator();
    }
}

