/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.server;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.demo.common.Address;
import org.eclipse.riena.demo.common.Contract;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.demo.server.ICustomerRepository;

public class CustomerRepository
implements ICustomerRepository {
    private static final String[] STATES = new String[]{"NEW", "PENDING", "CLOSED", "CANCELED"};
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private final List<Customer> customers = new ArrayList<Customer>();
    private final Map<String, Customer> email2customer = new HashMap<String, Customer>();

    public CustomerRepository() {
        System.out.println("repository started");
        this.init();
    }

    @Override
    public List<Customer> search(String lastName) {
        if (StringUtils.isEmpty((CharSequence)lastName)) {
            return this.customers;
        }
        String pattern = lastName.toLowerCase();
        ArrayList<Customer> result = new ArrayList<Customer>();
        for (Customer customer : this.customers) {
            if (!customer.getLastName().toLowerCase().contains(pattern)) continue;
            result.add(customer);
        }
        return result;
    }

    @Override
    public void store(Customer customer) {
        this.customers.add(customer);
        if (customer.getEmailAddress() != null) {
            this.email2customer.put(customer.getEmailAddress(), customer);
        }
    }

    @Override
    public Customer findCustomerWithEmailAddress(String emailAddress) {
        return this.email2customer.get(emailAddress);
    }

    private void init() {
        try {
            Customer crv = new Customer();
            crv.setLastName("Mundl");
            crv.setFirstName("Josef");
            crv.setBirthDate(DATE_FORMAT.parse("01/01/1950"));
            crv.getAddress().setStreet("Musterstr.1");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Josef.Mundl@mail.org");
            this.addWorkAddress(crv);
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Muster");
            crv.setFirstName("Robert");
            crv.setBirthDate(DATE_FORMAT.parse("01/04/1955"));
            crv.getAddress().setStreet("Willibaldgasse");
            crv.getAddress().setZipCode("12366");
            crv.getAddress().setCity("Musterhaus");
            crv.setEmailAddress("Robert.Muster@mail.org");
            this.addWorkAddress(crv);
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Muster-Maier");
            crv.setFirstName("Trulli");
            crv.setBirthDate(DATE_FORMAT.parse("21/06/1964"));
            crv.getAddress().setStreet("Willibaldgasse");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Trulli.Muster-Maier@mail.org");
            this.addWorkAddress(crv);
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Mustermann");
            crv.setFirstName("Elfriede");
            crv.setBirthDate(DATE_FORMAT.parse("01/04/1955"));
            crv.getAddress().setStreet("Musterstr.1");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Elfriede.Mustermann@mail.org");
            this.addWorkAddress(crv);
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Mustermann");
            crv.setFirstName("Ingo");
            crv.setBirthDate(DATE_FORMAT.parse("01/01/1950"));
            crv.getAddress().setStreet("Musterstr.1");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Ingo.Mustermann@mail.org");
            this.addWorkAddress(crv);
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
        }
        catch (ParseException p) {
            System.out.println(p.getMessage());
        }
        for (Customer customer : this.customers) {
            this.addContractEntries(customer);
        }
    }

    public void addContractEntries(Customer customer) {
        int i = 0;
        while (i < 3) {
            String status = STATES[new Random().nextInt(STATES.length)];
            String contractNo = String.valueOf(Math.abs(new Random().nextInt(10000)));
            double nextDouble = new Random().nextDouble() * 1000000.0;
            double contractValue = (double)Math.round(nextDouble * 100.0) / 100.0;
            customer.addContract(new Contract(contractNo, "contract desc for " + contractNo, contractValue, status));
            ++i;
        }
    }

    public void addWorkAddress(Customer customer) {
        Address workAddress = new Address();
        workAddress.setCity("Frankfurt");
        workAddress.setStreet(customer.getAddress().getStreet());
        workAddress.setZipCode(customer.getAddress().getZipCode());
        customer.setWorkAddress(workAddress);
    }
}

