/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.ping.client.model;

import java.util.List;
import org.eclipse.riena.core.ping.PingResult;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;

public class PingResultTreeNode
extends TreeNode {
    private static final String PING_METHOD_PREFIX = "#";
    private static final String PINGABLE_OK_ICON = "testok.gif";
    private static final String PINGABLE_ERROR_ICON = "testerr.gif";
    private static final String PINGABLE_ICON = "test.gif";
    private PingResult pingResult;

    public PingResultTreeNode(ITreeNode parent, String name) {
        super(parent, (Object)PingResultTreeNode.stripOffPackage(name));
    }

    public boolean hasPingFailed() {
        return this.getPingResult() != null && this.getPingResult().hasPingFailed();
    }

    public boolean isPingDone() {
        return this.getPingResult() != null;
    }

    public void setPingResult(PingResult pingResult) {
        this.pingResult = pingResult;
    }

    public PingResult getPingResult() {
        return this.pingResult;
    }

    public String getIcon() {
        if (!this.isPingDone()) {
            return PINGABLE_ICON;
        }
        if (this.showFailureIcon()) {
            return PINGABLE_ERROR_ICON;
        }
        return PINGABLE_OK_ICON;
    }

    private boolean showFailureIcon() {
        if (this.hasPingFailed()) {
            return true;
        }
        List children = this.getChildren();
        if (children == null) {
            return false;
        }
        for (ITreeNode child : children) {
            if (!((PingResultTreeNode)child).showFailureIcon()) continue;
            return true;
        }
        return false;
    }

    public String getLabel() {
        return (String)this.getValue();
    }

    protected static String stripOffPackage(String name) {
        int dot = name.lastIndexOf(PING_METHOD_PREFIX);
        if (dot >= 0 && dot + PING_METHOD_PREFIX.length() <= name.length() + 1) {
            name = name.substring(dot + PING_METHOD_PREFIX.length());
            return name;
        }
        dot = name.lastIndexOf(46);
        if (dot < 0 || dot == name.length()) {
            return name;
        }
        name = name.substring(dot + 1);
        return name;
    }
}

