/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.splashHandlers;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.navigation.ui.swt.login.ILoginSplashView;
import org.eclipse.riena.navigation.ui.swt.login.ILoginSplashViewExtension;
import org.eclipse.riena.ui.swt.layout.DpiGridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.splash.AbstractSplashHandler;

public abstract class AbstractLoginSplashHandler
extends AbstractSplashHandler {
    protected ILoginSplashViewExtension loginSplashViewExtension;
    private Composite loginComposite;
    private ILoginSplashView loginView;

    public AbstractLoginSplashHandler() {
        this.initialzeLoginSplashViewDefinition();
    }

    public void init(Shell splash) {
        super.init(splash);
        if (this.loginSplashViewExtension != null) {
            this.configureUISplash();
            this.createUI();
            splash.layout(true);
            if (splash.isVisible()) {
                this.doEventLoop();
            }
        }
    }

    public int getResult() {
        return this.loginView.getResult();
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        while (!splash.isDisposed()) {
            if (splash.getDisplay().readAndDispatch()) continue;
            splash.getDisplay().sleep();
        }
        if (!IApplication.EXIT_OK.equals(this.loginView.getResult())) {
            PlatformUI.getWorkbench().getDisplay().close();
            System.exit(0);
        }
    }

    private void createUI() {
        this.loginComposite = this.createUILoginComposite();
        this.loginView = this.loginSplashViewExtension.createViewClass();
        this.loginView.build(this.loginComposite);
    }

    protected Composite createUILoginComposite() {
        Composite composite = new Composite((Composite)this.getSplash(), this.hasLoginCompositeBorder() ? 2048 : 0);
        DpiGridLayout layout = new DpiGridLayout(1, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setBackgroundMode(1);
        return composite;
    }

    protected boolean hasLoginCompositeBorder() {
        return false;
    }

    protected void configureUISplash() {
        DpiGridLayout layout = new DpiGridLayout(1, false);
        this.getSplash().setLayout((Layout)layout);
        this.getSplash().setBackgroundMode(1);
    }

    public void dispose() {
        if (!this.getSplash().isDisposed()) {
            this.getSplash().close();
        }
        super.init(null);
        this.loginComposite = null;
        this.loginView = null;
    }

    @InjectExtension
    public void update(ILoginSplashViewExtension[] data) {
        if (data.length > 0) {
            this.loginSplashViewExtension = data[0];
        }
    }

    private void initialzeLoginSplashViewDefinition() {
        Wire.instance((Object)((Object)this)).andStart(Activator.getDefault().getContext());
    }
}

