/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemRidget;
import org.eclipse.riena.internal.ui.swt.facades.WorkbenchFacade;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;

public class RienaMenuHelper {
    private static IBindingManager menuItemBindingManager;
    private static int itemId;
    private final List<Object> uiControls = new ArrayList<Object>();

    static {
        itemId = 0;
    }

    public RienaMenuHelper() {
        if (menuItemBindingManager == null) {
            menuItemBindingManager = this.createMenuItemBindingManager((IBindingPropertyLocator)SWTBindingPropertyLocator.getInstance(), (IControlRidgetMapper<Object>)SwtControlRidgetMapper.getInstance());
        }
    }

    private IBindingManager createMenuItemBindingManager(IBindingPropertyLocator propertyStrategy, IControlRidgetMapper<Object> mapper) {
        return new DefaultBindingManager(propertyStrategy, mapper);
    }

    public void bindMenuAndToolItems(IController controller, Composite menuParent, Composite toolbarParent) {
        this.createItemRidgets(controller, menuParent, toolbarParent);
        menuItemBindingManager.bind((IRidgetContainer)controller, this.getUIControls());
    }

    public void unbind(IController controller) {
        menuItemBindingManager.unbind((IRidgetContainer)controller, this.getUIControls());
    }

    private void createItemRidgets(IController controller, Composite menuParent, Composite toolbarParent) {
        ArrayList<IRidget> ridgetsToRemove = new ArrayList<IRidget>();
        Collection ridgets = controller.getRidgets();
        for (IRidget ridget : ridgets) {
            if (!(ridget instanceof AbstractItemRidget)) continue;
            ridgetsToRemove.add(ridget);
        }
        ridgets.removeAll(ridgetsToRemove);
        List<MenuCoolBarComposite> menuCoolBarComposites = this.getMenuCoolBarComposites(menuParent);
        for (MenuCoolBarComposite menuBarComp : menuCoolBarComposites) {
            this.createRidgetsForItems(menuBarComp.getTopLevelItems(), controller);
        }
        List<ToolItem> toolItems = this.getAllToolItems(toolbarParent);
        for (ToolItem toolItem : toolItems) {
            this.createRidget(controller, (Item)toolItem);
        }
    }

    public List<MenuCoolBarComposite> getMenuCoolBarComposites(Composite composite) {
        Control[] children;
        ArrayList<MenuCoolBarComposite> composites = new ArrayList<MenuCoolBarComposite>();
        if (SwtUtilities.isDisposed((Widget)composite)) {
            return composites;
        }
        if (composite instanceof MenuCoolBarComposite) {
            composites.add((MenuCoolBarComposite)composite);
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                composites.addAll(this.getMenuCoolBarComposites((Composite)child));
            }
            ++n2;
        }
        return composites;
    }

    private void createRidgetsForItems(List<ToolItem> toolItems, IController controller) {
        for (ToolItem toolItem : toolItems) {
            if (!SWTBindingPropertyLocator.getInstance().hasBindingProperty((Object)toolItem)) {
                this.createRidget(controller, (Item)toolItem);
            }
            if (!(toolItem.getData() instanceof MenuManager)) continue;
            MenuManager manager = (MenuManager)toolItem.getData();
            this.createRidget(controller, manager.getMenu());
        }
    }

    private void createRidget(IController controller, Item item) {
        if (item.isDisposed()) {
            return;
        }
        if (this.isSeparator(item)) {
            return;
        }
        String id = item instanceof MenuItem ? this.getItemId((MenuItem)item) : this.getItemId((ToolItem)item);
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        IRidget ridget = menuItemBindingManager.createRidget((Object)item);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)item, id);
        this.getUIControls().add(item);
        controller.addRidget(id, ridget);
        if (item instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)item;
            this.createRidget(controller, menuItem.getMenu());
        }
    }

    private void createRidget(IController controller, Menu menu) {
        MenuItem[] items;
        if (menu == null) {
            return;
        }
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            this.createRidget(controller, (Item)item);
            ++n2;
        }
    }

    private boolean isSeparator(Item item) {
        return (item.getStyle() & 2) == 2;
    }

    private List<ToolItem> getAllToolItems(Composite parentComposite) {
        ArrayList<ToolItem> items = new ArrayList<ToolItem>();
        List<CoolBar> coolBars = this.getCoolBars(parentComposite);
        for (CoolBar coolBar : coolBars) {
            List<ToolBar> toolBars = this.getToolBars((Composite)coolBar);
            for (ToolBar toolBar : toolBars) {
                items.addAll(Arrays.asList(toolBar.getItems()));
            }
        }
        List<ToolBar> toolBars = this.getToolBars(parentComposite);
        for (ToolBar toolBar : toolBars) {
            items.addAll(Arrays.asList(toolBar.getItems()));
        }
        return items;
    }

    private List<CoolBar> getCoolBars(Composite composite) {
        Control[] children;
        ArrayList<CoolBar> coolBars = new ArrayList<CoolBar>();
        if (composite == null) {
            return coolBars;
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CoolBar) {
                if (this.getParentOfType(child, MenuCoolBarComposite.class) == null) {
                    coolBars.add((CoolBar)child);
                }
            } else if (child instanceof Composite) {
                coolBars.addAll(this.getCoolBars((Composite)child));
            }
            ++n2;
        }
        return coolBars;
    }

    private List<ToolBar> getToolBars(Composite parentComposite) {
        Control[] children;
        ArrayList<ToolBar> toolBars = new ArrayList<ToolBar>();
        if (parentComposite == null) {
            return toolBars;
        }
        Control[] controlArray = children = parentComposite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ToolBar && this.getParentOfType(child, MenuCoolBarComposite.class) == null) {
                toolBars.add((ToolBar)child);
            }
            ++n2;
        }
        return toolBars;
    }

    private Composite getParentOfType(Control control, Class<? extends Control> clazz) {
        Composite parent = control.getParent();
        if (parent == null) {
            return null;
        }
        if (clazz.isAssignableFrom(parent.getClass())) {
            return parent;
        }
        return this.getParentOfType((Control)parent, clazz);
    }

    private String getItemId(Item item, String prefix) {
        String id = null;
        if (item.getData() instanceof IContributionItem) {
            IContributionItem contributionItem = (IContributionItem)item.getData();
            id = contributionItem.getId();
        }
        if (StringUtils.isEmpty(id)) {
            id = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)item);
        }
        if (StringUtils.isEmpty(id)) {
            id = Integer.toString(++itemId);
        } else if (!id.startsWith(prefix)) {
            id = String.valueOf(prefix) + id;
        }
        return id;
    }

    private String getItemId(MenuItem item) {
        return this.getItemId((Item)item, "menuAction.");
    }

    private String getItemId(ToolItem item) {
        return this.getItemId((Item)item, "toolbarAction.");
    }

    private List<Object> getUIControls() {
        return this.uiControls;
    }

    public void addSourceProviderListener(ISourceProviderListener listener) {
        ISourceProvider[] sourceProviders;
        ISourceProvider[] iSourceProviderArray = sourceProviders = this.getSourceProviders();
        int n = sourceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider sourceProvider = iSourceProviderArray[n2];
            sourceProvider.addSourceProviderListener(listener);
            ++n2;
        }
    }

    public void removeSourceProviderListener(ISourceProviderListener listener) {
        ISourceProvider[] sourceProviders;
        ISourceProvider[] iSourceProviderArray = sourceProviders = this.getSourceProviders();
        int n = sourceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider sourceProvider = iSourceProviderArray[n2];
            sourceProvider.removeSourceProviderListener(listener);
            ++n2;
        }
    }

    public ISourceProvider[] getSourceProviders() {
        return WorkbenchFacade.getInstance().getSourceProviders();
    }
}

