/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;

final class ApplicationNodeManagerInternal {
    private Map<String, IApplicationNode> nodeMap = new HashMap<String, IApplicationNode>();
    private INavigationProcessor defaultNavigationProcessor;
    private static final String DEFAULT_NODE_NAME = "default";

    ApplicationNodeManagerInternal() {
    }

    public IApplicationNode getApplicationNode() {
        IApplicationNode model = this.getApplicationNode(DEFAULT_NODE_NAME);
        if (model == null && this.nodeMap.size() == 1) {
            return this.nodeMap.values().iterator().next();
        }
        return model;
    }

    public IApplicationNode getApplicationNode(String name) {
        String modelName = name;
        if (modelName == null) {
            modelName = DEFAULT_NODE_NAME;
        }
        return this.nodeMap.get(modelName);
    }

    public synchronized void clear() {
        this.nodeMap = new HashMap<String, IApplicationNode>();
    }

    public synchronized void registerApplicationNode(IApplicationNode node) {
        String nodeName = node.getLabel();
        if (nodeName == null) {
            nodeName = DEFAULT_NODE_NAME;
        }
        if (this.nodeMap.containsKey(nodeName)) {
            throw new ApplicationModelFailure("ApplicationNode '" + nodeName + "' already registered");
        }
        this.nodeMap.put(nodeName, node);
    }

    public INavigationProcessor getDefaultNavigationProcessor() {
        if (this.defaultNavigationProcessor == null) {
            this.defaultNavigationProcessor = new NavigationProcessor();
        }
        return this.defaultNavigationProcessor;
    }

    public ISubApplicationNode locateActiveSubApplicationNode() {
        IApplicationNode applicationNode = this.getApplicationNode();
        if (applicationNode == null) {
            return null;
        }
        for (ISubApplicationNode child : applicationNode.getChildren()) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public IModuleGroupNode locateActiveModuleGroupNode() {
        ISubApplicationNode subApplicationNode = this.locateActiveSubApplicationNode();
        if (subApplicationNode == null) {
            return null;
        }
        for (IModuleGroupNode child : subApplicationNode.getChildren()) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public IModuleNode locateActiveModuleNode() {
        IModuleGroupNode moduleGroupNode = this.locateActiveModuleGroupNode();
        if (moduleGroupNode == null) {
            return null;
        }
        for (IModuleNode child : moduleGroupNode.getChildren()) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public ISubModuleNode locateActiveSubModuleNode() {
        IModuleNode moduleNode = this.locateActiveModuleNode();
        if (moduleNode == null) {
            return null;
        }
        return ApplicationNodeManager.getActiveSubModule(moduleNode);
    }
}

