/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.ui.ridgets.ILinkRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class SnippetLinkRidget002 {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = UIControlsFactory.createShell((Display)display);
            shell.setText(SnippetLinkRidget002.class.getSimpleName());
            GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 10).equalWidth(false).spacing(20, 10).applyTo((Composite)shell);
            Link link1 = UIControlsFactory.createLink((Composite)shell);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)link1);
            final Browser browser = new Browser((Composite)shell, 2048);
            browser.setUrl("about:blank");
            GridDataFactory.fillDefaults().grab(true, false).grab(true, true).applyTo((Control)browser);
            final ILinkRidget linkRidget1 = (ILinkRidget)SwtRidgetFactory.createRidget((Object)link1);
            final ClickCounter model = new ClickCounter();
            model.setText("Click to visit Riena");
            model.setLink("http://www.eclipse.org/riena/");
            linkRidget1.bindToModel((Object)model, "linkAndText");
            linkRidget1.updateFromModel();
            linkRidget1.addSelectionListener(new ISelectionListener(){

                public void ridgetSelected(SelectionEvent event) {
                    String url = (String)event.getNewSelection().get(0);
                    System.out.println("Visiting: " + url);
                    browser.setUrl(url);
                    model.increaseCount();
                    linkRidget1.updateFromModel();
                }
            });
            shell.setSize(700, 700);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private static final class ClickCounter {
        private int count = 0;
        private String link;
        private String text;

        private ClickCounter() {
        }

        public void increaseCount() {
            ++this.count;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getLinkAndText() {
            return String.format("<a href=\"%s\">%s</a> - %d clicks counted", this.link, this.text, this.count);
        }
    }
}

