/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.SuperHero;
import org.eclipse.riena.beans.common.SuperHeroFactory;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.core.marker.RowErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SnippetTableRidget007 {
    public SnippetTableRidget007(Shell shell) {
        Composite compTable = UIControlsFactory.createComposite((Composite)shell);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)compTable);
        final Table table = UIControlsFactory.createTable((Composite)compTable, (int)65540);
        Composite compButton = UIControlsFactory.createComposite((Composite)shell);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)compButton);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(compButton);
        Button btnMark = UIControlsFactory.createButton((Composite)compButton, (String)"&Mark");
        GridDataFactory.fillDefaults().align(131072, 4).grab(true, false).applyTo((Control)btnMark);
        Button btnUnmark = UIControlsFactory.createButton((Composite)compButton, (String)"&Unmark");
        Button btnLines = UIControlsFactory.createButton((Composite)compButton, (String)"Toggle &Lines");
        final ITableRidget tableRidget = (ITableRidget)SwtRidgetFactory.createRidget((Object)table);
        String[] columnPropertyNames = new String[]{"pseudonym", "name", "appearance"};
        String[] columnHeaders = new String[]{"Pseudonym", "Name", "First appearance"};
        WritableList input = new WritableList(SuperHeroFactory.createInput(), SuperHero.class);
        tableRidget.bindToModel((IObservableList)input, SuperHero.class, columnPropertyNames, columnHeaders);
        tableRidget.updateFromModel();
        tableRidget.setToolTipText("The ORIGINAL table tooltip!");
        IActionRidget ridgetMark = (IActionRidget)SwtRidgetFactory.createRidget((Object)btnMark);
        ridgetMark.addListener(new IActionListener(){

            public void callback() {
                List selection = tableRidget.getSelection();
                if (!selection.isEmpty()) {
                    Object value = selection.get(0);
                    System.out.println("mark: " + value);
                    RowErrorMessageMarker marker = new RowErrorMessageMarker("There is an error with: " + value, value);
                    tableRidget.addMarker((IMarker)marker);
                }
            }
        });
        IActionRidget ridgetUnmark = (IActionRidget)SwtRidgetFactory.createRidget((Object)btnUnmark);
        ridgetUnmark.addListener(new IActionListener(){

            public void callback() {
                List selection = tableRidget.getSelection();
                if (!selection.isEmpty()) {
                    Object value = selection.get(0);
                    System.out.println("unmark: " + value);
                    RowErrorMessageMarker marker = new RowErrorMessageMarker(null, value);
                    tableRidget.removeMarker((IMarker)marker);
                }
            }
        });
        IActionRidget ridgetLines = (IActionRidget)SwtRidgetFactory.createRidget((Object)btnLines);
        ridgetLines.addListener(new IActionListener(){

            public void callback() {
                table.setLinesVisible(!table.getLinesVisible());
            }
        });
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = UIControlsFactory.createShell((Display)display);
            shell.setText(SnippetTableRidget007.class.getSimpleName());
            GridLayoutFactory.fillDefaults().applyTo((Composite)shell);
            new SnippetTableRidget007(shell);
            shell.setSize(400, 250);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }
}

