/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.extension.IInitializerDesc;
import org.eclipse.riena.core.injector.extension.IModifierDesc;
import org.eclipse.riena.core.injector.extension.IPreferencesDesc;
import org.eclipse.riena.core.injector.extension.IScopeDesc;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;

@NonUITestCase
public class HeterogeneousInjectingTest
extends RienaTestCase {
    private IPreferencesDesc[] prefs;
    private static final String PREFERENCES = "org.eclipse.core.runtime.preferences";

    public void update(IPreferencesDesc[] prefs) {
        this.prefs = prefs;
    }

    public void testPreferencesInjectionHeterogeneousSpecific() {
        this.printTestName();
        Inject.extension((String)PREFERENCES).heterogeneous().into((Object)this).specific().andStart(this.getContext());
        HeterogeneousInjectingTest.assertNotNull((Object)this.prefs);
        HeterogeneousInjectingTest.assertTrue((this.prefs.length > 1 ? 1 : 0) != 0);
        int scops = 0;
        int inits = 0;
        int modis = 0;
        IPreferencesDesc[] iPreferencesDescArray = this.prefs;
        int n = this.prefs.length;
        int n2 = 0;
        while (n2 < n) {
            IModifierDesc[] modifiers;
            IInitializerDesc[] initializers;
            IScopeDesc[] scopes;
            IPreferencesDesc pref = iPreferencesDescArray[n2];
            this.println(pref.toString());
            IScopeDesc[] iScopeDescArray = scopes = pref.getScope();
            int n3 = scopes.length;
            int n4 = 0;
            while (n4 < n3) {
                IScopeDesc scope = iScopeDescArray[n4];
                this.println("\tScope: " + scope.getName() + ", " + scope.getScope() + ", " + scope.getContributingBundle());
                ++n4;
            }
            scops += scopes.length;
            IInitializerDesc[] iInitializerDescArray = initializers = pref.getInitializer();
            int n5 = initializers.length;
            n3 = 0;
            while (n3 < n5) {
                IInitializerDesc initializer = iInitializerDescArray[n3];
                this.println("\tInit: " + initializer.getInitializer() + ", " + initializer.getContributingBundle());
                ++n3;
            }
            inits += initializers.length;
            IModifierDesc[] iModifierDescArray = modifiers = pref.getModifier();
            int n6 = modifiers.length;
            n5 = 0;
            while (n5 < n6) {
                IModifierDesc modifier = iModifierDescArray[n5];
                this.println("\tModifier: " + modifier.getModifier() + ", " + modifier.getContributingBundle());
                ++n5;
            }
            modis += modifiers.length;
            ++n2;
        }
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(PREFERENCES);
        HeterogeneousInjectingTest.assertEquals((int)extensionPoint.getExtensions().length, (int)this.prefs.length);
        HeterogeneousInjectingTest.assertEquals((int)extensionPoint.getConfigurationElements().length, (int)(scops + inits + modis));
    }

    public void testPreferencesInjectionHeterogeneousUnspecific() {
        IModifierDesc[] modifiers;
        IInitializerDesc[] initializers;
        IScopeDesc[] scopes;
        this.printTestName();
        Inject.extension((String)PREFERENCES).heterogeneous().into((Object)this).andStart(this.getContext());
        HeterogeneousInjectingTest.assertNotNull((Object)this.prefs);
        HeterogeneousInjectingTest.assertEquals((int)1, (int)this.prefs.length);
        IPreferencesDesc pref = this.prefs[0];
        IScopeDesc[] iScopeDescArray = scopes = pref.getScope();
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            IScopeDesc scope = iScopeDescArray[n2];
            this.println("\tScope: " + scope.getName() + ", " + scope.getScope() + ", " + scope.getContributingBundle());
            ++n2;
        }
        IInitializerDesc[] iInitializerDescArray = initializers = pref.getInitializer();
        int n3 = initializers.length;
        n = 0;
        while (n < n3) {
            IInitializerDesc initializer = iInitializerDescArray[n];
            this.println("\tInit: " + initializer.getInitializer() + ", " + initializer.getContributingBundle());
            ++n;
        }
        IModifierDesc[] iModifierDescArray = modifiers = pref.getModifier();
        int n4 = modifiers.length;
        n3 = 0;
        while (n3 < n4) {
            IModifierDesc modifier = iModifierDescArray[n3];
            this.println("\tModifier: " + modifier.getModifier() + ", " + modifier.getContributingBundle());
            ++n3;
        }
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(PREFERENCES);
        HeterogeneousInjectingTest.assertEquals((int)extensionPoint.getConfigurationElements().length, (int)(scopes.length + initializers.length + modifiers.length));
    }
}

