/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.List;
import org.eclipse.riena.beans.common.StringManager;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractComboRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.CompletionComboRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractComboRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class CompletionComboRidgetTest
extends AbstractComboRidgetTest {
    protected Control createWidget(Composite parent) {
        return UIControlsFactory.createCompletionCombo((Composite)parent);
    }

    @Override
    protected Control createWidget(Composite parent, int style) {
        return UIControlsFactory.createCompletionCombo((Composite)parent, (int)style);
    }

    @Override
    protected IRidget createRidget() {
        return new CompletionComboRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        CompletionComboRidgetTest.assertTrue((boolean)(this.getWidget() instanceof CompletionCombo));
        CompletionComboRidgetTest.assertSame(CompletionComboRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testMandatoryChangesTextBackgroundOnly() {
        AbstractComboRidget ridget = this.getRidget();
        CompletionCombo control = (CompletionCombo)this.getWidget();
        Color bg = control.getBackground();
        Color mandatory = new Color(null, 255, 255, 175);
        try {
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getBackground());
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getTextBackground());
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getListBackground());
            ridget.setMandatory(true);
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getBackground());
            CompletionComboRidgetTest.assertEquals((Object)mandatory, (Object)control.getTextBackground());
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getListBackground());
            ridget.setMandatory(false);
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getBackground());
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getTextBackground());
            CompletionComboRidgetTest.assertEquals((Object)bg, (Object)control.getListBackground());
        }
        finally {
            mandatory.dispose();
        }
    }

    public void testSelectionEventOnKeyboardEntryWithACMNoMismatch() {
        AbstractComboRidget ridget = this.getRidget();
        CompletionCombo control = (CompletionCombo)this.getWidget();
        control.setAutoCompletionMode(CompletionCombo.AutoCompletionMode.NO_MISSMATCH);
        StringManager aManager = new StringManager(new String[]{"A1", "A2", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        FTSelectionListener listener = new FTSelectionListener();
        control.addSelectionListener((SelectionListener)listener);
        ridget.addSelectionListener((ISelectionListener)listener);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"A");
        listener.assertSelection(1, "", "A1");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"2");
        listener.assertSelection(2, "A1", "A2");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"x");
        listener.assertSelection(2, "A1", "A2");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        listener.assertSelection(3, "A2", "A1");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        listener.assertSelection(4, "A1", "");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        listener.assertSelection(4, "A1", "");
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        listener.assertSelection(5, "", "A1");
    }

    public void testSelectionEventOnKeyboardEntryWithACMAllowMismatch() {
        AbstractComboRidget ridget = this.getRidget();
        CompletionCombo control = (CompletionCombo)this.getWidget();
        control.setAutoCompletionMode(CompletionCombo.AutoCompletionMode.ALLOW_MISSMATCH);
        StringManager aManager = new StringManager(new String[]{"A1", "A2", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        FTSelectionListener listener = new FTSelectionListener();
        control.addSelectionListener((SelectionListener)listener);
        ridget.addSelectionListener((ISelectionListener)listener);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"A");
        listener.assertSelection(1, "", "A1");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"2");
        listener.assertSelection(2, "A1", "A2");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"b");
        listener.assertSelection(3, "A2", "");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"c");
        listener.assertSelection(3, "A2", "");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b\b");
        listener.assertSelection(4, "", "A2");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        listener.assertSelection(5, "A2", "A1");
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        listener.assertSelection(6, "A1", "A2");
    }

    public void testSelectionEventOnKeyboardEntryWithACMFirstLetterMatch() {
        AbstractComboRidget ridget = this.getRidget();
        CompletionCombo control = (CompletionCombo)this.getWidget();
        control.setAutoCompletionMode(CompletionCombo.AutoCompletionMode.FIRST_LETTER_MATCH);
        StringManager aManager = new StringManager(new String[]{"A1", "A2", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        FTSelectionListener listener = new FTSelectionListener();
        control.addSelectionListener((SelectionListener)listener);
        ridget.addSelectionListener((ISelectionListener)listener);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"a");
        listener.assertSelection(1, "", "A1");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"a");
        listener.assertSelection(2, "A1", "A2");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"b");
        listener.assertSelection(3, "A2", "B");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"Q");
        listener.assertSelection(3, "A2", "B");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        listener.assertSelection(3, "A2", "B");
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        listener.assertSelection(3, "A2", "B");
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        listener.assertSelection(4, "B", "C");
    }

    public void testSelectionEventOnCut() {
        AbstractComboRidget ridget = this.getRidget();
        CompletionCombo control = (CompletionCombo)this.getWidget();
        Text textControl = (Text)ReflectionUtils.invokeHidden((Object)control, (String)"getTextControl", null);
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        control.setAutoCompletionMode(CompletionCombo.AutoCompletionMode.ALLOW_MISSMATCH);
        control.setText("Alpha");
        FTSelectionListener listener = new FTSelectionListener();
        control.addSelectionListener((SelectionListener)listener);
        ridget.addSelectionListener((ISelectionListener)listener);
        control.setSelection(new Point(1, 5));
        ReflectionUtils.invokeHidden((Object)control, (String)"handleCut", null);
        listener.assertSelection(1, "", "A");
        textControl.selectAll();
        ReflectionUtils.invokeHidden((Object)control, (String)"handleCut", null);
        listener.assertSelection(2, "A", "");
    }

    public void testSelectionEventOnPaste() {
        AbstractComboRidget ridget = this.getRidget();
        CompletionCombo control = (CompletionCombo)this.getWidget();
        Text textControl = (Text)ReflectionUtils.invokeHidden((Object)control, (String)"getTextControl", null);
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        FTSelectionListener listener = new FTSelectionListener();
        control.addSelectionListener((SelectionListener)listener);
        ridget.addSelectionListener((ISelectionListener)listener);
        Clipboard clip = new Clipboard(control.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        clip.setContents(new Object[]{"A"}, new Transfer[]{textTransfer});
        textControl.selectAll();
        ReflectionUtils.invokeHidden((Object)control, (String)"handlePaste", null);
        listener.assertSelection(1, "", "A");
        clip.setContents(new Object[]{"Not_in_list"}, new Transfer[]{textTransfer});
        textControl.selectAll();
        ReflectionUtils.invokeHidden((Object)control, (String)"handlePaste", null);
        listener.assertSelection(1, "", "A");
    }

    private static final class FTSelectionListener
    extends SelectionAdapter
    implements ISelectionListener {
        private int widgetEventCount;
        private int ridgetEventCount;
        private SelectionEvent ridgetEvent;

        private FTSelectionListener() {
        }

        public void widgetSelected(org.eclipse.swt.events.SelectionEvent event) {
            ++this.widgetEventCount;
        }

        public void ridgetSelected(SelectionEvent event) {
            this.ridgetEvent = event;
            ++this.ridgetEventCount;
        }

        void assertSelection(int expectedCount, String oldSelection, String newSelection) {
            CompletionComboRidgetTest.assertEquals((String)"widget event count mismatch", (int)expectedCount, (int)this.widgetEventCount);
            CompletionComboRidgetTest.assertEquals((String)"ridget event count mismatch", (int)expectedCount, (int)this.ridgetEventCount);
            CompletionComboRidgetTest.assertEquals((String)"old selection value mismatch", (String)oldSelection, (String)this.getOldSelection());
            CompletionComboRidgetTest.assertEquals((String)"new selection value mismatch", (String)newSelection, (String)this.getNewSelection());
        }

        private String getOldSelection() {
            List list = this.ridgetEvent.getOldSelection();
            return list.size() > 0 ? list.get(0).toString() : "";
        }

        private String getNewSelection() {
            List list = this.ridgetEvent.getNewSelection();
            return list.size() > 0 ? list.get(0).toString() : "";
        }
    }
}

