/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.FTActionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeUtils;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeRidgetTest
extends AbstractSWTRidgetTest {
    private static final String ROOT_NODE_USER_OBJECT = "TestRootNode";
    private static final String ROOT_CHILD1_NODE_USER_OBJECT = "TestRootChild1Node";
    private static final String ROOT_CHILD2_NODE_USER_OBJECT = "TestRootChild2Node";
    private static final String ROOT_CHILD1_CHILD1_NODE_USER_OBJECT = "TestRootChild1Child1Node";
    private static final String ROOT_CHILD1_CHILD2_NODE_USER_OBJECT = "TestRootChild1Child2Node";
    private static final String ROOT_CHILD1_CHILD2_CHILD_NODE_USER_OBJECT = "TestRootChild1Child2ChildNode";
    private ITreeNode rootNode;
    private ITreeNode rootChild1Node;
    private ITreeNode rootChild2Node;
    private ITreeNode rootChild1Child2Node;
    private ITreeNode rootChild1Child1Node;
    private ITreeNode rootChild1Child2ChildNode;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getRidget().bindToModel((Object[])this.initializeTreeModel(), ITreeNode.class, "children", "parent", "value");
    }

    protected Control createWidget(Composite parent) {
        return new Tree(parent, 2);
    }

    @Override
    protected IRidget createRidget() {
        return new TreeRidget();
    }

    protected Tree getWidget() {
        return (Tree)super.getWidget();
    }

    protected ITreeRidget getRidget() {
        return (ITreeRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        TreeRidgetTest.assertSame(TreeRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testGetUIControl() throws Exception {
        Tree control = this.getWidget();
        TreeRidgetTest.assertEquals((Object)control, (Object)this.getRidget().getUIControl());
    }

    public void testBindToModel() {
        TreeRidgetTest.assertEquals((String)ROOT_NODE_USER_OBJECT, (String)this.getUIControlItem(0).getText(0));
        TreeRidgetTest.assertEquals((String)ROOT_CHILD1_NODE_USER_OBJECT, (String)this.getUIControlItem(1).getText(0));
        TreeRidgetTest.assertEquals((String)ROOT_CHILD1_CHILD1_NODE_USER_OBJECT, (String)this.getUIControlItem(2).getText(0));
        TreeRidgetTest.assertEquals((String)ROOT_CHILD2_NODE_USER_OBJECT, (String)this.getUIControlItem(3).getText(0));
    }

    public void testBindToModelNull() {
        ITreeRidget ridget = this.getRidget();
        Object[] roots = new ITreeNode[]{this.rootNode};
        try {
            ridget.bindToModel(null, ITreeNode.class, "children", "parent", "value");
            TreeRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(roots, null, "children", "parent", "value");
            TreeRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(roots, ITreeNode.class, null, "parent", "value");
            TreeRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(roots, ITreeNode.class, "children", null, "value");
            TreeRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(roots, ITreeNode.class, "children", "parent", null);
            TreeRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testUpdateTreeFromModel() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.expandAll();
        TreeRidgetTest.assertEquals((int)1, (int)control.getItemCount());
        TreeItem treeRoot = control.getItems()[0];
        TreeRidgetTest.assertEquals((String)ROOT_NODE_USER_OBJECT, (String)treeRoot.getText());
        TreeRidgetTest.assertEquals((int)2, (int)treeRoot.getItemCount());
        TreeItem treeRootChild1 = treeRoot.getItem(0);
        TreeRidgetTest.assertEquals((String)ROOT_CHILD1_NODE_USER_OBJECT, (String)treeRootChild1.getText());
        TreeItem treeRootChild2 = treeRoot.getItem(1);
        TreeRidgetTest.assertEquals((String)ROOT_CHILD2_NODE_USER_OBJECT, (String)treeRootChild2.getText());
        TreeRidgetTest.assertEquals((int)2, (int)treeRootChild1.getItemCount());
        TreeRidgetTest.assertEquals((int)0, (int)treeRootChild2.getItemCount());
        TreeItem treeRootChild1Child1 = treeRootChild1.getItem(0);
        TreeRidgetTest.assertEquals((String)ROOT_CHILD1_CHILD1_NODE_USER_OBJECT, (String)treeRootChild1Child1.getText());
        TreeItem treeRootChild1Child2 = treeRootChild1.getItem(1);
        TreeRidgetTest.assertEquals((String)ROOT_CHILD1_CHILD2_NODE_USER_OBJECT, (String)treeRootChild1Child2.getText());
        TreeRidgetTest.assertEquals((int)0, (int)treeRootChild1Child1.getItemCount());
        TreeRidgetTest.assertEquals((int)1, (int)treeRootChild1Child2.getItemCount());
        TreeItem treeRootChild1Child2Child = treeRootChild1Child2.getItem(0);
        TreeRidgetTest.assertEquals((String)ROOT_CHILD1_CHILD2_CHILD_NODE_USER_OBJECT, (String)treeRootChild1Child2Child.getText());
        TreeRidgetTest.assertEquals((int)0, (int)treeRootChild1Child2Child.getItemCount());
    }

    public void testUpdateOnModelChanges() {
        Tree control = this.getWidget();
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        this.removeFromParent(this.rootChild2Node);
        TreeRidgetTest.assertEquals((int)2, (int)TreeUtils.getItemCount(control));
        new TreeNode(this.rootNode, (Object)"TestNewNode1");
        new TreeNode(this.rootNode, (Object)"TestNewNode2");
        TreeRidgetTest.assertEquals((int)4, (int)TreeUtils.getItemCount(control));
    }

    public void testExpandAndCollapseTree() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.expandAll();
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
        ridget.collapseAll();
        TreeRidgetTest.assertEquals((int)1, (int)TreeUtils.getItemCount(control));
        ridget.expand((Object)this.rootNode);
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.expandAll();
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
        this.getRidget().bindToModel((Object[])this.initializeTreeModel(), ITreeNode.class, "children", "parent", "value");
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.expandAll();
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
        ridget.updateFromModel();
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
    }

    public void testExpandAndCollapseTreeWhenUnbound() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.expandAll();
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.collapseAll();
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)1, (int)TreeUtils.getItemCount(control));
    }

    public void testExpandAndCollapseSingleNodes() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.expandAll();
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
        ridget.collapse((Object)this.rootChild1Child2Node);
        TreeRidgetTest.assertEquals((int)5, (int)TreeUtils.getItemCount(control));
        ridget.collapse((Object)this.rootChild1Node);
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.expand((Object)this.rootChild1Node);
        TreeRidgetTest.assertEquals((int)5, (int)TreeUtils.getItemCount(control));
        ridget.expand((Object)this.rootChild1Child2Node);
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
    }

    public void testExpandAndCollapseSingleNodesWhenUnbound() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.expand((Object)this.rootChild1Node);
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)5, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.collapse((Object)this.rootNode);
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)1, (int)TreeUtils.getItemCount(control));
    }

    public void testFullExpansionStatusIsPreserved() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.expandAll();
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)6, (int)TreeUtils.getItemCount(control));
        ridget.collapseAll();
        TreeRidgetTest.assertEquals((int)1, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)1, (int)TreeUtils.getItemCount(control));
    }

    public void testPartialExpansionStatusIsPreserved() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeRidgetTest.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.expand((Object)this.rootChild1Node);
        TreeRidgetTest.assertEquals((int)5, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)5, (int)TreeUtils.getItemCount(control));
        ridget.collapse((Object)this.rootNode);
        TreeRidgetTest.assertEquals((int)1, (int)TreeUtils.getItemCount(control));
        ridget.setUIControl(null);
        ridget.setUIControl((Object)control);
        TreeRidgetTest.assertEquals((int)1, (int)TreeUtils.getItemCount(control));
    }

    public void testAddDoubleClickListener() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        try {
            ridget.addDoubleClickListener(null);
            TreeRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTActionListener listener1 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener1);
        FTActionListener listener2 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener2);
        ridget.addDoubleClickListener((IActionListener)listener2);
        Event doubleClick = new Event();
        doubleClick.widget = control;
        doubleClick.type = 8;
        control.notifyListeners(8, doubleClick);
        TreeRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        TreeRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeDoubleClickListener((IActionListener)listener1);
        control.notifyListeners(8, doubleClick);
        TreeRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testAddSelectionListener() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        try {
            ridget.addSelectionListener(null);
            TreeRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        TreeRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        TreeRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        SelectionEvent selectionEvent = selectionListener.getSelectionEvent();
        TreeRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        TreeRidgetTest.assertTrue((boolean)selectionEvent.getOldSelection().isEmpty());
        TreeRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent.getNewSelection());
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        TreeRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        SelectionEvent selectionEvent2 = selectionListener.getSelectionEvent();
        TreeRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        TreeRidgetTest.assertEquals((Object)selectionEvent.getNewSelection(), (Object)selectionEvent2.getOldSelection());
        TreeRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent2.getNewSelection());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
    }

    public void testBug266042() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeNode root1 = new TreeNode((Object)"r1");
        new TreeNode((ITreeNode)root1, (Object)"r1.a");
        new TreeNode((ITreeNode)root1, (Object)"r1.b");
        TreeNode root2 = new TreeNode((Object)"r2");
        new TreeNode((ITreeNode)root2, (Object)"r2.a");
        new TreeNode((ITreeNode)root2, (Object)"r2.b");
        ridget.bindToModel(new Object[]{root1, root2}, TreeNode.class, "children", "parent", "value");
        TreeRidgetTest.assertEquals((int)2, (int)TreeUtils.getItemCount(control));
        TreeRidgetTest.assertEquals((String)"r1", (String)control.getItem(0).getText());
        TreeRidgetTest.assertEquals((String)"r2", (String)control.getItem(1).getText());
    }

    public void testBug290365() {
        ITreeRidget ridget = this.getRidget();
        TreeNodeWithIcon root1 = new TreeNodeWithIcon(null, "r1");
        new TreeNodeWithIcon((ITreeNode)root1, "r1.a");
        new TreeNodeWithIcon((ITreeNode)root1, "r1.b");
        ridget.bindToModel(new Object[]{root1}, TreeNodeWithIcon.class, "children", "parent", "value", null, null, "icon");
        ridget.updateFromModel();
        this.ok();
    }

    public void testSetRootsVisibleFiresEvents() {
        ITreeRidget ridget = this.getRidget();
        TreeRidgetTest.assertTrue((boolean)ridget.getRootsVisible());
        this.expectPropertyChangeEvent("rootsVisible", true, false);
        ridget.setRootsVisible(false);
        this.verifyPropertyChangeEvents();
        TreeRidgetTest.assertFalse((boolean)ridget.getRootsVisible());
        this.expectPropertyChangeEvent("rootsVisible", false, true);
        ridget.setRootsVisible(true);
        this.verifyPropertyChangeEvents();
        TreeRidgetTest.assertTrue((boolean)ridget.getRootsVisible());
        this.expectNoPropertyChangeEvent();
        ridget.setRootsVisible(true);
        this.verifyPropertyChangeEvents();
    }

    public void testRefreshNull() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeNode root = new TreeNode(null){
            private Object myvalue;

            public void setValue(Object value) {
                this.myvalue = value;
            }

            public Object getValue() {
                return this.myvalue;
            }
        };
        root.setValue((Object)"hello world");
        ridget.bindToModel(new Object[]{root}, TreeNode.class, "children", "parent", "value");
        ridget.updateFromModel();
        TreeItem treeRoot = control.getItems()[0];
        TreeRidgetTest.assertEquals((String)"hello world", (String)treeRoot.getText());
        root.setValue((Object)"changed");
        TreeRidgetTest.assertEquals((String)"hello world", (String)treeRoot.getText());
        ridget.refresh(null);
        TreeRidgetTest.assertEquals((String)"changed", (String)treeRoot.getText());
    }

    public void testRefresh() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeNode root = new TreeNode(null){
            private Object myvalue;

            public void setValue(Object value) {
                this.myvalue = value;
            }

            public Object getValue() {
                return this.myvalue;
            }
        };
        root.setValue((Object)"hello world");
        ridget.bindToModel(new Object[]{root}, TreeNode.class, "children", "parent", "value");
        ridget.updateFromModel();
        TreeItem treeRoot = control.getItems()[0];
        TreeRidgetTest.assertEquals((String)"hello world", (String)treeRoot.getText());
        root.setValue((Object)"changed");
        TreeRidgetTest.assertEquals((String)"hello world", (String)treeRoot.getText());
        ridget.refresh((Object)root);
        TreeRidgetTest.assertEquals((String)"changed", (String)treeRoot.getText());
    }

    public void testCollectChildren() {
        this.initializeTreeModel();
        ArrayList result = new ArrayList();
        ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"collectChildren", (Object[])new Object[]{this.rootNode, result});
        TreeRidgetTest.assertEquals((int)5, (int)result.size());
        TreeRidgetTest.assertSame((Object)this.rootChild1Child1Node, result.get(0));
        TreeRidgetTest.assertSame((Object)this.rootChild1Child2ChildNode, result.get(1));
        TreeRidgetTest.assertSame((Object)this.rootChild1Child2Node, result.get(2));
        TreeRidgetTest.assertSame((Object)this.rootChild1Node, result.get(3));
        TreeRidgetTest.assertSame((Object)this.rootChild2Node, result.get(4));
    }

    public void testAddExpansionCommandsForRootDescendants() {
        Object[] treeModel = this.initializeTreeModel();
        this.getRidget().bindToModel(treeModel, ITreeNode.class, "children", "parent", "value", null, null, null, null, "expanded");
        Queue expansionStack = (Queue)ReflectionUtils.getHidden((Object)this.getRidget(), (String)"expansionStack");
        expansionStack.clear();
        ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"addExpansionCommandsForRootDescendants", (Object[])new Object[]{treeModel[0]});
        TreeRidgetTest.assertEquals((int)2, (int)expansionStack.size());
    }

    public void testIsLeaf() {
        this.initializeTreeModel();
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"isLeaf", (Object[])new Object[]{this.rootChild1Node});
        TreeRidgetTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"isLeaf", (Object[])new Object[]{this.rootChild1Child2ChildNode});
        TreeRidgetTest.assertTrue((boolean)ret);
    }

    private ITreeNode[] initializeTreeModel() {
        this.rootNode = new ExpandedTreeNode(ROOT_NODE_USER_OBJECT);
        this.rootChild1Node = new ExpandedTreeNode(this.rootNode, ROOT_CHILD1_NODE_USER_OBJECT, false);
        this.rootChild2Node = new ExpandedTreeNode(this.rootNode, ROOT_CHILD2_NODE_USER_OBJECT);
        this.rootChild1Child1Node = new ExpandedTreeNode(this.rootChild1Node, ROOT_CHILD1_CHILD1_NODE_USER_OBJECT);
        this.rootChild1Child2Node = new ExpandedTreeNode(this.rootChild1Node, ROOT_CHILD1_CHILD2_NODE_USER_OBJECT, true);
        this.rootChild1Child2ChildNode = new ExpandedTreeNode(this.rootChild1Child2Node, ROOT_CHILD1_CHILD2_CHILD_NODE_USER_OBJECT);
        return new ITreeNode[]{this.rootNode};
    }

    private void removeFromParent(ITreeNode node) {
        ITreeNode parent = node.getParent();
        if (parent != null) {
            List children = parent.getChildren();
            children.remove(node);
            parent.setChildren(children);
        }
    }

    private TreeItem getUIControlItem(int index) {
        this.getRidget().expandAll();
        Tree control = this.getWidget();
        switch (index) {
            case 0: {
                return control.getItem(0);
            }
            case 1: {
                return control.getItem(0).getItem(0);
            }
            case 2: {
                return control.getItem(0).getItem(0).getItem(0);
            }
            case 3: {
                return control.getItem(0).getItem(1);
            }
        }
        throw new IndexOutOfBoundsException("index= " + index);
    }

    public static final class ExpandedTreeNode
    extends TreeNode {
        public static final String PROPERTY_EXPANDED = "expanded";
        private boolean expanded;

        public ExpandedTreeNode(Object pValue) {
            super(pValue);
            this.setExpanded(true);
        }

        public ExpandedTreeNode(ITreeNode pParent, Object pValue) {
            this(pParent, pValue, true);
        }

        public ExpandedTreeNode(ITreeNode pParent, Object pValue, boolean expanded) {
            super(pParent, pValue);
            this.setExpanded(expanded);
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }
    }

    private static final class TreeNodeWithIcon
    extends TreeNode {
        public TreeNodeWithIcon(ITreeNode pParent, Object pValue) {
            super(pParent, pValue);
        }

        public String getIcon() {
            return "eclipse.gif";
        }
    }
}

