/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationSwitcherWidget;
import org.eclipse.riena.ui.swt.facades.internal.SubApplicationToolTip;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SubApplicationToolTipTest
extends TestCase {
    private SubApplicationSwitcherWidget switcher;
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        ApplicationNode node = new ApplicationNode();
        this.switcher = new SubApplicationSwitcherWidget((Composite)this.shell, 0, (IApplicationNode)node);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.switcher);
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testGetToolTipText() {
        SubApplicationNode node = new SubApplicationNode();
        node.setToolTipText("hello, this is a tip");
        SubApplicationItem item = new SubApplicationItem((Composite)this.switcher, (ISubApplicationNode)node);
        item.setBounds(new Rectangle(0, 0, 10, 10));
        List items = (List)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItems", null);
        items.add(item);
        MyToolTip toolTip = new MyToolTip(this.switcher);
        Event event = new Event();
        event.x = 5;
        event.y = 5;
        SubApplicationToolTipTest.assertTrue((boolean)toolTip.shouldCreateToolTip(event));
        String text = toolTip.getToolTipText(event);
        SubApplicationToolTipTest.assertEquals((String)node.getToolTipText(), (String)text);
        event.x = 500;
        event.y = 500;
        SubApplicationToolTipTest.assertFalse((boolean)toolTip.shouldCreateToolTip(event));
        text = toolTip.getToolTipText(event);
        SubApplicationToolTipTest.assertNull((Object)text);
    }

    private class MyToolTip
    extends SubApplicationToolTip {
        public MyToolTip(SubApplicationSwitcherWidget control) {
            super(control);
        }

        public String getToolTipText(Event event) {
            return super.getToolTipText(event);
        }

        public boolean shouldCreateToolTip(Event event) {
            return super.shouldCreateToolTip(event);
        }
    }
}

