/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.rienadefault;

import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.BorderMarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.lnf.ILnfCustomizer;
import org.eclipse.riena.ui.swt.lnf.ILnfMarkerSupportExtension;
import org.eclipse.riena.ui.swt.lnf.ILnfTheme;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultTheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

@NonUITestCase
public class RienaDefaultLnfTest
extends RienaTestCase {
    private static final boolean BOOLEAN_VALUE = true;
    private static final Integer INTEGER_VALUE = 4;
    private static final String BOOLEAN_KEY = "boolean";
    private static final String INTEGER_KEY = "integer";
    private RienaDefaultLnf lnf;

    protected void setUp() throws Exception {
        super.setUp();
        this.lnf = new RienaDefaultLnf();
        this.lnf.initialize();
    }

    protected void tearDown() throws Exception {
        this.lnf.setTheme(null);
        this.lnf.uninitialize();
        this.lnf = null;
        super.tearDown();
    }

    public void testInitialize() throws Exception {
        this.lnf.uninitialize();
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getRenderer("SubModuleView.borderRenderer"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getFont("EmbeddedTitlebar.font"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
        this.lnf.initialize();
        RienaDefaultLnfTest.assertNotNull((Object)this.lnf.getFont("EmbeddedTitlebar.font"));
        RienaDefaultLnfTest.assertNotNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
    }

    public void testUninitialize() throws Exception {
        Color color = this.lnf.getColor("EmbeddedTitlebar.foreground");
        RienaDefaultLnfTest.assertNotNull((Object)color);
        Font font = this.lnf.getFont("EmbeddedTitlebar.font");
        RienaDefaultLnfTest.assertNotNull((Object)font);
        this.lnf.uninitialize();
        RienaDefaultLnfTest.assertFalse((boolean)font.isDisposed());
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getFont("EmbeddedTitlebar.font"));
        RienaDefaultLnfTest.assertFalse((boolean)color.isDisposed());
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
        RienaDefaultLnfTest.assertNotSame((Object)color, (Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
    }

    public void testGetColor() throws Exception {
        this.lnf.initialize();
        RienaDefaultLnfTest.assertNotNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("EmbeddedTitlebar.font"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("dummy"));
    }

    public void testGetFont() throws Exception {
        this.lnf.initialize();
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getFont("EmbeddedTitlebar.foreground"));
        RienaDefaultLnfTest.assertNotNull((Object)this.lnf.getFont("EmbeddedTitlebar.font"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getFont("dummy"));
    }

    public void testGetFontWithProps() throws Exception {
        this.lnf.initialize();
        Font font = this.lnf.getFont("EmbeddedTitlebar.font", 10, 3);
        FontData data = font.getFontData()[0];
        RienaDefaultLnfTest.assertEquals((int)3, (int)data.getStyle());
        Font font1 = this.lnf.getFont("EmbeddedTitlebar.font", 12, 1);
        data = font1.getFontData()[0];
        RienaDefaultLnfTest.assertEquals((int)1, (int)data.getStyle());
        Font font2 = this.lnf.getFont("EmbeddedTitlebar.font", 12, 1);
        RienaDefaultLnfTest.assertSame((Object)font1, (Object)font2);
        Font fontNull = this.lnf.getFont("EmbeddedTitlebar.foreground", 12, 1);
        RienaDefaultLnfTest.assertNull((Object)fontNull);
    }

    public void testGetTheme() throws Exception {
        RienaDefaultLnfTest.assertEquals(RienaDefaultTheme.class, this.lnf.getTheme().getClass());
        this.lnf.setTheme((ILnfTheme)new DummyTheme(null, null));
        RienaDefaultLnfTest.assertEquals(DummyTheme.class, this.lnf.getTheme().getClass());
    }

    public void testSetTheme() throws Exception {
        Color color1 = this.lnf.getColor("EmbeddedTitlebar.foreground");
        RienaDefaultLnfTest.assertNotNull((Object)color1);
        this.lnf.setTheme((ILnfTheme)new DummyTheme(null, null));
        this.lnf.initialize();
        RienaDefaultLnfTest.assertFalse((boolean)color1.isDisposed());
        Color color2 = this.lnf.getColor("EmbeddedTitlebar.foreground");
        RienaDefaultLnfTest.assertNull((Object)color2);
    }

    public void testGetIntegerSetting() throws Exception {
        Integer value = this.lnf.getIntegerSetting(INTEGER_KEY, Integer.valueOf(300));
        RienaDefaultLnfTest.assertEquals((int)300, (int)value);
        this.lnf.setTheme((ILnfTheme)new DummyTheme(null, null));
        this.lnf.initialize();
        value = this.lnf.getIntegerSetting(INTEGER_KEY, Integer.valueOf(300));
        RienaDefaultLnfTest.assertEquals((int)INTEGER_VALUE, (int)value);
    }

    public void testGetBooleanSetting() throws Exception {
        boolean value = this.lnf.getBooleanSetting(BOOLEAN_KEY, true);
        RienaDefaultLnfTest.assertTrue((boolean)value);
        value = this.lnf.getBooleanSetting(BOOLEAN_KEY, false);
        RienaDefaultLnfTest.assertFalse((boolean)value);
        this.lnf.setTheme((ILnfTheme)new DummyTheme(null, null));
        this.lnf.initialize();
        value = this.lnf.getBooleanSetting(BOOLEAN_KEY, false);
        RienaDefaultLnfTest.assertEquals((boolean)true, (boolean)value);
    }

    public void testGetMarkerSupport() {
        this.lnf.update(new ILnfMarkerSupportExtension[]{new ILnfMarkerSupportExtension(){

            public String getId() {
                return "defaultMarkerSupport";
            }

            public AbstractMarkerSupport createMarkerSupport() {
                return new MarkerSupport();
            }
        }, new ILnfMarkerSupportExtension(){

            public String getId() {
                return "borderMarkerSupport";
            }

            public AbstractMarkerSupport createMarkerSupport() {
                return new BorderMarkerSupport();
            }
        }});
        AbstractMarkerSupport markerSupport = this.lnf.getMarkerSupport(null);
        RienaDefaultLnfTest.assertNotNull((Object)markerSupport);
        RienaDefaultLnfTest.assertTrue((markerSupport.getClass() == BorderMarkerSupport.class ? 1 : 0) != 0);
        this.lnf.setTheme((ILnfTheme)new DummyTheme(null, null));
        this.lnf.initialize();
        markerSupport = this.lnf.getMarkerSupport(null);
        RienaDefaultLnfTest.assertNull((Object)markerSupport);
        this.lnf.setTheme((ILnfTheme)new DummyTheme2());
        this.lnf.initialize();
        markerSupport = this.lnf.getMarkerSupport(null);
        RienaDefaultLnfTest.assertNotNull((Object)markerSupport);
        RienaDefaultLnfTest.assertTrue((markerSupport.getClass() == BorderMarkerSupport.class ? 1 : 0) != 0);
    }

    public void testReadSystemProperties() {
        this.lnf.setTheme((ILnfTheme)new DummyTheme(null, null));
        this.lnf.initialize();
        RienaDefaultLnfTest.assertEquals((Object)INTEGER_VALUE, (Object)this.lnf.getIntegerSetting(INTEGER_KEY));
        System.setProperty("riena.lnf.setting.integer", "4711");
        ReflectionUtils.invokeHidden((Object)this.lnf, (String)"readSystemProperties", (Object[])new Object[0]);
        RienaDefaultLnfTest.assertEquals((Object)4711, (Object)this.lnf.getIntegerSetting(INTEGER_KEY));
    }

    private static class DummyTheme
    implements ILnfTheme {
        private DummyTheme() {
        }

        public void customizeLnf(ILnfCustomizer customizer) {
            customizer.putLnfSetting(RienaDefaultLnfTest.INTEGER_KEY, (Object)INTEGER_VALUE);
            customizer.putLnfSetting(RienaDefaultLnfTest.BOOLEAN_KEY, (Object)true);
            customizer.putLnfSetting("markerSupport.id", (Object)"0815");
        }

        /* synthetic */ DummyTheme(DummyTheme dummyTheme, DummyTheme dummyTheme2) {
            this();
        }
    }

    private static class DummyTheme2
    extends DummyTheme {
        private DummyTheme2() {
        }

        @Override
        public void customizeLnf(ILnfCustomizer customizer) {
            super.customizeLnf(customizer);
            customizer.putLnfSetting("markerSupport.id", (Object)"borderMarkerSupport");
        }
    }
}

