/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.util.Collection;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.marker.StatuslineMessageMarkerViewer;

public class RidgetToStatuslineSubscriber {
    public static final String SHOW_RIDGET_MESSAGES_IN_STATUSLINE_KEY = "riena.showRidgetMessagesInStatusline";
    private StatuslineMessageMarkerViewer messageViewer;

    public void addRidget(IRidget ridget) {
        this.setStatuslineViewerForRidget(ridget, this.messageViewer);
    }

    public void removeRidget(IRidget ridget) {
        this.removeStatuslineViewerForRidget(ridget, this.messageViewer);
    }

    public void setStatuslineToShowMarkerMessages(IStatuslineRidget statusline, Collection<? extends IRidget> ridgets) {
        if (!this.isDifferentStatusline(statusline)) {
            return;
        }
        StatuslineMessageMarkerViewer newMessageViewer = this.createMessageViewer(statusline);
        for (IRidget iRidget : ridgets) {
            this.removeStatuslineViewerForRidget(iRidget, this.messageViewer);
            if (newMessageViewer == null) continue;
            this.setStatuslineViewerForRidget(iRidget, newMessageViewer);
        }
        this.messageViewer = newMessageViewer;
    }

    protected StatuslineMessageMarkerViewer createMessageViewer(IStatuslineRidget statusline) {
        return statusline != null ? new StatuslineMessageMarkerViewer(statusline) : null;
    }

    public boolean isDifferentStatusline(IStatuslineRidget statuslineToShowMarkerMessages) {
        return this.messageViewer == null && statuslineToShowMarkerMessages != null || this.messageViewer != null && this.messageViewer.getStatusLine() != statuslineToShowMarkerMessages;
    }

    private void removeStatuslineViewerForRidget(IRidget ridget, StatuslineMessageMarkerViewer messageViewer) {
        if (ridget == null || messageViewer == null) {
            return;
        }
        if (ridget instanceof IRidgetContainer) {
            ((IRidgetContainer)((Object)ridget)).setStatuslineToShowMarkerMessages(null);
        } else if (ridget instanceof IBasicMarkableRidget) {
            messageViewer.removeRidget((IBasicMarkableRidget)ridget);
        }
    }

    private void setStatuslineViewerForRidget(IRidget ridget, StatuslineMessageMarkerViewer messageViewer) {
        if (messageViewer == null || ridget == null) {
            return;
        }
        if (ridget instanceof IRidgetContainer) {
            ((IRidgetContainer)((Object)ridget)).setStatuslineToShowMarkerMessages(messageViewer.getStatusLine());
        } else if (ridget instanceof IBasicMarkableRidget) {
            messageViewer.addRidget((IBasicMarkableRidget)ridget);
        }
    }
}

