/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.riena.ui.ridgets.databinding.ConversionFailure;
import org.eclipse.riena.ui.ridgets.validation.Utils;

public class StringToDateConverter
extends Converter {
    private final DateFormat format;

    public StringToDateConverter(String pattern) {
        super(String.class, Date.class);
        this.format = new SimpleDateFormat(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object fromObject) {
        if (fromObject == null || "".equals(fromObject) || Utils.isEmptyDate((String)fromObject)) {
            return null;
        }
        try {
            DateFormat dateFormat = this.format;
            synchronized (dateFormat) {
                Date parsedDate = this.format.parse((String)fromObject);
                return parsedDate;
            }
        }
        catch (ParseException e) {
            throw new ConversionFailure("Cannot convert \"" + fromObject + "\" to a java.util.Date.", e);
        }
    }
}

