/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.riena.ui.swt.InfoFlyout;
import org.eclipse.riena.ui.swt.layout.DpiGridLayoutFactory;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.TimelineEase;

public class InfoFlyoutRCP
extends InfoFlyout {
    private static final Integer PAUSE_ANIMATION_TIME = LnfManager.getLnf().getIntegerSetting("InfoFlyout.pausetime");
    private static final Integer WAIT_ANIMATION_TIME = LnfManager.getLnf().getIntegerSetting("InfoFlyout.waittime");
    private static final Integer SHOW_HIDE_ANIMATION_TIME = LnfManager.getLnf().getIntegerSetting("InfoFlyout.showhidetime");
    private static final int WIDTH = InfoFlyoutRCP.getLnfSettingAndConvertX("InfoFlyout.width");
    private static final int HEIGHT = InfoFlyoutRCP.getLnfSettingAndConvertY("InfoFlyout.height");
    private static final int SHELL_RIGHT_INDENT = InfoFlyoutRCP.getLnfSettingAndConvertX("InfoFlyout.rightindent");
    private static final int ICON_LEFT_MARGIN = InfoFlyoutRCP.getLnfSettingAndConvertX("InfoFlyout.leftmargin");
    private static final int TEXT_LEFT_MARGIN = InfoFlyoutRCP.getLnfSettingAndConvertX("InfoFlyout.icontextgap");
    private static final int INFO_FLYOUT_RIGHT_MARGIN = InfoFlyoutRCP.getLnfSettingAndConvertX("InfoFlyout.rightmargin");
    private static final int RIGHT_LABEL_WIDTH = WIDTH - INFO_FLYOUT_RIGHT_MARGIN - TEXT_LEFT_MARGIN - ICON_LEFT_MARGIN - SwtUtilities.convertXToDpi((int)30);
    private String message;
    private String icon;
    private Shell shell;
    private final Composite parent;
    private Timeline tShow;
    private Timeline tWait;
    private Timeline tHide;
    private Timeline tWaitAtEnd;
    private Label rightLabel;
    private Label leftLabel;
    private Rectangle topLevelShellBounds;
    private int xPosition;
    private int startY;
    private int endY;
    private CountDownLatch latch;
    private final Color bgColor;

    public InfoFlyoutRCP(Composite parent) {
        this.parent = parent;
        this.message = "";
        this.icon = null;
        this.bgColor = LnfManager.getLnf().getColor("InfoFlyout.backgroundcolor");
        this.latch = new CountDownLatch(0);
        this.initializeLayout();
    }

    public void openFlyout() {
        if (!this.isAnimationGoingOn() && !this.shell.isDisposed()) {
            this.latch = new CountDownLatch(1);
            this.updateIconAndMessage();
            this.updateLocation();
            this.updateLayoutData();
            this.initializeTimelines();
            this.shell.setVisible(true);
            this.tShow.play();
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void waitForClosing() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static int getLnfSettingAndConvertX(String lnfKey) {
        int setting = LnfManager.getLnf().getIntegerSetting(lnfKey);
        return SwtUtilities.convertXToDpi((int)setting);
    }

    private static int getLnfSettingAndConvertY(String lnfKey) {
        int setting = LnfManager.getLnf().getIntegerSetting(lnfKey);
        return SwtUtilities.convertYToDpi((int)setting);
    }

    private void initializeLayout() {
        Assert.isTrue((this.shell == null ? 1 : 0) != 0);
        Shell parentShell = this.parent.getShell();
        parentShell.addControlListener((ControlListener)new CloseOnParentMove());
        this.shell = new Shell(parentShell, 8);
        this.shell.addPaintListener((PaintListener)new BorderPainter());
        DpiGridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)this.shell);
        this.shell.setBackground(this.bgColor);
        this.leftLabel = UIControlsFactory.createLabel((Composite)this.shell, (String)"");
        this.leftLabel.setImage(ImageStore.getInstance().getImage("arrowright"));
        this.leftLabel.setBackground(this.bgColor);
        this.rightLabel = UIControlsFactory.createLabel((Composite)this.shell, (String)this.message, (int)64);
        this.rightLabel.setBackground(this.bgColor);
        this.rightLabel.setFont(LnfManager.getLnf().getFont("InfoFlyout.font"));
        this.updateLocation();
        this.updateLayoutData();
    }

    private void updateIconAndMessage() {
        this.rightLabel.setText(this.message);
        this.leftLabel.setImage(ImageStore.getInstance().getImage(this.icon));
        this.shell.layout(true);
    }

    private void initializeTimelines() {
        this.tShow = new Timeline((Object)this.shell);
        this.tWait = new Timeline((Object)this.shell);
        this.tHide = new Timeline((Object)this.shell);
        this.tWaitAtEnd = new Timeline((Object)this.shell);
        this.tShow.addPropertyToInterpolate(Timeline.property((String)"location").fromCurrent().to((Object)new Point(this.xPosition, this.endY)));
        this.tShow.addPropertyToInterpolate(Timeline.property((String)"size").fromCurrent().to((Object)new Point(WIDTH, HEIGHT)));
        this.tHide.addPropertyToInterpolate(Timeline.property((String)"location").fromCurrent().to((Object)new Point(this.xPosition, this.startY)));
        this.tHide.addPropertyToInterpolate(Timeline.property((String)"size").fromCurrent().to((Object)new Point(WIDTH, 0)));
        this.tShow.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (newState == Timeline.TimelineState.DONE) {
                    InfoFlyoutRCP.this.tWait.play();
                }
            }
        });
        this.tWait.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (newState == Timeline.TimelineState.DONE) {
                    InfoFlyoutRCP.this.tHide.play();
                }
            }
        });
        this.tHide.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (newState == Timeline.TimelineState.DONE) {
                    InfoFlyoutRCP.this.tWaitAtEnd.play();
                }
            }
        });
        this.tWaitAtEnd.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (newState == Timeline.TimelineState.DONE) {
                    4 var5_5 = this;
                    synchronized (var5_5) {
                        InfoFlyoutRCP.this.latch.countDown();
                    }
                }
            }
        });
        this.tShow.setDuration((long)SHOW_HIDE_ANIMATION_TIME.intValue());
        this.tWait.setDuration((long)WAIT_ANIMATION_TIME.intValue());
        this.tHide.setDuration((long)SHOW_HIDE_ANIMATION_TIME.intValue());
        this.tWaitAtEnd.setDuration((long)PAUSE_ANIMATION_TIME.intValue());
        this.tHide.setEase((TimelineEase)new Sine());
        this.tShow.setEase((TimelineEase)new Sine());
    }

    private void updateLayoutData() {
        int topIndent = (HEIGHT - this.rightLabel.getBounds().height) / 2;
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(ICON_LEFT_MARGIN, topIndent).applyTo((Control)this.leftLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(TEXT_LEFT_MARGIN, topIndent).hint(RIGHT_LABEL_WIDTH, -1).applyTo((Control)this.rightLabel);
    }

    private void updateLocation() {
        Shell topLevelShell = this.parent.getShell();
        this.topLevelShellBounds = topLevelShell.getBounds();
        this.xPosition = this.topLevelShellBounds.x + this.topLevelShellBounds.width - WIDTH - SHELL_RIGHT_INDENT;
        this.startY = this.parent.getDisplay().map((Control)this.parent.getParent(), null, (Rectangle)this.parent.getBounds()).y + this.positionCorrectionY;
        this.endY = this.startY - HEIGHT;
        this.shell.setSize(WIDTH, 0);
        this.shell.setLocation(this.xPosition, this.startY);
    }

    private boolean isAnimationGoingOn() {
        if (this.tShow == null || this.tWait == null || this.tHide == null) {
            return false;
        }
        boolean isPlaying = this.tShow.getState() == Timeline.TimelineState.PLAYING_FORWARD;
        isPlaying |= this.tWait.getState() == Timeline.TimelineState.PLAYING_FORWARD;
        return isPlaying |= this.tHide.getState() == Timeline.TimelineState.PLAYING_FORWARD;
    }

    private static final class BorderPainter
    implements PaintListener {
        private BorderPainter() {
        }

        public void paintControl(PaintEvent e) {
            Control control = (Control)e.widget;
            GC gc = e.gc;
            Color oldFg = gc.getForeground();
            int oldWidth = gc.getLineWidth();
            gc.setForeground(LnfManager.getLnf().getColor("InfoFlyout.bordercolor"));
            gc.setLineWidth(1);
            Rectangle bounds = control.getBounds();
            gc.drawLine(0, 0, bounds.width - 1, 0);
            gc.drawLine(0, 0, 0, bounds.height - 1);
            gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height);
            gc.setForeground(oldFg);
            gc.setLineWidth(oldWidth);
        }
    }

    private final class CloseOnParentMove
    implements ControlListener {
        private CloseOnParentMove() {
        }

        public void controlMoved(ControlEvent e) {
            this.close();
        }

        public void controlResized(ControlEvent e) {
            this.close();
        }

        private void close() {
            if (!InfoFlyoutRCP.this.shell.isDisposed() && InfoFlyoutRCP.this.shell.isVisible()) {
                InfoFlyoutRCP.this.shell.setVisible(false);
                InfoFlyoutRCP.this.tShow.abort();
                InfoFlyoutRCP.this.tWait.abort();
                InfoFlyoutRCP.this.tHide.abort();
                InfoFlyoutRCP.this.latch.countDown();
            }
        }
    }
}

