/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.layout;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public final class DpiGridData {
    private final GridData originGridData;
    public final boolean exclude;
    public final int widthHint;
    public final int heightHint;
    public final int minimumWidth;
    public final int minimumHeight;
    public final int horizontalIndent;
    public final int verticalIndent;
    public final boolean grabExcessHorizontalSpace;
    public final boolean grabExcessVerticalSpace;
    public final int horizontalSpan;
    public final int verticalSpan;
    public final int verticalAlignment;
    public final int horizontalAlignment;
    public int cacheWidth = -1;
    public int cacheHeight = -1;
    private int defaultWhint;
    private int defaultHhint;
    private int defaultWidth = -1;
    private int defaultHeight = -1;
    private int currentWhint;
    private int currentHhint;
    private int currentWidth = -1;
    private int currentHeight = -1;

    public DpiGridData() {
        this(null);
    }

    public DpiGridData(GridData gridData) {
        this.originGridData = gridData != null ? GridDataFactory.copyData((GridData)gridData) : null;
        GridData tmpGridData = gridData;
        if (tmpGridData == null) {
            tmpGridData = new GridData();
        }
        this.exclude = tmpGridData.exclude;
        this.widthHint = tmpGridData.widthHint == -1 ? tmpGridData.widthHint : SwtUtilities.convertXToDpi(tmpGridData.widthHint);
        this.heightHint = tmpGridData.heightHint == -1 ? tmpGridData.heightHint : SwtUtilities.convertYToDpi(tmpGridData.heightHint);
        this.minimumWidth = SwtUtilities.convertXToDpi(tmpGridData.minimumWidth);
        this.minimumHeight = SwtUtilities.convertYToDpi(tmpGridData.minimumHeight);
        this.horizontalIndent = SwtUtilities.convertXToDpi(tmpGridData.horizontalIndent);
        this.verticalIndent = SwtUtilities.convertYToDpi(tmpGridData.verticalIndent);
        this.grabExcessHorizontalSpace = tmpGridData.grabExcessHorizontalSpace;
        this.grabExcessVerticalSpace = tmpGridData.grabExcessVerticalSpace;
        this.horizontalSpan = tmpGridData.horizontalSpan;
        this.verticalSpan = tmpGridData.verticalSpan;
        this.horizontalAlignment = tmpGridData.horizontalAlignment;
        this.verticalAlignment = tmpGridData.verticalAlignment;
    }

    public void computeSize(Control control, int wHint, int hHint, boolean flushCache) {
        if (this.cacheWidth != -1 && this.cacheHeight != -1) {
            return;
        }
        if (wHint == this.widthHint && hHint == this.heightHint) {
            if (this.defaultWidth == -1 || this.defaultHeight == -1 || wHint != this.defaultWhint || hHint != this.defaultHhint) {
                Point size = control.computeSize(wHint, hHint, flushCache);
                this.defaultWhint = wHint;
                this.defaultHhint = hHint;
                this.defaultWidth = size.x;
                this.defaultHeight = size.y;
            }
            this.cacheWidth = this.defaultWidth;
            this.cacheHeight = this.defaultHeight;
            return;
        }
        if (this.currentWidth == -1 || this.currentHeight == -1 || wHint != this.currentWhint || hHint != this.currentHhint) {
            Point size = control.computeSize(wHint, hHint, flushCache);
            this.currentWhint = wHint;
            this.currentHhint = hHint;
            this.currentWidth = size.x;
            this.currentHeight = size.y;
        }
        this.cacheWidth = this.currentWidth;
        this.cacheHeight = this.currentHeight;
    }

    public void flushCache() {
        this.cacheHeight = -1;
        this.cacheWidth = -1;
        this.defaultHeight = -1;
        this.defaultWidth = -1;
        this.currentHeight = -1;
        this.currentWidth = -1;
    }

    private String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public String toString() {
        String hAlign = "";
        switch (this.horizontalAlignment) {
            case 4: {
                hAlign = "SWT.FILL";
                break;
            }
            case 1: {
                hAlign = "SWT.BEGINNING";
                break;
            }
            case 16384: {
                hAlign = "SWT.LEFT";
                break;
            }
            case 0x1000008: {
                hAlign = "SWT.END";
                break;
            }
            case 3: {
                hAlign = "GridData.END";
                break;
            }
            case 131072: {
                hAlign = "SWT.RIGHT";
                break;
            }
            case 0x1000000: {
                hAlign = "SWT.CENTER";
                break;
            }
            case 2: {
                hAlign = "GridData.CENTER";
                break;
            }
            default: {
                hAlign = "Undefined " + this.horizontalAlignment;
            }
        }
        String vAlign = "";
        switch (this.verticalAlignment) {
            case 4: {
                vAlign = "SWT.FILL";
                break;
            }
            case 1: {
                vAlign = "SWT.BEGINNING";
                break;
            }
            case 128: {
                vAlign = "SWT.TOP";
                break;
            }
            case 0x1000008: {
                vAlign = "SWT.END";
                break;
            }
            case 3: {
                vAlign = "GridData.END";
                break;
            }
            case 1024: {
                vAlign = "SWT.BOTTOM";
                break;
            }
            case 0x1000000: {
                vAlign = "SWT.CENTER";
                break;
            }
            case 2: {
                vAlign = "GridData.CENTER";
                break;
            }
            default: {
                vAlign = "Undefined " + this.verticalAlignment;
            }
        }
        String string = String.valueOf(this.getName()) + " {";
        string = String.valueOf(string) + "horizontalAlignment=" + hAlign + " ";
        if (this.horizontalIndent != 0) {
            string = String.valueOf(string) + "horizontalIndent=" + this.horizontalIndent + " ";
        }
        if (this.horizontalSpan != 1) {
            string = String.valueOf(string) + "horizontalSpan=" + this.horizontalSpan + " ";
        }
        if (this.grabExcessHorizontalSpace) {
            string = String.valueOf(string) + "grabExcessHorizontalSpace=" + this.grabExcessHorizontalSpace + " ";
        }
        if (this.widthHint != -1) {
            string = String.valueOf(string) + "widthHint=" + this.widthHint + " ";
        }
        if (this.minimumWidth != 0) {
            string = String.valueOf(string) + "minimumWidth=" + this.minimumWidth + " ";
        }
        string = String.valueOf(string) + "verticalAlignment=" + vAlign + " ";
        if (this.verticalIndent != 0) {
            string = String.valueOf(string) + "verticalIndent=" + this.verticalIndent + " ";
        }
        if (this.verticalSpan != 1) {
            string = String.valueOf(string) + "verticalSpan=" + this.verticalSpan + " ";
        }
        if (this.grabExcessVerticalSpace) {
            string = String.valueOf(string) + "grabExcessVerticalSpace=" + this.grabExcessVerticalSpace + " ";
        }
        if (this.heightHint != -1) {
            string = String.valueOf(string) + "heightHint=" + this.heightHint + " ";
        }
        if (this.minimumHeight != 0) {
            string = String.valueOf(string) + "minimumHeight=" + this.minimumHeight + " ";
        }
        if (this.exclude) {
            string = String.valueOf(string) + "exclude=" + this.exclude + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }

    public boolean originGridDataEquals(GridData gridData) {
        if (this.originGridData == gridData) {
            return true;
        }
        if (this.originGridData == null || gridData == null) {
            return false;
        }
        if (this.originGridData.exclude != gridData.exclude) {
            return false;
        }
        if (this.originGridData.grabExcessHorizontalSpace != gridData.grabExcessHorizontalSpace) {
            return false;
        }
        if (this.originGridData.grabExcessVerticalSpace != gridData.grabExcessVerticalSpace) {
            return false;
        }
        if (this.originGridData.heightHint != gridData.heightHint) {
            return false;
        }
        if (this.originGridData.horizontalAlignment != gridData.horizontalAlignment) {
            return false;
        }
        if (this.originGridData.horizontalIndent != gridData.horizontalIndent) {
            return false;
        }
        if (this.originGridData.horizontalSpan != gridData.horizontalSpan) {
            return false;
        }
        if (this.originGridData.minimumHeight != gridData.minimumHeight) {
            return false;
        }
        if (this.originGridData.minimumWidth != gridData.minimumWidth) {
            return false;
        }
        if (this.originGridData.verticalAlignment != gridData.verticalAlignment) {
            return false;
        }
        if (this.originGridData.verticalIndent != gridData.verticalIndent) {
            return false;
        }
        if (this.originGridData.verticalSpan != gridData.verticalSpan) {
            return false;
        }
        return this.originGridData.widthHint == gridData.widthHint;
    }
}

