/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.ui.swt.RienaWindowRenderer;
import org.eclipse.riena.ui.swt.facades.DialogConstantsFacade;
import org.eclipse.riena.ui.swt.layout.DpiGridLayout;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RienaMessageDialog
extends MessageDialog {
    private final LnFUpdater lnfUpdater = LnFUpdater.getInstance();
    private final RienaWindowRenderer dlgRenderer = new RienaWindowRenderer((Window)this);

    public static boolean open(int kind, Shell parent, String title, String message, int style) {
        RienaMessageDialog dialog = new RienaMessageDialog(parent, title, null, message, kind, RienaMessageDialog.getButtonLabels(kind), 0);
        dialog.setShellStyle(dialog.getShellStyle() | (style &= 0x10000000));
        return dialog.open() == 0;
    }

    public static boolean openConfirm(Shell parent, String title, String message) {
        return RienaMessageDialog.open(5, parent, title, message, 0);
    }

    public static void openError(Shell parent, String title, String message) {
        RienaMessageDialog.open(1, parent, title, message, 0);
    }

    public static void openInformation(Shell parent, String title, String message) {
        RienaMessageDialog.open(2, parent, title, message, 0);
    }

    public static boolean openQuestion(Shell parent, String title, String message) {
        return RienaMessageDialog.open(3, parent, title, message, 0);
    }

    public static void openWarning(Shell parent, String title, String message) {
        RienaMessageDialog.open(4, parent, title, message, 0);
    }

    private static String[] getButtonLabels(int kind) {
        DialogConstantsFacade facade = DialogConstantsFacade.getDefault();
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                return new String[]{facade.getOkLabel()};
            }
            case 5: {
                return new String[]{facade.getOkLabel(), facade.getCancelLabel()};
            }
            case 3: {
                return new String[]{facade.getYesLabel(), facade.getNoLabel()};
            }
            case 6: {
                return new String[]{facade.getYesLabel(), facade.getNoLabel(), facade.getCancelLabel()};
            }
        }
        throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
    }

    public RienaMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    protected void createDialogAndButtonArea(Composite parent) {
        DpiGridLayout gridLayout = new DpiGridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.dlgRenderer.createContents(parent);
        Composite centerComposite = this.dlgRenderer.getCenterComposite();
        gridLayout = new DpiGridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = LayoutConstants.getSpacing().x * 2;
        gridLayout.verticalSpacing = LayoutConstants.getSpacing().y;
        gridLayout.marginWidth = LayoutConstants.getMargins().x;
        gridLayout.marginHeight = LayoutConstants.getMargins().y;
        centerComposite.setLayout((Layout)gridLayout);
        this.dialogArea = this.createDialogArea(centerComposite);
        this.buttonBar = this.createButtonBar(centerComposite);
        this.lnfUpdater.updateUIControls(parent, true);
    }

    public void create() {
        this.setShellStyle(this.dlgRenderer.computeShellStyle());
        super.create();
    }

    public Image getErrorImage() {
        Image image = this.getLnfImage("messageBox.errorIcon");
        if (image == null) {
            image = super.getErrorImage();
        }
        return image;
    }

    public Image getWarningImage() {
        Image image = this.getLnfImage("messageBox.warningIcon");
        if (image == null) {
            image = super.getWarningImage();
        }
        return image;
    }

    public Image getInfoImage() {
        Image image = this.getLnfImage("messageBox.infoIcon");
        if (image == null) {
            image = super.getInfoImage();
        }
        return image;
    }

    public Image getQuestionImage() {
        Image image = this.getLnfImage("messageBox.questionIcon");
        if (image == null) {
            image = super.getQuestionImage();
        }
        return image;
    }

    private Image getLnfImage(String lnfKey) {
        return LnfManager.getLnf().getImage(lnfKey);
    }
}

