/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.ui.swt.StatusMeter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public final class StatusMeterWidget
extends Canvas {
    private int value = 0;
    private int maximum = 100;
    private int minimum = 0;
    private final StatusMeter.StatusMeterBuilder builder = StatusMeter.widgetDefault();
    private Image image;

    public StatusMeterWidget(Composite parent) {
        this(parent, 0);
    }

    public StatusMeterWidget(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = StatusMeterWidget.this.getBounds();
                if (bounds.width != 0 && bounds.height != 0) {
                    if (StatusMeterWidget.this.image != null) {
                        StatusMeterWidget.this.image.dispose();
                    }
                    ImageData imageData = StatusMeterWidget.this.builder.width(bounds.width).height(bounds.height).getImageData();
                    StatusMeterWidget.this.image = new Image((Device)StatusMeterWidget.this.getDisplay(), imageData);
                    e.gc.drawImage(StatusMeterWidget.this.image, 0, 0);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void setValue(int value) {
        this.value = value;
        this.builder.value(value);
        this.redraw();
    }

    public int getValue() {
        return this.value;
    }

    public void setMaximum(int max) {
        this.maximum = max;
        this.builder.maximum(max);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int min) {
        this.minimum = min;
        this.builder.minimum(min);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setBorderColor(Color color) {
        this.builder.borderColor(color);
    }

    public void setBackgroundColor(Color color) {
        this.builder.backgroundColor(color);
    }

    public void setGradientStartColor(Color color) {
        this.builder.gradientStartColor(color);
    }

    public void setGradientEndColor(Color color) {
        this.builder.gradientEndColor(color);
    }
}

