/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.UriUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class UriBuilder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UriBuilder.class);
    private final Map<String, String> m_parameters = new HashMap<String, String>();
    private String m_scheme;
    private String m_host;
    private int m_port = -1;
    private String m_path;
    private String m_fragment;

    public UriBuilder() {
    }

    public UriBuilder(String uri) throws ProcessingException {
        this(uri, null);
    }

    public UriBuilder(String uri, String encoding) throws ProcessingException {
        this(UriUtility.toUri(uri), encoding);
    }

    public UriBuilder(URL url) throws ProcessingException {
        this(UriUtility.urlToUri(url), null);
    }

    public UriBuilder(URI uri) throws ProcessingException {
        this(uri, null);
    }

    public UriBuilder(URL url, String encoding) throws ProcessingException {
        this(UriUtility.urlToUri(url), encoding);
    }

    public UriBuilder(URI uri, String encoding) throws ProcessingException {
        if (uri == null) {
            return;
        }
        this.m_scheme = uri.getScheme();
        this.m_host = uri.getHost();
        this.m_port = uri.getPort();
        this.m_path = uri.getPath();
        this.m_fragment = uri.getFragment();
        Map<String, String> params = UriUtility.getQueryParameters(uri, encoding);
        this.m_parameters.putAll(params);
    }

    public UriBuilder scheme(String scheme) {
        this.m_scheme = scheme;
        return this;
    }

    public UriBuilder host(String host) {
        this.m_host = host;
        return this;
    }

    public UriBuilder port(int port) {
        this.m_port = port < 1 ? -1 : port;
        return this;
    }

    public UriBuilder path(String path) {
        this.m_path = path;
        return this;
    }

    public UriBuilder addPath(String path) {
        if (StringUtility.hasText(path)) {
            this.m_path = StringUtility.join("/", this.m_path, path);
        }
        return this;
    }

    public UriBuilder fragment(String fragment) {
        this.m_fragment = fragment;
        return this;
    }

    public UriBuilder parameter(String name, String value) {
        if (!StringUtility.hasText(name)) {
            return this;
        }
        if (value == null) {
            this.m_parameters.remove(name);
        } else {
            this.m_parameters.put(name, value);
        }
        return this;
    }

    public URL createURL() throws ProcessingException {
        return this.createURL(null);
    }

    public URI createURI() throws ProcessingException {
        return this.createURI(null);
    }

    public URL createURL(String encoding) throws ProcessingException {
        return UriUtility.uriToUrl(this.createURI(encoding));
    }

    public URI createURI(String encoding) throws ProcessingException {
        try {
            if (this.m_parameters == null || this.m_parameters.isEmpty()) {
                return new URI(this.m_scheme, null, this.m_host, this.m_port, this.m_path, null, this.m_fragment);
            }
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            StringBuilder query = new StringBuilder();
            for (Map.Entry<String, String> param : this.m_parameters.entrySet()) {
                if (!StringUtility.hasText(param.getKey())) {
                    LOG.warn("ignoring parameter with empty key");
                    continue;
                }
                if (query.length() > 0) {
                    query.append("&");
                }
                try {
                    query.append(URLEncoder.encode(param.getKey(), encoding));
                    query.append("=");
                    query.append(URLEncoder.encode(param.getValue(), encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ProcessingException("Unsupported encoding '" + encoding + "'", e);
                }
            }
            return new URI(this.m_scheme, null, this.m_host, this.m_port, this.m_path, query.toString(), this.m_fragment);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("error creating URI", e);
        }
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public Map<String, String> getParameters() {
        return CollectionUtility.copyMap(this.m_parameters);
    }
}

