/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ContextFinderBasedObjectInputStream
extends ObjectInputStream {
    private static ClassContextAccessor ccAccessor;
    private ClassLoader m_primaryClassLoader;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ccAccessor = new ClassContextAccessor();
                return null;
            }
        });
    }

    public ContextFinderBasedObjectInputStream(InputStream in) throws IOException {
        this(in, null);
    }

    public ContextFinderBasedObjectInputStream(InputStream in, ClassLoader primaryClassLoader) throws IOException {
        super(in);
        this.m_primaryClassLoader = primaryClassLoader;
        this.enableResolveObject(true);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return this.defaultResolveClass(desc.getName());
        }
        catch (ClassNotFoundException e) {
            return this.pass2ResolveClass(desc.getName());
        }
    }

    private Class<?> defaultResolveClass(String className) throws ClassNotFoundException, IOException {
        return Class.forName(className);
    }

    private Class<?> pass2ResolveClass(String className) throws ClassNotFoundException, IOException {
        if (this.m_primaryClassLoader != null) {
            try {
                return Class.forName(className, false, this.m_primaryClassLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Class[] cc = ccAccessor.getClassContext();
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader lastLoader = null;
        int i = 1;
        while (i < cc.length) {
            ClassLoader cl = cc[i].getClassLoader();
            if (cl != null && cl != this.m_primaryClassLoader && cl != contextLoader && cl != lastLoader) {
                lastLoader = cl;
                try {
                    return Class.forName(className, false, cl);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw new ClassNotFoundException(className);
    }

    private static final class ClassContextAccessor
    extends SecurityManager {
        private ClassContextAccessor() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

