/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal;

import java.security.AccessController;
import javax.security.auth.Subject;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.RunnableWithException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.internal.ContextHelper;
import org.eclipse.scout.jaxws.internal.SessionHelper;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;

public class ScoutTransactionDelegate {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutTransactionDelegate.class);
    private ScoutTransaction m_scoutTransaction;

    public ScoutTransactionDelegate(ScoutTransaction scoutTransaction) {
        this.m_scoutTransaction = scoutTransaction;
    }

    public <T> T runInTransaction(final RunnableWithException<T> runnable, MessageContext context) {
        IServerSession serverSession = ContextHelper.getContextSession(context);
        if (serverSession == null) {
            try {
                IServerSessionFactory factory = this.m_scoutTransaction.sessionFactory().newInstance();
                serverSession = SessionHelper.createNewServerSession(factory);
                ContextHelper.setContextSession(context, factory, serverSession);
            }
            catch (Exception e) {
                LOG.error("Failed to create server session for transactional handler", (Throwable)e);
            }
        }
        if (serverSession == null) {
            LOG.error("No server session applicable. Handler is not run in transactional scope.");
            return this.doRun(runnable);
        }
        final P_Holder resultHolder = new P_Holder();
        Holder errorHolder = new Holder(RuntimeException.class);
        Subject subject = Subject.getSubject(AccessController.getContext());
        ServerJob serverJob = new ServerJob("Transactional handler", serverSession, subject, (IHolder)errorHolder){
            private final /* synthetic */ IHolder val$errorHolder;
            {
                this.val$errorHolder = iHolder;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                try {
                    Object result = ScoutTransactionDelegate.this.doRun(runnable);
                    resultHolder.setValue(result);
                }
                catch (RuntimeException e) {
                    this.val$errorHolder.setValue((Object)e);
                }
                return Status.OK_STATUS;
            }
        };
        serverJob.setSystem(true);
        serverJob.runNow((IProgressMonitor)new NullProgressMonitor());
        if (errorHolder.getValue() != null) {
            throw (RuntimeException)errorHolder.getValue();
        }
        return resultHolder.getValue();
    }

    protected <T> T doRun(RunnableWithException<T> runnable) {
        try {
            return (T)runnable.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebServiceException(e);
        }
    }

    private static class P_Holder<T> {
        private T m_value;

        private P_Holder() {
        }

        public T getValue() {
            return this.m_value;
        }

        public void setValue(T value) {
            this.m_value = value;
        }
    }
}

