/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.security;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

public class GlobalTrustManagerService
extends AbstractService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(GlobalTrustManagerService.class);
    private static final String PATH_CERTS = "/certificates";

    public void installGlobalTrustManager() throws ProcessingException {
        this.installGlobalTrustManager("TLS", TrustManagerFactory.getDefaultAlgorithm());
    }

    public void installGlobalTrustManager(String protocol, String tmAlgorithm) throws ProcessingException {
        try {
            X509Certificate[] trustedCerts = this.getTrustedCertificates();
            X509TrustManager globalTrustManager = this.createGlobalTrustManager(tmAlgorithm, trustedCerts);
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, new TrustManager[]{globalTrustManager}, new SecureRandom());
            SSLContext.setDefault(sslContext);
        }
        catch (Exception e) {
            throw new ProcessingException("could not install global trust manager.", (Throwable)e);
        }
    }

    protected X509Certificate[] getTrustedCertificates() throws IOException, CertificateException {
        LinkedList<X509Certificate> trustedCerts = new LinkedList<X509Certificate>();
        FilenameFilter certFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.toLowerCase().endsWith(".der");
            }
        };
        try {
            RemoteFile[] certRemoteFiles = ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).getRemoteFiles(PATH_CERTS, certFilter, null);
            if (certRemoteFiles.length == 0) {
                LOG.warn("No certificates to trust in folder '/certificates' could be found.");
            }
            RemoteFile[] remoteFileArray = certRemoteFiles;
            int n = certRemoteFiles.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteFile certRemoteFile = remoteFileArray[n2];
                try {
                    LOG.info("Trusted certificate '" + certRemoteFile.getName() + "' found.");
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    certRemoteFile.writeData((OutputStream)os);
                    X509Certificate cert = this.readX509Cert(new ByteArrayInputStream(os.toByteArray()));
                    trustedCerts.add(cert);
                    LOG.info("Trusted certificate '" + certRemoteFile.getName() + "' successfully installed.");
                }
                catch (Exception e) {
                    LOG.info("Failed to install trusted certificate '" + certRemoteFile.getName() + "'.");
                }
                ++n2;
            }
        }
        catch (ProcessingException e) {
            LOG.error("Could not access folder '/certificates' to import trusted certificates.", (Throwable)e);
        }
        return trustedCerts.toArray(new X509Certificate[trustedCerts.size()]);
    }

    protected X509TrustManager createGlobalTrustManager(String tmAlgorithm, X509Certificate[] trustedCerts) throws Exception {
        return new P_GlobalTrustManager(trustedCerts, tmAlgorithm);
    }

    private X509Certificate readX509Cert(InputStream inputStream) throws CertificateException, IOException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = null;
        while (bis.available() > 0) {
            cert = (X509Certificate)certFactory.generateCertificate(bis);
        }
        try {
            bis.close();
        }
        catch (IOException e) {
            LOG.warn("could not close input stream for certificate");
        }
        return cert;
    }

    protected class P_GlobalTrustManager
    implements X509TrustManager {
        private TrustManager[] m_installedTrustManagers;
        private X509Certificate[] m_trustedCerts;

        public P_GlobalTrustManager(X509Certificate[] trustedCerts, String tmAlgorithm) throws Exception {
            this.m_trustedCerts = trustedCerts != null ? trustedCerts : new X509Certificate[0];
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmAlgorithm);
            trustManagerFactory.init((KeyStore)null);
            this.m_installedTrustManagers = trustManagerFactory.getTrustManagers();
            if (this.m_installedTrustManagers == null) {
                this.m_installedTrustManagers = new TrustManager[0];
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            TrustManager[] trustManagerArray = this.m_installedTrustManagers;
            int n = this.m_installedTrustManagers.length;
            int n2 = 0;
            while (n2 < n) {
                TrustManager installedTrustManager = trustManagerArray[n2];
                if (installedTrustManager instanceof X509TrustManager) {
                    try {
                        ((X509TrustManager)installedTrustManager).checkClientTrusted(certs, authType);
                    }
                    catch (CertificateException e) {
                        LOG.error("certificate not trusted.", (Throwable)e);
                        throw e;
                    }
                }
                ++n2;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            Object[] objectArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate candidateCert = objectArray[n2];
                if (candidateCert != null) {
                    X509Certificate[] x509CertificateArray = this.m_trustedCerts;
                    int n3 = this.m_trustedCerts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        X509Certificate trustedCert = x509CertificateArray[n4];
                        if (trustedCert != null) {
                            try {
                                candidateCert.verify(trustedCert.getPublicKey());
                                candidateCert.checkValidity();
                                return;
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                                // empty catch block
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            objectArray = this.m_installedTrustManagers;
            n = this.m_installedTrustManagers.length;
            n2 = 0;
            while (n2 < n) {
                Object trustManager = objectArray[n2];
                if (trustManager instanceof X509TrustManager) {
                    try {
                        ((X509TrustManager)trustManager).checkServerTrusted(certs, authType);
                    }
                    catch (CertificateException e) {
                        LOG.error("certificate not trusted.", (Throwable)e);
                        throw e;
                    }
                }
                ++n2;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> trustedCertsAll = new ArrayList<X509Certificate>();
            trustedCertsAll.addAll(Arrays.asList(this.m_trustedCerts));
            TrustManager[] trustManagerArray = this.m_installedTrustManagers;
            int n = this.m_installedTrustManagers.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate[] certs;
                TrustManager trustManager = trustManagerArray[n2];
                if (trustManager instanceof X509TrustManager && (certs = ((X509TrustManager)trustManager).getAcceptedIssuers()) != null && certs.length > 0) {
                    trustedCertsAll.addAll(Arrays.asList(certs));
                }
                ++n2;
            }
            return trustedCertsAll.toArray(new X509Certificate[trustedCertsAll.size()]);
        }

        private String printCertificates(X509Certificate[] certificates) {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter writer = new BufferedWriter(stringWriter);
            X509Certificate[] x509CertificateArray = certificates;
            int n = certificates.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate certificate = x509CertificateArray[n2];
                try {
                    writer.write(certificate.toString());
                    writer.newLine();
                }
                catch (IOException e) {
                    LOG.warn("Error while printing certificates.", (Throwable)e);
                }
                ++n2;
            }
            return stringWriter.getBuffer().toString();
        }
    }
}

