/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.nls.sdk.internal.INlsIcons;
import org.eclipse.scout.nls.sdk.internal.model.workspace.NlsWorkspace;
import org.eclipse.scout.nls.sdk.model.workspace.INlsWorkspace;
import org.eclipse.scout.sdk.util.log.SdkLogManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class NlsCore
extends AbstractUIPlugin
implements INlsIcons {
    public static final String COLOR_NLS_ROW_INACTIVE_FOREGROUND = "nlsRowInactiveForeground";
    public static final String COLOR_TABLE_CURSOR_BACKGROUND = "color_table_cursor_background";
    public static final String COLOR_TABLE_CURSOR_FOREGROUND = "color_table_cursor_foreground";
    public static final String COLOR_TABLE_CURSOR_INACTIVE_BACKGROUND = "color_table_cursor_inactive_background";
    public static final String COLOR_TABLE_CURSOR_INACTIVE_FOREGROUND = "color_table_cursor_inactive_foreground";
    public static final String PLUGIN_ID = "org.eclipse.scout.nls.sdk";
    private static NlsCore plugin;
    private static String imagePath;
    private static SdkLogManager logManager;
    private ColorRegistry m_colorRegistry;
    private INlsWorkspace m_nlsWorkspace;

    static {
        imagePath = "resources/icons/";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (PlatformUI.isWorkbenchRunning()) {
            this.m_colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
            this.m_colorRegistry.put(COLOR_NLS_ROW_INACTIVE_FOREGROUND, new RGB(178, 178, 178));
            this.m_colorRegistry.put(COLOR_TABLE_CURSOR_INACTIVE_BACKGROUND, new RGB(255, 255, 255));
            this.m_colorRegistry.put(COLOR_TABLE_CURSOR_BACKGROUND, new RGB(13, 58, 161));
            this.m_colorRegistry.put(COLOR_TABLE_CURSOR_FOREGROUND, new RGB(255, 255, 255));
            this.m_colorRegistry.put(COLOR_TABLE_CURSOR_INACTIVE_FOREGROUND, new RGB(0, 0, 0));
        }
        this.m_nlsWorkspace = new NlsWorkspace();
        plugin = this;
        logManager = new SdkLogManager((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        logManager = null;
        this.m_nlsWorkspace = null;
        this.m_colorRegistry = null;
        super.stop(context);
    }

    public static NlsCore getDefault() {
        return plugin;
    }

    public static void logInfo(Throwable t) {
        logManager.logInfo(t);
    }

    public static void logInfo(String message) {
        logManager.logInfo(message);
    }

    public static void logInfo(String message, Throwable t) {
        logManager.logInfo(message, t);
    }

    public static void logWarning(String message) {
        logManager.logWarning(message);
    }

    public static void logWarning(Throwable t) {
        logManager.logWarning(t);
    }

    public static void logWarning(String message, Throwable t) {
        logManager.logWarning(message, t);
    }

    public static void logError(Throwable t) {
        logManager.logError(t);
    }

    public static void logError(String message) {
        logManager.logError(message);
    }

    public static void logError(String message, Throwable t) {
        logManager.logError(message, t);
    }

    public static Image getImage(String name) {
        Image img = plugin.getImageRegistry().get(name);
        if (img == null) {
            NlsCore.getImageDescriptor(name);
        }
        return plugin.getImageRegistry().get(name);
    }

    public static Color getColor(String key) {
        return NlsCore.getDefault().m_colorRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        ImageDescriptor desc = plugin.getImageRegistry().getDescriptor(name);
        if (desc == null) {
            desc = NlsCore.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(String.valueOf(imagePath) + name + ".gif"));
            if (desc == null) {
                desc = NlsCore.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(String.valueOf(imagePath) + name + ".png"));
            }
            if (desc == null) {
                desc = NlsCore.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(String.valueOf(imagePath) + name + ".jpg"));
            }
            if (desc == null) {
                System.err.println("could not find image for plugin: org.eclipse.scout.nls.sdk under: " + imagePath + name);
            }
            plugin.getImageRegistry().put(name, desc);
        }
        return desc;
    }

    public static INlsWorkspace getNlsWorkspace() {
        return NlsCore.getDefault().getNlsWorkspaceImpl();
    }

    private INlsWorkspace getNlsWorkspaceImpl() {
        return this.m_nlsWorkspace;
    }

    public static IStatus getHighestSeverityStatus(IStatus status) {
        return NlsCore.getDefault().getHighestSeverityStatusImpl(status, Status.OK_STATUS);
    }

    private IStatus getHighestSeverityStatusImpl(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatusImpl(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        return this.getDialogSettingsSection(name, true);
    }

    public IDialogSettings getDialogSettingsSection(String name, boolean createIfNotExist) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }
}

