/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.navigation;

import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.mobile.navigation.BreadCrumb;
import org.eclipse.scout.rt.client.mobile.navigation.BreadCrumbsEvent;
import org.eclipse.scout.rt.client.mobile.navigation.BreadCrumbsListener;
import org.eclipse.scout.rt.client.mobile.navigation.IBreadCrumb;
import org.eclipse.scout.rt.client.mobile.navigation.IBreadCrumbsNavigation;
import org.eclipse.scout.rt.client.mobile.navigation.OutlineChooserBreadCrumb;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IOutlineChooserForm;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;

public class BreadCrumbsNavigation
implements IBreadCrumbsNavigation {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BreadCrumbsNavigation.class);
    private final EventListenerList m_listenerList;
    private Stack<IBreadCrumb> m_breadCrumbs;
    private P_DesktopListener m_desktopListener;
    private List<String> m_navigationFormsDisplayViewIds;
    private P_FormListener m_formListener;
    private IBreadCrumb m_currentBreadCrumb;
    private IDesktop m_desktop;

    public BreadCrumbsNavigation() {
        this(null);
    }

    public BreadCrumbsNavigation(IDesktop desktop) {
        if (desktop == null) {
            desktop = ClientSyncJob.getCurrentSession().getDesktop();
        }
        this.m_desktop = desktop;
        if (this.m_desktop == null) {
            throw new IllegalArgumentException("No desktop found. Cannot create bread crumbs navigation.");
        }
        this.m_breadCrumbs = new Stack();
        this.m_listenerList = new EventListenerList();
        this.m_desktopListener = new P_DesktopListener();
        desktop.addDesktopListener((DesktopListener)this.m_desktopListener);
    }

    @Override
    public Stack<IBreadCrumb> getBreadCrumbs() {
        return this.m_breadCrumbs;
    }

    @Override
    public void trackDisplayViewId(String displayViewId) {
        if (this.m_navigationFormsDisplayViewIds == null) {
            this.m_navigationFormsDisplayViewIds = new LinkedList<String>();
        }
        if (!this.m_navigationFormsDisplayViewIds.contains(displayViewId)) {
            this.m_navigationFormsDisplayViewIds.add(displayViewId);
        }
    }

    @Override
    public void stepBack() throws ProcessingException {
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop == null) {
            return;
        }
        Stack<IBreadCrumb> breadCrumbs = this.getBreadCrumbs();
        if (breadCrumbs.size() == 0) {
            LOG.debug("Stepping back not possible because no bread crumbs found.");
            return;
        }
        this.m_currentBreadCrumb = breadCrumbs.pop();
        this.m_currentBreadCrumb.activate();
        LOG.debug("Stepped back to: " + this.m_currentBreadCrumb);
        LOG.debug("Current bread crumbs way: " + this.toString());
        this.fireBreadCrumbsChanged();
    }

    @Override
    public boolean isSteppingBackPossible() {
        return this.getBreadCrumbs().size() > 0;
    }

    @Override
    public boolean isGoingHomePossible() {
        return this.isSteppingBackPossible();
    }

    @Override
    public void goHome() throws ProcessingException {
        if (this.getBreadCrumbs().size() == 0) {
            return;
        }
        this.activate((IBreadCrumb)this.getBreadCrumbs().get(0));
    }

    public void activate(IBreadCrumb breadCrumb) throws ProcessingException {
        if (!this.getBreadCrumbs().contains(breadCrumb)) {
            return;
        }
        do {
            this.m_currentBreadCrumb = this.getBreadCrumbs().pop();
        } while (this.m_currentBreadCrumb != breadCrumb);
        this.m_currentBreadCrumb.activate();
        LOG.debug("Activated bread crumb: " + this.m_currentBreadCrumb);
        LOG.debug("Current bread crumbs way: " + this.toString());
        this.fireBreadCrumbsChanged();
    }

    @Override
    public List<IForm> getCurrentNavigationForms() {
        LinkedList<IForm> navigationForms = new LinkedList<IForm>();
        for (IForm form : this.getDesktop().getDialogStack()) {
            navigationForms.add(form);
        }
        for (IForm form : this.getDesktop().getViewStack()) {
            if (this.m_navigationFormsDisplayViewIds == null || !this.m_navigationFormsDisplayViewIds.contains(form.getDisplayViewId())) continue;
            navigationForms.add(form);
        }
        return navigationForms;
    }

    @Override
    public boolean containsFormInHistory(IForm form) {
        if (form == null) {
            return false;
        }
        for (IBreadCrumb breadCrumb : this.getBreadCrumbs()) {
            if (form != breadCrumb.getForm()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IForm getCurrentNavigationForm() {
        if (this.m_currentBreadCrumb != null) {
            return this.m_currentBreadCrumb.getForm();
        }
        return null;
    }

    @Override
    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    private void destroy() {
        if (this.m_desktopListener != null) {
            this.getDesktop().removeDesktopListener((DesktopListener)this.m_desktopListener);
            this.m_desktopListener = null;
        }
        this.getBreadCrumbs().clear();
    }

    private void removeExistingBreadCrumb(IForm form) {
        if (this.m_currentBreadCrumb == null) {
            return;
        }
        if (this.m_currentBreadCrumb.belongsTo(form)) {
            LOG.debug("Removing existing bread crumb: " + this.m_currentBreadCrumb);
            this.m_currentBreadCrumb = this.getBreadCrumbs().size() > 0 ? this.getBreadCrumbs().pop() : null;
            LOG.debug("Current bread crumbs way: " + this.toString());
            this.fireBreadCrumbsChanged();
        } else {
            IBreadCrumb[] breadCrumbs = this.getBreadCrumbs().toArray(new IBreadCrumb[this.getBreadCrumbs().size()]);
            int pos = 0;
            IBreadCrumb[] iBreadCrumbArray = breadCrumbs;
            int n = breadCrumbs.length;
            int n2 = 0;
            while (n2 < n) {
                IBreadCrumb breadCrumb = iBreadCrumbArray[n2];
                if (breadCrumb.belongsTo(form)) {
                    LOG.debug("Removing existing bread crumb: " + breadCrumb);
                    this.getBreadCrumbs().remove(breadCrumb);
                    this.mergeDuplicates(pos);
                    LOG.debug("Current bread crumbs way: " + this.toString());
                    this.fireBreadCrumbsChanged();
                    return;
                }
                ++pos;
                ++n2;
            }
        }
    }

    private void mergeDuplicates(int pos) {
        if (pos <= 0 || pos >= this.getBreadCrumbs().size()) {
            return;
        }
        IBreadCrumb predecessor = (IBreadCrumb)this.getBreadCrumbs().get(pos - 1);
        IBreadCrumb successor = (IBreadCrumb)this.getBreadCrumbs().get(pos);
        if (predecessor.getForm() == successor.getForm()) {
            this.getBreadCrumbs().remove(successor);
            LOG.debug("Removing duplicate bread crumb: " + successor);
        }
    }

    private void addNewBreadCrumb(IForm form) {
        if (this.m_currentBreadCrumb != null) {
            if (this.m_currentBreadCrumb.belongsTo(form)) {
                return;
            }
            this.getBreadCrumbs().add(this.m_currentBreadCrumb);
            LOG.debug("Added new bread crumb: " + this.m_currentBreadCrumb);
        }
        this.m_currentBreadCrumb = form instanceof IOutlineChooserForm ? new OutlineChooserBreadCrumb(this, form) : new BreadCrumb(this, form);
        LOG.debug("Current bread crumbs way: " + this.toString());
        this.fireBreadCrumbsChanged();
    }

    @Override
    public void addBreadCrumbsListener(BreadCrumbsListener listener) {
        this.m_listenerList.add(BreadCrumbsListener.class, (EventListener)listener);
    }

    @Override
    public void removeBreadCrumbsListener(BreadCrumbsListener listener) {
        this.m_listenerList.remove(BreadCrumbsListener.class, (EventListener)listener);
    }

    private void fireBreadCrumbsChanged() {
        BreadCrumbsEvent e = new BreadCrumbsEvent(this, 10);
        this.fireBreadCrumbsEvent(e);
    }

    private void fireBreadCrumbsEvent(BreadCrumbsEvent e) {
        EventListener[] a = this.m_listenerList.getListeners(BreadCrumbsListener.class);
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                ((BreadCrumbsListener)a[i]).breadCrumbsChanged(e);
                ++i;
            }
        }
    }

    public String toString() {
        String breadCrumbsWay = "";
        for (IBreadCrumb breadCrumb : this.getBreadCrumbs()) {
            breadCrumbsWay = String.valueOf(breadCrumbsWay) + "[" + breadCrumb + "] > ";
        }
        breadCrumbsWay = this.m_currentBreadCrumb != null ? String.valueOf(breadCrumbsWay) + "[" + this.m_currentBreadCrumb + "]" : "empty bread crumbs navigation";
        return breadCrumbsWay;
    }

    private class P_DesktopListener
    implements DesktopListener {
        private P_DesktopListener() {
        }

        public void desktopChanged(DesktopEvent e) {
            switch (e.getType()) {
                case 600: {
                    this.handleFormAdded(e);
                    break;
                }
                case 610: {
                    this.handleFormRemoved(e);
                    break;
                }
                case 100: {
                    BreadCrumbsNavigation.this.destroy();
                    break;
                }
            }
        }

        private void handleFormAdded(DesktopEvent e) {
            IForm form = e.getForm();
            if (20 == form.getDisplayHint() && BreadCrumbsNavigation.this.m_navigationFormsDisplayViewIds != null && !BreadCrumbsNavigation.this.m_navigationFormsDisplayViewIds.contains(form.getDisplayViewId())) {
                return;
            }
            if (BreadCrumbsNavigation.this.m_currentBreadCrumb == null) {
                BreadCrumbsNavigation.this.addNewBreadCrumb(form);
            } else if (BreadCrumbsNavigation.this.m_currentBreadCrumb.getForm() != form) {
                BreadCrumbsNavigation.this.addNewBreadCrumb(form);
            }
            this.attachFormListener(form);
        }

        private void handleFormRemoved(DesktopEvent e) {
            if (BreadCrumbsNavigation.this.getBreadCrumbs().size() == 0) {
                return;
            }
            IForm form = e.getForm();
            if (MobileDesktopUtility.isToolForm(form)) {
                BreadCrumbsNavigation.this.removeExistingBreadCrumb(form);
            }
        }

        private void attachFormListener(IForm form) {
            if (BreadCrumbsNavigation.this.m_formListener == null) {
                BreadCrumbsNavigation.this.m_formListener = new P_FormListener();
            }
            form.removeFormListener((FormListener)BreadCrumbsNavigation.this.m_formListener);
            form.addFormListener((FormListener)BreadCrumbsNavigation.this.m_formListener);
        }
    }

    private class P_FormListener
    implements FormListener {
        private P_FormListener() {
        }

        public void formChanged(FormEvent e) throws ProcessingException {
            if (3010 == e.getType()) {
                IForm form = e.getForm();
                BreadCrumbsNavigation.this.removeExistingBreadCrumb(form);
                this.detachFormListener(form);
            }
        }

        private void detachFormListener(IForm form) {
            form.removeFormListener((FormListener)this);
        }
    }
}

