/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.transformation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformationHook;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class DeviceTransformationHooks {
    private static List<TransformationHookRef> s_transformationHooks = new ArrayList<TransformationHookRef>();
    private static final Object REGISTRY_LOCK = new Object();

    public static void addFormTransformationHook(Class<? extends IForm> formClass, IDeviceTransformationHook formTransformationHook) {
        DeviceTransformationHooks.addTransformationHook(formClass, formTransformationHook);
    }

    public static void removeFormTransformationHook(Class<? extends IForm> formClass, IDeviceTransformationHook formTransformationHook) {
        DeviceTransformationHooks.removeTransformationHook(formClass, formTransformationHook);
    }

    public static List<IDeviceTransformationHook> getFormTransformationHooks(Class<? extends IForm> formClass) {
        return DeviceTransformationHooks.getTransformationHooks(formClass);
    }

    public static void addFormFieldTransformationHook(Class<? extends IFormField> fieldClass, IDeviceTransformationHook transformationHook) {
        DeviceTransformationHooks.addTransformationHook(fieldClass, transformationHook);
    }

    public static void removeFormFieldTransformationHook(Class<? extends IFormField> fieldClass, IDeviceTransformationHook formFieldTransformationHook) {
        DeviceTransformationHooks.removeTransformationHook(fieldClass, formFieldTransformationHook);
    }

    public static List<IDeviceTransformationHook> getFormFieldTransformationHooks(Class<? extends IFormField> fieldClass) {
        return DeviceTransformationHooks.getTransformationHooks(fieldClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTransformationHook(Class<?> refClass, IDeviceTransformationHook transformationHook) {
        Object object = REGISTRY_LOCK;
        synchronized (object) {
            int index = 0;
            int insertPos = 0;
            boolean added = false;
            for (TransformationHookRef ref : s_transformationHooks) {
                int typeDistance;
                if (ref.getRefClass().equals(refClass)) {
                    ref.getHooks().add(transformationHook);
                    added = true;
                    break;
                }
                if (refClass.isAssignableFrom(ref.getRefClass()) && (typeDistance = BeanUtility.computeTypeDistance(refClass, ref.getRefClass())) > 0) {
                    insertPos = index + 1;
                }
                ++index;
            }
            if (!added) {
                s_transformationHooks.add(insertPos, new TransformationHookRef(refClass, transformationHook));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTransformationHook(Class<?> refClass, IDeviceTransformationHook formFieldTransformationHook) {
        Object object = REGISTRY_LOCK;
        synchronized (object) {
            List<IDeviceTransformationHook> hooks = DeviceTransformationHooks.getTransformationHooks(refClass);
            if (hooks != null) {
                hooks.remove(formFieldTransformationHook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IDeviceTransformationHook> getTransformationHooks(Class<?> refClass) {
        Object object = REGISTRY_LOCK;
        synchronized (object) {
            for (TransformationHookRef ref : s_transformationHooks) {
                if (!ref.getRefClass().isAssignableFrom(refClass)) continue;
                return ref.getHooks();
            }
        }
        return null;
    }

    private static class TransformationHookRef {
        private Class<?> m_refClass;
        private List<IDeviceTransformationHook> m_hooks;

        public TransformationHookRef(Class<?> refClass, IDeviceTransformationHook hook) {
            this.m_refClass = refClass;
            this.m_hooks = new LinkedList<IDeviceTransformationHook>();
            this.m_hooks.add(hook);
        }

        public Class<?> getRefClass() {
            return this.m_refClass;
        }

        public List<IDeviceTransformationHook> getHooks() {
            return this.m_hooks;
        }
    }
}

