/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table.columns;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.Activator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.DrillDownStyleMap;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.columns.IRowSummaryColumn;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="349c912d-0e60-42a0-bd8d-b4c6c08ec62a")
public class AbstractRowSummaryColumn
extends AbstractStringColumn
implements IRowSummaryColumn {
    private boolean m_initialized;
    private IColumn<?> m_cellHeaderColumn;
    private List<IColumn<?>> m_cellDetailColumns;
    private String m_htmlCellTemplate;
    private String m_htmlDrillDown;
    private String m_htmlDrillDownButton;
    private int m_maxCellDetailColumns;
    private static final Pattern bodyPartPattern = Pattern.compile("(.*<body[^>]*>)(.*)(</body>.*)", 34);
    private static final Pattern htmlPartPattern = Pattern.compile("(.*<html[^>]*>)(.*)(</html>.*)", 34);

    public AbstractRowSummaryColumn() {
        try {
            this.m_htmlCellTemplate = this.initHtmlCellTemplate();
            this.m_htmlDrillDown = this.initHtmlDrillDown();
            this.m_htmlDrillDownButton = this.initHtmlDrillDownButton();
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    protected void initConfig() {
        super.initConfig();
        this.setDefaultDrillDownStyle(this.getConfiguredDefaultDrillDownStyle());
    }

    protected String initHtmlCellTemplate() throws ProcessingException {
        try {
            return new String(IOUtility.getContent((InputStream)Activator.getDefault().getBundle().getResource("resources/html/MobileTableCellContent.html").openStream()), "iso-8859-1");
        }
        catch (Throwable t) {
            throw new ProcessingException("Exception while loading html cell template for mobile table", t);
        }
    }

    protected String initHtmlDrillDown() throws ProcessingException {
        try {
            return new String(IOUtility.getContent((InputStream)Activator.getDefault().getBundle().getResource("resources/html/MobileTableDrillDown.html").openStream()), "iso-8859-1");
        }
        catch (Throwable t) {
            throw new ProcessingException("Exception while loading html cell template for mobile table", t);
        }
    }

    protected String initHtmlDrillDownButton() throws ProcessingException {
        try {
            return new String(IOUtility.getContent((InputStream)Activator.getDefault().getBundle().getResource("resources/html/MobileTableDrillDownButton.html").openStream()), "iso-8859-1");
        }
        catch (Throwable t) {
            throw new ProcessingException("Exception while loading html cell template for mobile table", t);
        }
    }

    @Override
    public String getDefaultDrillDownStyle() {
        return this.propertySupport.getPropertyString("defaultDrillDownStyle");
    }

    @Override
    public void setDefaultDrillDownStyle(String drillDownStyle) {
        this.propertySupport.setPropertyString("defaultDrillDownStyle", drillDownStyle);
    }

    protected String getConfiguredDefaultDrillDownStyle() {
        return null;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public static boolean isDrillDownButtonUrl(URL url, String path, boolean local) {
        if (!local) {
            return false;
        }
        String query = url.getQuery();
        if (query == null) {
            return false;
        }
        String[] stringArray = query.split("[\\?\\&]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Matcher m = Pattern.compile("action=drill_down").matcher(s);
            if (m.matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void updateValue(ITableRow row, ITableRow modelRow, DrillDownStyleMap drillDownStyle) throws ProcessingException {
        this.setValue(row, this.computeContentColumnValue(modelRow, drillDownStyle));
    }

    public void updateValue(ITableRow row, ITableRow modelRow) throws ProcessingException {
        this.updateValue(row, modelRow, null);
    }

    public void initializeDecorationConfiguration(ITable table, int maxCellDetailColumns) {
        this.m_cellHeaderColumn = null;
        this.m_cellDetailColumns = new ArrayList(maxCellDetailColumns);
        this.m_maxCellDetailColumns = maxCellDetailColumns;
        int columnVisibleIndex = 0;
        for (IColumn column : table.getColumnSet().getVisibleColumns()) {
            if (this.m_cellDetailColumns.size() >= maxCellDetailColumns) break;
            if (this.m_cellHeaderColumn == null && this.useColumnForCellHeader(table, column)) {
                this.m_cellHeaderColumn = column;
            } else if (this.useColumnForCellDetail(table, column, columnVisibleIndex)) {
                this.m_cellDetailColumns.add(column);
            }
            ++columnVisibleIndex;
        }
        this.m_initialized = true;
    }

    private boolean useColumnForCellHeader(ITable table, IColumn<?> column) {
        if (this.isCheckBoxColumn(column)) {
            return false;
        }
        return table.getColumnSet().getSummaryColumns().size() == 0;
    }

    private boolean useColumnForCellDetail(ITable table, IColumn<?> column, int columnVisibleIndex) {
        boolean columnEmpty = true;
        int maxRowsToConsider = 10;
        if (this.isCheckBoxColumn(column)) {
            return false;
        }
        int freeSlots = this.m_maxCellDetailColumns - this.m_cellDetailColumns.size();
        int remainingColumns = table.getColumnSet().getVisibleColumns().size() - (columnVisibleIndex + 1);
        if (remainingColumns < freeSlots) {
            return true;
        }
        int row = 0;
        while (row < Math.min(maxRowsToConsider, table.getRowCount())) {
            ITableRow tableRow = table.getRow(row);
            String columnDisplayText = column.getDisplayText(tableRow);
            if (StringUtility.hasText((String)columnDisplayText)) {
                columnEmpty = false;
                String cellHeaderText = this.getCellHeaderText(tableRow);
                if (cellHeaderText != null && cellHeaderText.contains(columnDisplayText)) {
                    return false;
                }
            }
            ++row;
        }
        return !columnEmpty;
    }

    private String getCellHeaderText(ITableRow row) {
        if (this.m_cellHeaderColumn != null) {
            return this.m_cellHeaderColumn.getDisplayText(row);
        }
        return row.getTable().getSummaryCell(row).getText();
    }

    private String addGridLine(String existingHtml) {
        String borderDivStart = "<div style=\"width: 100%; height: 100%; border-bottom:1px solid #e1efec\">";
        String borderDivEnd = "</div>";
        String prePart = "";
        String mainPart = "";
        String postPart = "";
        Matcher m = bodyPartPattern.matcher(existingHtml);
        boolean found = m.find();
        if (!found) {
            m = htmlPartPattern.matcher(existingHtml);
            found = m.find();
        }
        if (found) {
            prePart = m.group(1);
            mainPart = m.group(2);
            postPart = m.group(3);
        } else {
            mainPart = existingHtml;
        }
        return String.valueOf(prePart) + borderDivStart + mainPart + borderDivEnd + postPart;
    }

    protected String adaptExistingHtmlInCellHeader(String cellHeaderHtml) {
        cellHeaderHtml = this.addGridLine(cellHeaderHtml);
        return cellHeaderHtml;
    }

    private boolean containsHtml(String text) {
        if (text == null || text.length() < 6) {
            return false;
        }
        if (text.charAt(0) == '<' && text.charAt(5) == '>') {
            String tag = text.substring(1, 5);
            return tag.equalsIgnoreCase("html");
        }
        return false;
    }

    private String computeContentColumnValue(ITableRow row, DrillDownStyleMap drillDownStyles) throws ProcessingException {
        if (row == null) {
            return null;
        }
        String cellHeaderText = this.getCellHeaderText(row);
        if (cellHeaderText == null) {
            cellHeaderText = "";
        }
        if (this.m_cellDetailColumns.size() == 0 && this.containsHtml(cellHeaderText)) {
            cellHeaderText = this.adaptExistingHtmlInCellHeader(cellHeaderText);
            if (drillDownStyles != null) {
                drillDownStyles.put(row, "none");
            }
            return cellHeaderText;
        }
        String content = "";
        boolean cellHasHeader = false;
        if (StringUtility.hasText((String)cellHeaderText)) {
            content = this.createCellHeader(cellHeaderText);
            content = String.valueOf(content) + "<br/>";
            cellHasHeader = true;
        }
        content = String.valueOf(content) + this.createCellDetail(row, cellHasHeader);
        String drillDownStyle = null;
        if (drillDownStyles != null) {
            drillDownStyle = drillDownStyles.get(row);
        }
        String icon = this.createCellIcon(row);
        String output = this.m_htmlCellTemplate.replace("#ICON#", icon);
        output = output.replace("#ICON_COL_WIDTH#", this.createCellIconColWidth(row, icon));
        output = output.replace("#CONTENT#", content);
        output = output.replace("#DRILL_DOWN#", this.createCellDrillDown(row, drillDownStyle));
        output = output.replace("#DRILL_DOWN_COL_WIDTH#", this.createCellDrillDownColWidth(row, drillDownStyle));
        return output;
    }

    private String createCellIcon(ITableRow row) {
        if (row == null) {
            return "";
        }
        String iconId = null;
        if (row.getTable().isCheckable()) {
            iconId = this.computeCheckboxIconId(row.isChecked());
        } else {
            iconId = row.getIconId();
            IColumn firstVisibleColumn = row.getTable().getColumnSet().getFirstVisibleColumn();
            if (iconId == null) {
                iconId = row.getCell(firstVisibleColumn).getIconId();
            }
            if (iconId == null && this.isCheckBoxColumn(firstVisibleColumn)) {
                IBooleanColumn booleanColumn = (IBooleanColumn)firstVisibleColumn;
                iconId = this.computeCheckboxIconId(BooleanUtility.nvl((Boolean)((Boolean)booleanColumn.getValue(row))));
            }
        }
        if (iconId == null) {
            return "";
        }
        return "<img width=\"16\" height=\"16\" src=\"cid:" + iconId + "\"/>";
    }

    private boolean isCheckBoxColumn(IColumn<?> column) {
        return column.getDataType() == Boolean.class && (!(column instanceof ISmartColumn) || ((ISmartColumn)column).getLookupCall() == null);
    }

    private String computeCheckboxIconId(boolean checked) {
        if (checked) {
            return "checkbox_yes";
        }
        return "checkbox_no";
    }

    private String createCellIconColWidth(ITableRow row, String icon) {
        if (StringUtility.hasText((String)icon)) {
            return "32";
        }
        return "6";
    }

    private String createCellDrillDown(ITableRow row, String drillDownStyle) {
        if (drillDownStyle == null) {
            drillDownStyle = this.getDefaultDrillDownStyle();
        }
        if ("icon".equals(drillDownStyle)) {
            return this.m_htmlDrillDown;
        }
        if ("button".equals(drillDownStyle)) {
            return this.m_htmlDrillDownButton;
        }
        return "";
    }

    private String createCellDrillDownColWidth(ITableRow row, String drillDownStyle) {
        if (drillDownStyle == null) {
            drillDownStyle = this.getDefaultDrillDownStyle();
        }
        if ("icon".equals(drillDownStyle)) {
            return "32";
        }
        if ("button".equals(drillDownStyle)) {
            return "60";
        }
        return "0";
    }

    private String createCellHeader(String cellHeaderText) {
        String content = "";
        content = this.cleanupText(cellHeaderText);
        content = "<b>" + content + "</b>";
        return content;
    }

    private String createCellDetail(ITableRow row, boolean cellHasHeader) {
        if (row == null) {
            return "";
        }
        String content = "";
        int col = 0;
        for (IColumn<?> column : this.m_cellDetailColumns) {
            String displayText = this.extractCellDisplayText(column, row);
            if (StringUtility.hasText((String)displayText)) {
                if (this.isHeaderDescriptionNeeded(row, column)) {
                    content = String.valueOf(content) + this.extractColumnHeader(column);
                    content = String.valueOf(content) + ": ";
                }
                content = String.valueOf(content) + displayText;
            }
            if (col < this.m_cellDetailColumns.size() - 1) {
                content = String.valueOf(content) + "<br/>";
            }
            ++col;
        }
        if (cellHasHeader) {
            content = "<span style=\"font-size:12px\">" + content + "</span>";
        }
        return content;
    }

    private String cleanupText(String text) {
        String textWithoutHtml;
        if (text == null) {
            return null;
        }
        boolean containsHtml = text.contains("<html>");
        if (containsHtml && (textWithoutHtml = HTMLUtility.getPlainText((String)text)) != null) {
            text = textWithoutHtml;
        }
        text = StringUtility.removeNewLines((String)text);
        text = StringUtility.trim((String)text);
        if (!containsHtml) {
            text = StringUtility.htmlEncode((String)text);
        }
        text = this.replaceSpaces(text);
        return text;
    }

    private String replaceSpaces(String text) {
        return text.replaceAll("\\s", "&#160;");
    }

    private String extractCellDisplayText(IColumn<?> column, ITableRow row) {
        String displayText = column.getDisplayText(row);
        displayText = this.cleanupText(displayText);
        return displayText;
    }

    private String extractColumnHeader(IColumn<?> column) {
        String header = column.getHeaderCell().getText();
        header = this.cleanupText(header);
        return header;
    }

    private boolean isHeaderDescriptionNeeded(ITableRow row, IColumn<?> column) {
        if (column instanceof ISmartColumn) {
            return column.getValue(row) instanceof Boolean;
        }
        if (column instanceof IStringColumn) {
            return this.isNumber((String)((IStringColumn)column).getValue(row));
        }
        return true;
    }

    private boolean isNumber(String value) {
        if (value == null) {
            return false;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

